/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectStatus;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraintColumn;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;

public abstract class OracleTableConstraintBase
extends JDBCTableConstraint<OracleTableBase> {
    private static final Log log = Log.getLog(OracleTableConstraintBase.class);
    private OracleObjectStatus status;
    private List<OracleTableConstraintColumn> columns;

    public OracleTableConstraintBase(OracleTableBase oracleTable, String name, DBSEntityConstraintType constraintType, OracleObjectStatus status, boolean persisted) {
        super((JDBCTable)oracleTable, name, null, constraintType, persisted);
        this.status = status;
    }

    protected OracleTableConstraintBase(OracleTableBase oracleTableBase, String name, String description, DBSEntityConstraintType constraintType, boolean persisted) {
        super((JDBCTable)oracleTableBase, name, description, constraintType, persisted);
    }

    @NotNull
    public OracleDataSource getDataSource() {
        return (OracleDataSource)((OracleTableBase)this.getTable()).getDataSource();
    }

    @Property(viewable=true, editable=false, valueTransformer=DBObjectNameCaseTransformer.class, order=3)
    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return this.constraintType;
    }

    @Property(viewable=true, editable=false, order=9)
    public OracleObjectStatus getStatus() {
        return this.status;
    }

    public List<OracleTableConstraintColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        return this.columns;
    }

    public void addColumn(OracleTableConstraintColumn column) {
        if (this.columns == null) {
            this.columns = new ArrayList<OracleTableConstraintColumn>();
        }
        this.columns.add(column);
    }

    void setColumns(List<OracleTableConstraintColumn> columns) {
        this.columns = columns;
    }
}

