/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleConstants;
import org.jkiss.dbeaver.ext.oracle.model.OracleDDLFormat;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePhysical;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPReferentialIntegrityController;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class OracleTable
extends OracleTablePhysical
implements DBPScriptObject,
DBDPseudoAttributeContainer,
DBPObjectStatistics,
DBPImageProvider,
DBPReferentialIntegrityController,
DBPScriptObjectExt2 {
    private static final Log log = Log.getLog(OracleTable.class);
    private static final CharSequence TABLE_NAME_PLACEHOLDER = "%table_name%";
    private static final CharSequence FOREIGN_KEY_NAME_PLACEHOLDER = "%foreign_key_name%";
    private static final String DISABLE_REFERENTIAL_INTEGRITY_STATEMENT = "ALTER TABLE " + String.valueOf(TABLE_NAME_PLACEHOLDER) + " MODIFY CONSTRAINT " + String.valueOf(FOREIGN_KEY_NAME_PLACEHOLDER) + " DISABLE";
    private static final String ENABLE_REFERENTIAL_INTEGRITY_STATEMENT = "ALTER TABLE " + String.valueOf(TABLE_NAME_PLACEHOLDER) + " MODIFY CONSTRAINT " + String.valueOf(FOREIGN_KEY_NAME_PLACEHOLDER) + " ENABLE";
    private static final String[] supportedOptions = new String[]{"ddl.skipForeignKeys", "ddl.onlyForeignKeys"};
    private OracleDataType tableType;
    private String iotType;
    private String iotName;
    private boolean temporary;
    private boolean secondary;
    private boolean nested;
    private volatile transient Long tableSize;
    private final AdditionalInfo additionalInfo = new AdditionalInfo();

    public OracleTable(OracleSchema schema, String name) {
        super(schema, name);
    }

    public OracleTable(DBRProgressMonitor monitor, OracleSchema schema, ResultSet dbResult) {
        super(schema, dbResult);
        String typeOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_TYPE_OWNER");
        if (!CommonUtils.isEmpty((String)typeOwner)) {
            this.tableType = OracleDataType.resolveDataType(monitor, schema.getDataSource(), typeOwner, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_TYPE"));
        }
        this.iotType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IOT_TYPE");
        this.iotName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IOT_NAME");
        this.temporary = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"TEMPORARY", (String)"Y");
        this.secondary = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"SECONDARY", (String)"Y");
        this.nested = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"NESTED", (String)"Y");
        CommonUtils.isEmpty((String)this.iotName);
    }

    @Override
    public OracleTableBase.TableAdditionalInfo getAdditionalInfo() {
        return this.additionalInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup
    @LazyProperty(cacheValidator=OracleTableBase.AdditionalInfoValidator.class)
    public AdditionalInfo getAdditionalInfo(DBRProgressMonitor monitor) throws DBException {
        AdditionalInfo additionalInfo = this.additionalInfo;
        synchronized (additionalInfo) {
            if (!this.additionalInfo.loaded && monitor != null) {
                this.loadAdditionalInfo(monitor);
            }
            return this.additionalInfo;
        }
    }

    public boolean hasStatistics() {
        return this.tableSize != null;
    }

    public long getStatObjectSize() {
        return this.tableSize == null ? 0L : this.tableSize;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    @Property(viewable=false, category="Statistics", formatter=ByteNumberFormat.class)
    public Long getTableSize(DBRProgressMonitor monitor) throws DBCException {
        if (this.tableSize == null) {
            this.loadSize(monitor);
        }
        return this.tableSize;
    }

    public void setTableSize(Long tableSize) {
        this.tableSize = tableSize;
    }

    private void loadSize(DBRProgressMonitor monitor) throws DBCException {
        this.tableSize = null;
        try {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");){
                    boolean hasDBA = ((OracleDataSource)this.getDataSource()).isViewAvailable(monitor, "SYS", "DBA_SEGMENTS");
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT SUM(bytes) TABLE_SIZE\nFROM " + OracleUtils.getSysSchemaPrefix((OracleDataSource)this.getDataSource()) + (hasDBA ? "DBA_SEGMENTS" : "USER_SEGMENTS") + " s\nWHERE S.SEGMENT_TYPE='TABLE' AND s.SEGMENT_NAME = ?" + (hasDBA ? " AND s.OWNER = ?" : ""));){
                        dbStat.setString(1, this.getName());
                        if (hasDBA) {
                            dbStat.setString(2, this.getSchema().getName());
                        }
                        Throwable throwable3 = null;
                        Object var10_16 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            if (dbResult.next()) {
                                this.fetchTableSize(dbResult);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error reading table statistics", (Throwable)e);
                if (this.tableSize == null) {
                    this.tableSize = 0L;
                }
            }
        }
        finally {
            if (this.tableSize == null) {
                this.tableSize = 0L;
            }
        }
    }

    void fetchTableSize(JDBCResultSet dbResult) throws SQLException {
        this.tableSize = dbResult.getLong("TABLE_SIZE");
    }

    @Override
    protected String getTableTypeName() {
        return "TABLE";
    }

    public boolean isView() {
        return false;
    }

    @Property(viewable=false, order=5)
    public OracleDataType getTableType() {
        return this.tableType;
    }

    @Property(viewable=false, order=6)
    public String getIotType() {
        return this.iotType;
    }

    @Property(viewable=false, order=7)
    public String getIotName() {
        return this.iotName;
    }

    @Property(viewable=false, order=10)
    public boolean isTemporary() {
        return this.temporary;
    }

    @Property(viewable=false, order=11)
    public boolean isSecondary() {
        return this.secondary;
    }

    @Property(viewable=false, order=12)
    public boolean isNested() {
        return this.nested;
    }

    @Override
    public OracleTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return super.getAttribute(monitor, attributeName);
    }

    @Nullable
    private OracleTableColumn getXMLColumn(DBRProgressMonitor monitor) throws DBException {
        for (OracleTableColumn col : CommonUtils.safeCollection(this.getAttributes(monitor))) {
            if (col.getDataType() != this.tableType) continue;
            return col;
        }
        return null;
    }

    @Override
    public Collection<OracleTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<OracleTableForeignKey> refs = new ArrayList<OracleTableForeignKey>();
        List allForeignKeys = ((OracleSchema)this.getContainer()).foreignKeyCache.getObjects(monitor, (OracleSchema)this.getContainer(), null);
        for (OracleTableForeignKey constraint : allForeignKeys) {
            if (constraint.getReferencedTable() != this) continue;
            refs.add(constraint);
        }
        return refs;
    }

    @Override
    @Association
    public Collection<OracleTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((OracleSchema)this.getContainer()).foreignKeyCache.getObjects(monitor, (OracleSchema)this.getContainer(), this);
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((OracleSchema)this.getContainer()).foreignKeyCache.clearObjectCache(this);
        if (this.tableSize != null) {
            this.tableSize = null;
            this.getTableSize(monitor);
        }
        this.additionalInfo.loaded = false;
        return super.refreshObject(monitor);
    }

    public DBDPseudoAttribute[] getPseudoAttributes() throws DBException {
        if (CommonUtils.isEmpty((String)this.iotType) && ((OracleDataSource)this.getDataSource()).getContainer().getPreferenceStore().getBoolean("oracle.support.rowid")) {
            return new DBDPseudoAttribute[]{OracleConstants.PSEUDO_ATTR_ROWID};
        }
        return null;
    }

    protected void appendSelectSource(DBRProgressMonitor monitor, StringBuilder query, String tableAlias, DBDPseudoAttribute rowIdAttribute) throws DBCException {
        if (this.tableType != null && this.tableType.getName().equals("XMLTYPE")) {
            try {
                OracleTableColumn xmlColumn = this.getXMLColumn(monitor);
                if (xmlColumn != null) {
                    query.append("XMLType(").append(tableAlias).append(".").append(xmlColumn.getName()).append(".getClobval()) as ").append(xmlColumn.getName());
                    if (rowIdAttribute != null) {
                        query.append(",").append(rowIdAttribute.translateExpression(tableAlias));
                    }
                    return;
                }
            }
            catch (DBException e) {
                log.warn((Object)e);
            }
        }
        super.appendSelectSource(monitor, query, tableAlias, rowIdAttribute);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.getDDL(monitor, OracleDDLFormat.getCurrentFormat(this.getDataSource()), options);
    }

    @Nullable
    public DBPImage getObjectImage() {
        if (CommonUtils.isEmpty((String)this.iotType)) {
            return DBIcon.TREE_TABLE;
        }
        return DBIcon.TREE_TABLE_INDEX;
    }

    private void loadAdditionalInfo(DBRProgressMonitor monitor) throws DBException {
        if (!this.isPersisted()) {
            this.additionalInfo.loaded = true;
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");){
            try {
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT a.*, h.STATS_UPDATE_TIME FROM " + OracleUtils.getAdminAllViewPrefix(monitor, (OracleDataSource)this.getDataSource(), "TABLES") + " a, ALL_TAB_STATS_HISTORY h WHERE h.OWNER(+) = a.OWNER AND h.TABLE_NAME(+) = a.TABLE_NAME AND a.OWNER=? AND a.TABLE_NAME=?");){
                    dbStat.setString(1, ((OracleSchema)this.getContainer()).getName());
                    dbStat.setString(2, this.getName());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.additionalInfo.pctFree = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PCT_FREE");
                            this.additionalInfo.pctUsed = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PCT_USED");
                            this.additionalInfo.iniTrans = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"INI_TRANS");
                            this.additionalInfo.maxTrans = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"MAX_TRANS");
                            this.additionalInfo.initialExtent = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"INITIAL_EXTENT");
                            this.additionalInfo.nextExtent = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"NEXT_EXTENT");
                            this.additionalInfo.minExtents = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"MIN_EXTENTS");
                            this.additionalInfo.maxExtents = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"MAX_EXTENTS");
                            this.additionalInfo.pctIncrease = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PCT_INCREASE");
                            this.additionalInfo.freelists = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"FREELISTS");
                            this.additionalInfo.freelistGroups = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"FREELIST_GROUPS");
                            this.additionalInfo.blocks = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"BLOCKS");
                            this.additionalInfo.emptyBlocks = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"EMPTY_BLOCKS");
                            this.additionalInfo.avgSpace = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"AVG_SPACE");
                            this.additionalInfo.chainCount = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"CHAIN_CNT");
                            this.additionalInfo.avgRowLen = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"AVG_ROW_LEN");
                            this.additionalInfo.avgSpaceFreelistBlocks = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"AVG_SPACE_FREELIST_BLOCKS");
                            this.additionalInfo.numFreelistBlocks = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"NUM_FREELIST_BLOCKS");
                            this.additionalInfo.lastStatisticsUpdate = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"STATS_UPDATE_TIME");
                        } else {
                            log.warn((Object)("Cannot find table '" + this.getFullyQualifiedName(DBPEvaluationContext.UI) + "' metadata"));
                        }
                        this.additionalInfo.loaded = true;
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public void enableReferentialIntegrity(@NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        Collection<OracleTableForeignKey> foreignKeys = this.getAssociations(monitor);
        if (CommonUtils.isEmpty(foreignKeys)) {
            return;
        }
        String template = enable ? ENABLE_REFERENTIAL_INTEGRITY_STATEMENT : DISABLE_REFERENTIAL_INTEGRITY_STATEMENT;
        template = template.replace(TABLE_NAME_PLACEHOLDER, this.getFullyQualifiedName(DBPEvaluationContext.DDL));
        Throwable throwable = null;
        Object var6_7 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Changing referential integrity");){
            try {
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (JDBCStatement statement = session.createStatement();){
                    for (DBPNamedObject dBPNamedObject : foreignKeys) {
                        String sql = template.replace(FOREIGN_KEY_NAME_PLACEHOLDER, dBPNamedObject.getName());
                        statement.executeUpdate(sql);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBException("Unable to change referential integrity", (Throwable)e);
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public boolean supportsChangingReferentialIntegrity(@NotNull DBRProgressMonitor monitor) throws DBException {
        return !CommonUtils.isEmpty(this.getAssociations(monitor));
    }

    @Nullable
    public String getChangeReferentialIntegrityStatement(@NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        if (!this.supportsChangingReferentialIntegrity(monitor)) {
            return null;
        }
        if (enable) {
            return ENABLE_REFERENTIAL_INTEGRITY_STATEMENT;
        }
        return DISABLE_REFERENTIAL_INTEGRITY_STATEMENT;
    }

    public boolean supportsObjectDefinitionOption(String option) {
        return ArrayUtils.contains((Object[])supportedOptions, (Object)option);
    }

    public class AdditionalInfo
    extends OracleTableBase.TableAdditionalInfo {
        private int pctFree;
        private int pctUsed;
        private int iniTrans;
        private int maxTrans;
        private int initialExtent;
        private int nextExtent;
        private int minExtents;
        private int maxExtents;
        private int pctIncrease;
        private int freelists;
        private int freelistGroups;
        private int blocks;
        private int emptyBlocks;
        private int avgSpace;
        private int chainCount;
        private int avgRowLen;
        private int avgSpaceFreelistBlocks;
        private int numFreelistBlocks;
        private Date lastStatisticsUpdate;

        @Property(category="Statistics", order=31)
        public int getPctFree() {
            return this.pctFree;
        }

        @Property(category="Statistics", order=32)
        public int getPctUsed() {
            return this.pctUsed;
        }

        @Property(category="Statistics", order=33)
        public int getIniTrans() {
            return this.iniTrans;
        }

        @Property(category="Statistics", order=34)
        public int getMaxTrans() {
            return this.maxTrans;
        }

        @Property(category="Statistics", order=35)
        public int getInitialExtent() {
            return this.initialExtent;
        }

        @Property(category="Statistics", order=36)
        public int getNextExtent() {
            return this.nextExtent;
        }

        @Property(category="Statistics", order=37)
        public int getMinExtents() {
            return this.minExtents;
        }

        @Property(category="Statistics", order=38)
        public int getMaxExtents() {
            return this.maxExtents;
        }

        @Property(category="Statistics", order=39)
        public int getPctIncrease() {
            return this.pctIncrease;
        }

        @Property(category="Statistics", order=40)
        public int getFreelists() {
            return this.freelists;
        }

        @Property(category="Statistics", order=41)
        public int getFreelistGroups() {
            return this.freelistGroups;
        }

        @Property(category="Statistics", order=42)
        public int getBlocks() {
            return this.blocks;
        }

        @Property(category="Statistics", order=43)
        public int getEmptyBlocks() {
            return this.emptyBlocks;
        }

        @Property(category="Statistics", order=44)
        public int getAvgSpace() {
            return this.avgSpace;
        }

        @Property(category="Statistics", order=45)
        public int getChainCount() {
            return this.chainCount;
        }

        @Property(category="Statistics", order=46)
        public int getAvgRowLen() {
            return this.avgRowLen;
        }

        @Property(category="Statistics", order=47)
        public int getAvgSpaceFreelistBlocks() {
            return this.avgSpaceFreelistBlocks;
        }

        @Property(category="Statistics", order=48)
        public int getNumFreelistBlocks() {
            return this.numFreelistBlocks;
        }

        @Property(category="Statistics", order=29)
        public Date getLastStatisticsUpdate() {
            return this.lastStatisticsUpdate;
        }
    }
}

