/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDependencyGroup;
import org.jkiss.dbeaver.ext.oracle.model.OracleObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleProcedureArgument;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.IntKeyMap;

public abstract class OracleProcedureBase<PARENT extends DBSObjectContainer>
extends OracleObject<PARENT>
implements DBSProcedure {
    static final Log log = Log.getLog(OracleProcedureBase.class);
    private DBSProcedureType procedureType;
    private final ArgumentsCache argumentsCache = new ArgumentsCache();

    public OracleProcedureBase(PARENT parent, String name, long objectId, DBSProcedureType procedureType) {
        super(parent, name, objectId, true);
        this.procedureType = procedureType;
    }

    @Property(viewable=true, editable=true, order=3)
    public DBSProcedureType getProcedureType() {
        return this.procedureType;
    }

    public void setProcedureType(DBSProcedureType procedureType) {
        this.procedureType = procedureType;
    }

    public DBSObjectContainer getContainer() {
        return (DBSObjectContainer)this.getParentObject();
    }

    public abstract OracleSchema getSchema();

    public abstract Integer getOverloadNumber();

    public Collection<OracleProcedureArgument> getParameters(DBRProgressMonitor monitor) throws DBException {
        return this.argumentsCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<OracleDependencyGroup> getDependencies(DBRProgressMonitor monitor) {
        return OracleDependencyGroup.of(this);
    }

    static class ArgumentsCache
    extends JDBCObjectCache<OracleProcedureBase, OracleProcedureArgument> {
        ArgumentsCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleProcedureBase procedure) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getSysSchemaPrefix(procedure.getDataSource()) + "ALL_ARGUMENTS WHERE " + (procedure.getObjectId() <= 0L ? "OWNER=? AND OBJECT_NAME=? AND PACKAGE_NAME=? " : "OBJECT_ID=? ") + (procedure.getOverloadNumber() != null ? "AND OVERLOAD=? " : "AND OVERLOAD IS NULL ") + "\nORDER BY SEQUENCE");
            int paramNum = 1;
            if (procedure.getObjectId() <= 0L) {
                dbStat.setString(paramNum++, procedure.getSchema().getName());
                dbStat.setString(paramNum++, procedure.getName());
                dbStat.setString(paramNum++, procedure.getContainer().getName());
            } else {
                dbStat.setLong(paramNum++, procedure.getObjectId());
            }
            if (procedure.getOverloadNumber() != null) {
                dbStat.setInt(paramNum, procedure.getOverloadNumber().intValue());
            }
            return dbStat;
        }

        protected OracleProcedureArgument fetchObject(@NotNull JDBCSession session, @NotNull OracleProcedureBase procedure, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleProcedureArgument(session.getProgressMonitor(), procedure, (ResultSet)resultSet);
        }

        protected void invalidateObjects(DBRProgressMonitor monitor, OracleProcedureBase owner, Iterator<OracleProcedureArgument> objectIter) {
            IntKeyMap argStack = new IntKeyMap();
            while (objectIter.hasNext()) {
                OracleProcedureArgument argument = objectIter.next();
                int curDataLevel = argument.getDataLevel();
                argStack.put(curDataLevel, (Object)argument);
                if (curDataLevel <= 0) continue;
                objectIter.remove();
                OracleProcedureArgument parentArgument = (OracleProcedureArgument)argStack.get(curDataLevel - 1);
                if (parentArgument == null) {
                    log.error((Object)("Broken arguments structure for '" + argument.getParentObject().getFullyQualifiedName(DBPEvaluationContext.DDL) + "' - no parent argument for argument " + argument.getSequence()));
                    continue;
                }
                parentArgument.addAttribute(argument);
            }
        }
    }
}

