/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectValidateAction;
import org.jkiss.dbeaver.ext.oracle.model.OraclePackage;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class OraclePackageManager
extends SQLObjectEditor<OraclePackage, OracleSchema> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, OraclePackage> getObjectsCache(OraclePackage object) {
        return object.getSchema().packageCache;
    }

    protected OraclePackage createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new OraclePackage((OracleSchema)container, "NEW_PACKAGE");
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand objectCreateCommand, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(executionContext, actions, (OraclePackage)objectCreateCommand.getObject());
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand objectDeleteCommand, Map<String, Object> options) {
        OraclePackage object = (OraclePackage)objectDeleteCommand.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop package", "DROP PACKAGE " + object.getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand objectChangeCommand, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(executionContext, actionList, (OraclePackage)objectChangeCommand.getObject());
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    private void createOrReplaceProcedureQuery(DBCExecutionContext executionContext, List<DBEPersistAction> actionList, OraclePackage pack) {
        try {
            Object body;
            Object header = pack.getObjectDefinitionText((DBRProgressMonitor)new VoidProgressMonitor(), DBPScriptObject.EMPTY_OPTIONS).trim();
            if (!((String)header).endsWith(";")) {
                header = (String)header + ";";
            }
            if (!CommonUtils.isEmpty((String)header)) {
                actionList.add((DBEPersistAction)new OracleObjectValidateAction(pack, OracleObjectType.PACKAGE, "Create package header", (String)header));
            }
            if (!CommonUtils.isEmpty((String)(body = pack.getExtendedDefinitionText((DBRProgressMonitor)new VoidProgressMonitor())))) {
                if (!((String)(body = ((String)body).trim())).endsWith(";")) {
                    body = (String)body + ";";
                }
                actionList.add((DBEPersistAction)new OracleObjectValidateAction(pack, OracleObjectType.PACKAGE_BODY, "Create package body", (String)body));
            } else {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Drop package header", "DROP PACKAGE BODY " + pack.getFullyQualifiedName(DBPEvaluationContext.DDL), DBEPersistAction.ActionType.OPTIONAL));
            }
        }
        catch (DBException e) {
            log.warn((Object)e);
        }
        OracleUtils.addSchemaChangeActions(executionContext, actionList, pack);
    }
}

