/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardActivator;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardEditDialog;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class DashboardManagerDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.DashboardManagerDialog";
    private DashboardDescriptor selectedDashboard;
    private Button newButton;
    private Button copyButton;
    private Button editButton;
    private Button deleteButton;
    private TreeViewer treeViewer;

    public DashboardManagerDialog(Shell shell) {
        super(shell, UIDashboardMessages.dialog_dashboard_manager_title, null);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getSettingsSection((IDialogSettings)UIDashboardActivator.getDefault().getDialogSettings(), (String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        this.getShell().setMinimumSize(300, 300);
        Composite dialogArea = super.createDialogArea(parent);
        Composite group = UIUtils.createPlaceholder((Composite)dialogArea, (int)2);
        group.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new TreeViewer(group, 2048);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.treeViewer.getControl().setLayoutData((Object)gd);
        this.treeViewer.getTree().setHeaderVisible(true);
        UIUtils.createTreeColumn((Tree)this.treeViewer.getTree(), (int)16384, (String)UIDashboardMessages.dialog_dashboard_manager_treecolumn_name);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                List<DashboardDescriptor> result = null;
                if (parentElement instanceof List) {
                    result = (List<DashboardDescriptor>)parentElement;
                } else if (parentElement instanceof DBPDataSourceProviderDescriptor) {
                    result = DashboardRegistry.getInstance().getDashboards((DBPNamedObject)((DBPDataSourceProviderDescriptor)parentElement), false);
                } else if (parentElement instanceof DBPDriver) {
                    result = DashboardRegistry.getInstance().getDashboards((DBPNamedObject)((DBPDriver)parentElement), false);
                }
                if (result == null) {
                    return new Object[0];
                }
                result.sort(DBUtils.nameComparator());
                return result.toArray();
            }

            public boolean hasChildren(Object element) {
                return !(element instanceof DashboardDescriptor);
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DBPNamedObject element = (DBPNamedObject)cell.getElement();
                if (cell.getColumnIndex() == 0) {
                    DashboardDescriptor dashboardDescriptor;
                    Object icon;
                    cell.setText(element.getName());
                    if (element instanceof DBPDriver) {
                        cell.setImage(DBeaverIcons.getImage((DBPImage)((DBPDriver)element).getIcon()));
                    } else if (element instanceof DBPDataSourceProviderDescriptor) {
                        cell.setImage(DBeaverIcons.getImage((DBPImage)((DBPDataSourceProviderDescriptor)element).getIcon()));
                    } else if (element instanceof DashboardDescriptor && (icon = (dashboardDescriptor = (DashboardDescriptor)element).isCustom() ? DBIcon.TYPE_OBJECT : dashboardDescriptor.getDefaultViewType().getIcon()) != null) {
                        cell.setImage(DBeaverIcons.getImage((DBPImage)icon));
                    }
                } else if (element instanceof DBPDriver) {
                    cell.setText(CommonUtils.notEmpty((String)((DBPDriver)element).getDescription()));
                } else if (element instanceof DBPDataSourceProviderDescriptor) {
                    cell.setText(((DBPDataSourceProviderDescriptor)element).getDescription());
                }
            }
        });
        this.treeViewer.setInput(DashboardRegistry.getInstance().getAllSupportedSources());
        this.treeViewer.addDoubleClickListener(event -> {
            if (this.selectedDashboard != null) {
                this.editDashboard();
            }
        });
        this.treeViewer.addSelectionChangedListener(event -> {
            Object selectedObject;
            this.selectedDashboard = null;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof DashboardDescriptor) {
                this.selectedDashboard = (DashboardDescriptor)((Object)((Object)selectedObject));
            }
            this.updateButtons();
        });
        UIUtils.asyncExec(() -> {
            this.treeViewer.expandAll();
            UIUtils.packColumns((Tree)this.treeViewer.getTree(), (boolean)true, null);
        });
        Composite buttonBar = new Composite(group, 128);
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        GridData gd2 = new GridData(1040);
        buttonBar.setLayoutData((Object)gd2);
        this.newButton = UIUtils.createPushButton((Composite)buttonBar, (String)UIDashboardMessages.dialog_dashboard_manager_button_new, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardManagerDialog.this.createDashboard();
            }
        });
        this.newButton.setLayoutData((Object)new GridData(768));
        this.copyButton = UIUtils.createPushButton((Composite)buttonBar, (String)UIDashboardMessages.dialog_dashboard_manager_button_copy, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardManagerDialog.this.copyDashboard();
            }
        });
        this.copyButton.setLayoutData((Object)new GridData(768));
        this.editButton = UIUtils.createPushButton((Composite)buttonBar, (String)UIDashboardMessages.dialog_dashboard_manager_button_edit, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardManagerDialog.this.editDashboard();
            }
        });
        this.editButton.setLayoutData((Object)new GridData(768));
        this.deleteButton = UIUtils.createPushButton((Composite)buttonBar, (String)UIDashboardMessages.dialog_dashboard_manager_button_delete, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardManagerDialog.this.deleteDashboard();
            }
        });
        this.deleteButton.setLayoutData((Object)new GridData(768));
        UIUtils.createInfoLabel((Composite)dialogArea, (String)UIDashboardMessages.dialog_dashboard_manager_infolabel_predifined_dashboard);
        this.updateButtons();
        return group;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.setReturnCode(0);
            this.close();
        }
    }

    private void updateButtons() {
        this.newButton.setEnabled(true);
        this.copyButton.setEnabled(this.selectedDashboard != null);
        this.editButton.setEnabled(this.selectedDashboard != null);
        this.deleteButton.setEnabled(this.selectedDashboard != null && this.selectedDashboard.isCustom());
    }

    private void createDashboard() {
        DashboardDescriptor newDashboard = new DashboardDescriptor("", "", "", "");
        DashboardEditDialog editDialog = new DashboardEditDialog(this.getShell(), newDashboard);
        if (editDialog.open() == 0) {
            DashboardRegistry.getInstance().createDashboard(newDashboard);
            this.refreshDashboards();
        }
    }

    private void copyDashboard() {
        DashboardDescriptor newDashboard = new DashboardDescriptor(this.selectedDashboard);
        newDashboard.setCustom(true);
        String origId = newDashboard.getId();
        int i = 2;
        while (DashboardRegistry.getInstance().getDashboard(newDashboard.getId()) != null) {
            newDashboard.setId(origId + " " + i);
            ++i;
        }
        DashboardEditDialog editDialog = new DashboardEditDialog(this.getShell(), newDashboard);
        if (editDialog.open() == 0) {
            DashboardRegistry.getInstance().createDashboard(newDashboard);
            this.refreshDashboards();
        }
    }

    private void editDashboard() {
        DashboardEditDialog editDialog = new DashboardEditDialog(this.getShell(), this.selectedDashboard);
        if (editDialog.open() == 0) {
            DashboardRegistry.getInstance().saveSettings();
            this.refreshDashboards();
        }
    }

    private void deleteDashboard() {
        if (this.selectedDashboard == null || !this.selectedDashboard.isCustom()) {
            return;
        }
        if (UIUtils.confirmAction((Shell)this.getShell(), (String)UIDashboardMessages.dialog_dashboard_manager_shell_delete_title, (String)NLS.bind((String)UIDashboardMessages.dialog_dashboard_manager_shell_delete_question, (Object)this.selectedDashboard.getName()))) {
            DashboardRegistry.getInstance().removeDashboard(this.selectedDashboard);
            this.selectedDashboard = null;
            this.refreshDashboards();
        }
    }

    private void refreshDashboards() {
        this.treeViewer.setInput(DashboardRegistry.getInstance().getAllSupportedSources());
        this.treeViewer.expandAll();
        this.updateButtons();
    }
}

