/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.model;

import java.text.NumberFormat;
import java.time.Duration;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.StandardTickUnitSource;
import org.jfree.chart.axis.TickUnitSource;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardValueType;
import org.jkiss.utils.ByteNumberFormat;

public class DashboardUtils {
    private static final Log log = Log.getLog(DashboardUtils.class);

    public static long parseDuration(String duration, long defValue) {
        if (!((String)duration).startsWith("PT")) {
            duration = "PT" + (String)duration;
        }
        duration = ((String)duration).replace(" ", "");
        try {
            Duration newDuration = Duration.parse((CharSequence)duration);
            return newDuration.toMillis();
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static String formatDuration(long duration) {
        return Duration.ofMillis(duration).toString().substring(2);
    }

    public static TickUnitSource getTickUnitsSource(DashboardValueType valueType) {
        switch (valueType) {
            case decimal: {
                return new NumberTickUnitSource(false);
            }
            case integer: 
            case percent: {
                return new NumberTickUnitSource(true);
            }
            case bytes: {
                return new NumberTickUnitSource(true, (NumberFormat)new ByteNumberFormat());
            }
        }
        return new StandardTickUnitSource();
    }
}

