/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.impl.ProviderPropertyDescriptor;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeDescriptor;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeIcon;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadataRegistry;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.NativeClientDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.MissingDataSourceProvider;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public class DataSourceProviderDescriptor
extends AbstractDescriptor
implements DBPDataSourceProviderDescriptor {
    private static final Log log = Log.getLog(DataSourceProviderDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataSourceProvider";
    public static final DataSourceProviderDescriptor NULL_PROVIDER = new DataSourceProviderDescriptor(null, "NULL");
    private DataSourceProviderRegistry registry;
    private DataSourceProviderDescriptor parentProvider;
    private final String id;
    private AbstractDescriptor.ObjectType implType;
    private final String name;
    private final String description;
    private final boolean temporary;
    private DBPImage icon;
    private DBPDataSourceProvider instance;
    private DBXTreeDescriptor treeDescriptor;
    private final Map<String, DBXTreeNode> treeNodeMap = new HashMap<String, DBXTreeNode>();
    private boolean driversManagable;
    private boolean supportsDriverMigration;
    private final List<DBPPropertyDescriptor> driverProperties = new ArrayList<DBPPropertyDescriptor>();
    private final List<DriverDescriptor> drivers = new ArrayList<DriverDescriptor>();
    private final List<NativeClientDescriptor> nativeClients = new ArrayList<NativeClientDescriptor>();
    private final List<DBPDataSourceProviderDescriptor> childrenProviders = new ArrayList<DBPDataSourceProviderDescriptor>();
    @NotNull
    private SQLDialectMetadata scriptDialect;
    private boolean inheritClients;

    public DataSourceProviderDescriptor(DataSourceProviderRegistry registry, IConfigurationElement config) {
        super(config);
        Object[] trees;
        String dialectId;
        this.registry = registry;
        this.temporary = false;
        this.id = config.getAttribute("id");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        if (this.icon == null) {
            this.icon = DBIcon.DATABASE_DEFAULT;
        }
        if (CommonUtils.isEmpty((String)(dialectId = config.getAttribute("dialect")))) {
            log.debug((Object)("No SQL dialect specified for data source provider '" + this.id + "'. Use default."));
            dialectId = "basic";
        }
        SQLDialectMetadataRegistry dialectRegistry = DBWorkbench.getPlatform().getSQLDialectRegistry();
        this.scriptDialect = dialectRegistry.getDialect(dialectId);
        if (this.scriptDialect == null) {
            log.debug((Object)("Script dialect '" + dialectId + "' not found in registry (for data source provider " + this.id + "). Use default."));
            this.scriptDialect = dialectRegistry.getDialect("basic");
        }
        if (!ArrayUtils.isEmpty((Object[])(trees = config.getChildren("tree")))) {
            this.treeDescriptor = this.loadTreeInfo((IConfigurationElement)trees[0]);
        }
        this.supportsDriverMigration = CommonUtils.toBoolean((Object)config.getAttribute("supports-migration"));
    }

    void linkParentProvider(IConfigurationElement config) {
        String parentId = config.getAttribute("parent");
        if (!CommonUtils.isEmpty((String)parentId)) {
            this.parentProvider = this.registry.getDataSourceProvider(parentId);
            if (this.parentProvider == null) {
                log.error((Object)("Provider '" + parentId + "' not found"));
            } else {
                this.parentProvider.addChildrenProvider(this);
            }
        }
    }

    void loadExtraConfig(IConfigurationElement config) {
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        int n3;
        Object[] injections;
        if (this.treeDescriptor == null && this.parentProvider != null) {
            this.treeDescriptor = new DBXTreeDescriptor((AbstractDescriptor)this, this.parentProvider.getTreeDescriptor());
        }
        if (!ArrayUtils.isEmpty((Object[])(injections = config.getChildren("treeInjection")))) {
            Object[] objectArray = injections;
            int n4 = injections.length;
            n3 = 0;
            while (n3 < n4) {
                Object treeInject = objectArray[n3];
                this.injectTreeNodes((IConfigurationElement)treeInject);
                ++n3;
            }
        }
        if (this.parentProvider != null) {
            this.driverProperties.addAll(this.parentProvider.driverProperties);
        }
        IConfigurationElement[] iConfigurationElementArray2 = config.getChildren("driver-properties");
        n3 = iConfigurationElementArray2.length;
        int n5 = 0;
        while (n5 < n3) {
            IConfigurationElement propsElement = iConfigurationElementArray2[n5];
            iConfigurationElementArray = propsElement.getChildren("propertyGroup");
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement prop = iConfigurationElementArray[n];
                this.driverProperties.addAll(PropertyDescriptor.extractProperties((IConfigurationElement)prop));
                ++n;
            }
            ++n5;
        }
        iConfigurationElementArray2 = config.getChildren("drivers");
        n3 = iConfigurationElementArray2.length;
        n5 = 0;
        while (n5 < n3) {
            IConfigurationElement driversElement = iConfigurationElementArray2[n5];
            this.driversManagable = driversElement.getAttribute("managable") == null || CommonUtils.getBoolean((String)driversElement.getAttribute("managable"));
            iConfigurationElementArray = driversElement.getChildren("driver");
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement driverElement = iConfigurationElementArray[n];
                try {
                    this.drivers.add(this.loadDriver(driverElement));
                }
                catch (Exception e) {
                    log.error((Object)"Error loading driver", (Throwable)e);
                }
                ++n;
            }
            iConfigurationElementArray = driversElement.getChildren("provider-properties");
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                List<DriverDescriptor> appDrivers;
                IConfigurationElement propsElement = iConfigurationElementArray[n];
                String driversSpec = propsElement.getAttribute("drivers");
                ArrayList providerProperties = new ArrayList();
                IConfigurationElement[] iConfigurationElementArray3 = propsElement.getChildren("propertyGroup");
                int n6 = iConfigurationElementArray3.length;
                int n7 = 0;
                while (n7 < n6) {
                    IConfigurationElement prop = iConfigurationElementArray3[n7];
                    providerProperties.addAll(ProviderPropertyDescriptor.extractProviderProperties((IConfigurationElement)prop));
                    ++n7;
                }
                if (CommonUtils.isEmpty((String)driversSpec) || driversSpec.equals("*")) {
                    appDrivers = this.drivers;
                } else {
                    String[] driverIds = driversSpec.split(",");
                    appDrivers = this.drivers.stream().filter(d -> ArrayUtils.contains((Object[])driverIds, (Object)d.getId())).collect(Collectors.toList());
                }
                appDrivers.forEach(d -> d.addProviderPropertyDescriptors(providerProperties));
                ++n;
            }
            ++n5;
        }
        this.inheritClients = CommonUtils.getBoolean((String)config.getAttribute("inheritClients"), (boolean)false);
        iConfigurationElementArray2 = config.getChildren("nativeClients");
        n3 = iConfigurationElementArray2.length;
        n5 = 0;
        while (n5 < n3) {
            IConfigurationElement nativeClientsElement = iConfigurationElementArray2[n5];
            iConfigurationElementArray = nativeClientsElement.getChildren("client");
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement clientElement = iConfigurationElementArray[n];
                this.nativeClients.add(new NativeClientDescriptor(clientElement));
                ++n;
            }
            ++n5;
        }
    }

    DataSourceProviderDescriptor(DataSourceProviderRegistry registry, String id) {
        super("org.jkiss.dbeaver.registry");
        this.registry = registry;
        this.id = id;
        this.name = id;
        this.description = "Missing datasource provider " + id;
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, MissingDataSourceProvider.class.getName());
        this.temporary = true;
        this.treeDescriptor = new DBXTreeDescriptor((AbstractDescriptor)this, null, null, id, id, false, true, false, false, true, null, null);
        this.scriptDialect = DBWorkbench.getPlatform().getSQLDialectRegistry().getDialect("basic");
    }

    void patchConfigurationFrom(IConfigurationElement config) {
        Object[] injections = config.getChildren("treeInjection");
        if (!ArrayUtils.isEmpty((Object[])injections)) {
            Object[] objectArray = injections;
            int n = injections.length;
            int n2 = 0;
            while (n2 < n) {
                Object treeInject = objectArray[n2];
                this.injectTreeNodes((IConfigurationElement)treeInject);
                ++n2;
            }
        }
    }

    public void dispose() {
        this.drivers.clear();
        this.instance = null;
    }

    public DataSourceProviderRegistry getRegistry() {
        return this.registry;
    }

    public DataSourceProviderDescriptor getParentProvider() {
        return this.parentProvider;
    }

    public boolean matchesId(String id) {
        if (id.equals(this.id)) {
            return true;
        }
        return this.parentProvider != null && this.parentProvider.matchesId(id);
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return CommonUtils.toString((Object)this.name, (String)this.id);
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    @NotNull
    public DBPDataSourceProvider getInstance(DriverDescriptor driver) {
        if (this.instance == null) {
            this.initProviderBundle(driver);
            try {
                this.instance = (DBPDataSourceProvider)this.implType.createInstance(DBPDataSourceProvider.class);
                this.instance.init(DBWorkbench.getPlatform());
            }
            catch (Throwable ex) {
                this.instance = null;
                throw new IllegalStateException("Can't initialize data source provider '" + this.implType.getImplName() + "'", ex);
            }
        }
        return this.instance;
    }

    void replaceImplClass(IContributor contributor, String providerClass) {
        this.replaceContributor(contributor);
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, providerClass);
    }

    public DBXTreeDescriptor getTreeDescriptor() {
        return this.treeDescriptor == null ? (this.parentProvider == null ? null : this.parentProvider.getTreeDescriptor()) : this.treeDescriptor;
    }

    @NotNull
    public SQLDialectMetadata getScriptDialect() {
        return this.scriptDialect;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isDriversManagable() {
        return this.driversManagable;
    }

    public boolean supportsDriverMigration() {
        return this.supportsDriverMigration;
    }

    public List<DBPPropertyDescriptor> getDriverProperties() {
        return this.driverProperties;
    }

    public DBPPropertyDescriptor getDriverProperty(String name) {
        for (DBPPropertyDescriptor prop : this.driverProperties) {
            if (!prop.getId().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public List<DriverDescriptor> getDrivers() {
        return this.drivers;
    }

    public List<DriverDescriptor> getEnabledDrivers() {
        ArrayList<DriverDescriptor> eDrivers = new ArrayList<DriverDescriptor>();
        for (DriverDescriptor driver : this.drivers) {
            if (driver.isDisabled() || driver.getReplacedBy() != null || !driver.isSupportedByLocalSystem()) continue;
            eDrivers.add(driver);
        }
        return eDrivers;
    }

    @Nullable
    public DriverDescriptor getDriver(@NotNull String id) {
        for (DriverDescriptor driver : this.drivers) {
            if (!driver.getId().equals(id)) continue;
            while (driver.getReplacedBy() != null) {
                driver = driver.getReplacedBy();
            }
            return driver;
        }
        return null;
    }

    @Nullable
    public DriverDescriptor getOriginalDriver(@NotNull String id) {
        for (DriverDescriptor driver : this.drivers) {
            if (!driver.getId().equals(id)) continue;
            return driver;
        }
        return null;
    }

    public DriverDescriptor createDriver() {
        return this.createDriver(SecurityUtils.generateGUID((boolean)false));
    }

    public DriverDescriptor createDriver(String id) {
        return new DriverDescriptor(this, id);
    }

    public DriverDescriptor createDriver(DriverDescriptor copyFrom) {
        return new DriverDescriptor(this, SecurityUtils.generateGUID((boolean)false), copyFrom);
    }

    public void addDriver(DriverDescriptor driver) {
        this.drivers.add(driver);
    }

    public boolean removeDriver(DriverDescriptor driver) {
        if (!driver.isCustom()) {
            driver.setDisabled(true);
            driver.setModified(true);
            return true;
        }
        return this.drivers.remove((Object)driver);
    }

    @NotNull
    public List<DBPDataSourceProviderDescriptor> getChildrenProviders() {
        return this.childrenProviders;
    }

    private void addChildrenProvider(@NotNull DataSourceProviderDescriptor descriptor) {
        this.childrenProviders.add(descriptor);
    }

    public List<NativeClientDescriptor> getNativeClients() {
        if (this.inheritClients && this.parentProvider != null) {
            ArrayList<NativeClientDescriptor> clients = new ArrayList<NativeClientDescriptor>(this.nativeClients);
            clients.addAll(this.parentProvider.getNativeClients());
            return clients;
        }
        return this.nativeClients;
    }

    private void initProviderBundle(DriverDescriptor driver) {
    }

    private DBXTreeDescriptor loadTreeInfo(IConfigurationElement config) {
        DBXTreeDescriptor treeRoot = new DBXTreeDescriptor((AbstractDescriptor)this, null, config, config.getAttribute("path"), null, false, true, false, false, false, config.getAttribute("visibleIf"), null);
        this.loadTreeChildren(config, (DBXTreeNode)treeRoot, null);
        this.loadTreeIcon((DBXTreeNode)treeRoot, config);
        return treeRoot;
    }

    private void injectTreeNodes(IConfigurationElement config) {
        String changeFolderType;
        String injectPath = config.getAttribute("path");
        if (CommonUtils.isEmpty((String)injectPath)) {
            return;
        }
        String[] path = injectPath.split("/");
        if (path.length <= 0) {
            return;
        }
        if (!path[0].equals(this.treeDescriptor.getPath())) {
            return;
        }
        DBXTreeDescriptor baseItem = this.treeDescriptor;
        int i = 1;
        while (i < path.length) {
            if ((baseItem = baseItem.findChildItemByPath(path[i])) == null) {
                return;
            }
            ++i;
        }
        DBXTreeDescriptor parentNode = baseItem;
        if (CommonUtils.getBoolean((String)config.getAttribute("replaceChildren"))) {
            baseItem.clearChildren();
        }
        if ((changeFolderType = config.getAttribute("changeFolderType")) != null) {
            DBXTreeNode folderNode = baseItem.getParent();
            if (folderNode instanceof DBXTreeFolder) {
                ((DBXTreeFolder)folderNode).setType(changeFolderType);
            } else {
                log.error((Object)("Can't update folder type to " + changeFolderType));
            }
        } else {
            String afterPath = config.getAttribute("after");
            DBXTreeItem afterItem = null;
            if (afterPath != null) {
                afterItem = baseItem.findChildItemByPath(afterPath);
            } else {
                String sibling = config.getAttribute("sibling");
                if (sibling != null) {
                    DBXTreeItem siblingItem = baseItem.findChildItemByPath(sibling);
                    if (siblingItem == null) {
                        log.error((Object)("Sibling item '" + sibling + "' not found"));
                    } else {
                        parentNode = siblingItem.getParent();
                    }
                }
            }
            this.loadTreeChildren(config, (DBXTreeNode)parentNode, (DBXTreeNode)afterItem);
        }
    }

    private void loadTreeChildren(IConfigurationElement config, DBXTreeNode parent, DBXTreeNode afterItem) {
        Object[] children = config.getChildren();
        if (!ArrayUtils.isEmpty((Object[])children)) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.loadTreeNode(parent, (IConfigurationElement)child, afterItem);
                ++n2;
            }
        }
    }

    private void loadTreeNode(DBXTreeNode parent, IConfigurationElement config, DBXTreeNode afterItem) {
        DBXTreeNode child;
        block23: {
            String nodeType;
            block22: {
                child = null;
                String refId = config.getAttribute("ref");
                if (CommonUtils.isEmpty((String)refId)) break block22;
                child = this.treeNodeMap.get(refId);
                if (child != null) {
                    parent.addChild(child);
                } else {
                    log.warn((Object)("Bad node reference: " + refId));
                }
                break block23;
            }
            switch (nodeType = config.getName()) {
                case "folder": {
                    child = new DBXTreeFolder((AbstractDescriptor)this, parent, config, config.getAttribute("type"), CommonUtils.getBoolean((String)config.getAttribute("navigable"), (boolean)true), CommonUtils.getBoolean((String)config.getAttribute("virtual")), config.getAttribute("visibleIf"), CommonUtils.getBoolean((String)config.getAttribute("optional")));
                    break;
                }
                case "items": {
                    String recursive = config.getAttribute("recursive");
                    child = new DBXTreeItem((AbstractDescriptor)this, parent, config, config.getAttribute("path"), config.getAttribute("property"), CommonUtils.getBoolean((String)config.getAttribute("optional")), CommonUtils.getBoolean((String)config.getAttribute("navigable"), (boolean)true), CommonUtils.getBoolean((String)config.getAttribute("inline")), CommonUtils.getBoolean((String)config.getAttribute("virtual")), CommonUtils.getBoolean((String)config.getAttribute("standalone")), config.getAttribute("visibleIf"), recursive);
                    break;
                }
                case "treeContribution": {
                    String contrCategory = config.getAttribute("category");
                    if (parent instanceof DBXTreeFolder) {
                        ((DBXTreeFolder)parent).addContribution(contrCategory);
                        break;
                    }
                    log.warn((Object)"treeContribution allowed only inside folders");
                    break;
                }
                case "object": {
                    child = new DBXTreeObject((AbstractDescriptor)this, parent, config, config.getAttribute("visibleIf"), config.getAttribute("label"), config.getAttribute("description"), config.getAttribute("editor"));
                    break;
                }
            }
            if (child != null) {
                if (!CommonUtils.isEmpty((String)child.getId())) {
                    this.treeNodeMap.put(child.getId(), child);
                }
                this.loadTreeHandlers(child, config);
                this.loadTreeIcon(child, config);
                this.loadTreeChildren(config, child, null);
            }
        }
        if (child != null && afterItem != null) {
            parent.moveChildAfter(child, afterItem);
        }
    }

    private void loadTreeHandlers(DBXTreeNode node, IConfigurationElement config) {
        Object[] handlerElements = config.getChildren("handler");
        if (!ArrayUtils.isEmpty((Object[])handlerElements)) {
            Object[] objectArray = handlerElements;
            int n = handlerElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object iconElement = objectArray[n2];
                try {
                    DBXTreeNodeHandler.Action action = DBXTreeNodeHandler.Action.valueOf((String)iconElement.getAttribute("action"));
                    String performName = iconElement.getAttribute("perform");
                    String command = iconElement.getAttribute("command");
                    DBXTreeNodeHandler.Perform perform = !CommonUtils.isEmpty((String)performName) ? DBXTreeNodeHandler.Perform.valueOf((String)performName) : (!CommonUtils.isEmpty((String)command) ? DBXTreeNodeHandler.Perform.command : DBXTreeNodeHandler.Perform.none);
                    node.addActionHandler(action, perform, command);
                }
                catch (Exception e) {
                    log.error((Object)"Error adding node handler", (Throwable)e);
                }
                ++n2;
            }
        }
    }

    private void loadTreeIcon(DBXTreeNode node, IConfigurationElement config) {
        DBPImage defaultImage;
        String defaultIcon = config.getAttribute("icon");
        Object[] iconElements = config.getChildren("icon");
        if (!ArrayUtils.isEmpty((Object[])iconElements)) {
            Object[] objectArray = iconElements;
            int n = iconElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object iconElement = objectArray[n2];
                String icon = iconElement.getAttribute("icon");
                String expr = iconElement.getAttribute("if");
                boolean isDefault = CommonUtils.getBoolean((String)iconElement.getAttribute("default"));
                if (isDefault && CommonUtils.isEmpty((String)expr)) {
                    defaultIcon = icon;
                } else {
                    DBPImage iconImage = this.iconToImage(icon);
                    if (iconImage != null) {
                        node.addIcon(new DBXTreeIcon(expr, iconImage));
                    }
                }
                ++n2;
            }
        }
        if (defaultIcon != null && (defaultImage = this.iconToImage(defaultIcon)) != null) {
            node.setDefaultIcon(defaultImage);
        }
    }

    private DriverDescriptor loadDriver(IConfigurationElement config) {
        return new DriverDescriptor(this, config);
    }

    public String toString() {
        return this.id;
    }

    public String getFullIdentifier() {
        return this.getPluginId() + "/" + this.id;
    }

    public DriverDescriptor getDriverByName(String category, String name) {
        if (category != null && category.isEmpty()) {
            category = null;
        }
        for (DriverDescriptor driver : this.drivers) {
            if (!CommonUtils.equalObjects((Object)category, (Object)driver.getCategory()) || !CommonUtils.equalObjects((Object)name, (Object)driver.getName())) continue;
            return driver;
        }
        return null;
    }

    public static boolean matchesId(DBPDataSourceProviderDescriptor providerDescriptor, String id) {
        DBPDataSourceProviderDescriptor dspd = providerDescriptor;
        while (dspd != null) {
            if (id.equals(dspd.getId())) {
                return true;
            }
            dspd = dspd.getParentProvider();
        }
        return false;
    }
}

