/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.lang.reflect.Constructor;
import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.impl.app.ApplicationDescriptor;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

public abstract class BaseApplicationImpl
implements IApplication,
DBPApplication {
    private static final Log log = Log.getLog(BaseApplicationImpl.class);
    private static DBPApplication INSTANCE;
    private String applicationRunId;
    private final long applicationStartTime = System.currentTimeMillis();

    protected BaseApplicationImpl() {
        if (INSTANCE != null) {
            log.error((Object)("Multiple application instances created: " + INSTANCE.getClass().getName() + ", " + this.getClass().getName()));
        }
        INSTANCE = this;
    }

    public static DBPApplication getInstance() {
        if (INSTANCE == null) {
            DBPApplication instance = null;
            ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
            if (application != null && application.getImplClass() != null) {
                try {
                    instance = (DBPApplication)application.getImplClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable e) {
                    log.error((Object)e);
                }
            }
            if (instance == null) {
                throw new IllegalStateException("No DBeaver application found");
            }
            INSTANCE = instance;
        }
        return INSTANCE;
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean isPrimaryInstance() {
        return true;
    }

    public boolean isHeadlessMode() {
        return false;
    }

    public boolean isExclusiveMode() {
        return false;
    }

    public boolean isMultiuser() {
        return false;
    }

    public boolean isDistributed() {
        return false;
    }

    public boolean isDetachedProcess() {
        return false;
    }

    @NotNull
    public String getApplicationRunId() {
        if (this.applicationRunId == null) {
            this.applicationRunId = UUID.randomUUID().toString();
        }
        return this.applicationRunId;
    }

    public long getApplicationStartTime() {
        return this.applicationStartTime;
    }

    public String getInfoDetails(DBRProgressMonitor monitor) {
        return "N/A";
    }

    @Nullable
    public String getProductProperty(@NotNull String propName) {
        return Platform.getProduct().getProperty(propName);
    }

    public boolean hasProductFeature(@NotNull String featureName) {
        return switch (featureName) {
            case "multi-fs" -> false;
            default -> true;
        };
    }

    public Object start(IApplicationContext context) throws Exception {
        return EXIT_OK;
    }

    public void stop() {
    }

    /*
     * WARNING - void declaration
     */
    protected void initializeApplicationServices() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof BundleReference) {
            void br;
            BundleReference bundleReference = (BundleReference)classLoader;
            BundleReference cfr_ignored_0 = (BundleReference)classLoader;
            BundleContext bundleContext = br.getBundle().getBundleContext();
            this.registerService(bundleContext, DBPPlatform.class, this.getPlatformClass());
            this.registerService(bundleContext, DBPPlatformUI.class, this.getPlatformUIClass());
        } else {
            log.error((Object)"Cannot initialize application services in non-OSGI context");
        }
    }

    protected <T> void registerService(BundleContext bundleContext, Class<T> serviceInt, Class<? extends T> serviceImplClass) {
        if (serviceImplClass == null) {
            return;
        }
        try {
            Constructor<T> constructor = serviceImplClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            T serviceImpl = constructor.newInstance(new Object[0]);
            bundleContext.registerService(serviceInt, serviceImpl, null);
        }
        catch (Throwable e) {
            log.error((Object)("Error instantiating service '" + serviceInt.getName() + "'"), e);
        }
    }
}

