/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class TaskProcessorUI
implements DBRRunnableContext,
DBTTaskExecutionListener {
    private static final Log log = Log.getLog(TaskProcessorUI.class);
    @NotNull
    private DBTTask task;
    @NotNull
    private DBRRunnableContext staticContext;
    private long startTime;
    private boolean started;
    private long timeSincePreviousTask;

    public TaskProcessorUI(@NotNull DBRRunnableContext staticContext, @NotNull DBTTask task) {
        this.staticContext = staticContext;
        this.task = task;
    }

    protected void runTask() throws DBException {
        throw new DBException("Empty task execute implementation");
    }

    protected boolean isShowFinalMessage() {
        return true;
    }

    @NotNull
    public DBTTask getTask() {
        return this.task;
    }

    public void executeTask() throws DBException {
        this.runTask();
    }

    public void taskStarted(@Nullable DBTTask task) {
        this.started = true;
        this.timeSincePreviousTask = this.startTime = System.currentTimeMillis();
    }

    public void taskFinished(@Nullable DBTTask task, @Nullable Object result, @Nullable Throwable error, @Nullable Object settings) {
        this.started = false;
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        this.sendNotification(task, error, elapsedTime, settings);
    }

    private void sendNotification(@Nullable DBTTask task, @Nullable Throwable error, long elapsedTime, @Nullable Object settings) {
        UIUtils.asyncExec(() -> {
            boolean hasErrors = error != null;
            DBPPlatformUI platformUI = DBWorkbench.getPlatformUI();
            StringBuilder completeMessage = new StringBuilder();
            completeMessage.append(task == null ? this.task.getType().getName() : task.getType().getName()).append(" ").append(TaskUIMessages.task_processor_ui_message_task_completed).append(" (").append(RuntimeUtils.formatExecutionTime((long)elapsedTime)).append(")");
            ArrayList<String> objects = new ArrayList<String>();
            if (settings instanceof AbstractNativeToolSettings) {
                for (DBSObject databaseObject : ((AbstractNativeToolSettings)settings).getDatabaseObjects()) {
                    objects.add(databaseObject.getName());
                }
                completeMessage.append("\nObject(s) processed: ").append(String.join((CharSequence)",", objects));
            }
            if (elapsedTime > platformUI.getLongOperationTimeout() * 1000L) {
                platformUI.notifyAgent(completeMessage.toString(), !hasErrors ? 1 : 4);
            }
            if (this.isShowFinalMessage() && !hasErrors) {
                DBeaverNotifications.showNotification((String)"task.execute.success", (String)(task == null ? this.task.getName() : task.getName()), (String)completeMessage.toString(), (DBPMessageType)DBPMessageType.INFORMATION, null);
            } else if (error != null && !(error instanceof InterruptedException)) {
                DBeaverNotifications.showNotification((String)"task.execute.failure", (String)(task == null ? this.task.getName() : task.getName()), (String)error.getMessage(), (DBPMessageType)DBPMessageType.ERROR, () -> {
                    DBPPlatformUI.UserResponse userResponse = DBWorkbench.getPlatformUI().showError("Task error", "Task execution failed", error);
                });
            }
        });
    }

    public void subTaskFinished(@Nullable DBTTask task, @Nullable Throwable error, @Nullable Object settings) {
        long elapsedTime = System.currentTimeMillis() - this.timeSincePreviousTask;
        this.timeSincePreviousTask = System.currentTimeMillis();
        this.sendNotification(task, error, elapsedTime, settings);
    }

    public void run(boolean fork, boolean cancelable, DBRRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.staticContext.run(fork, cancelable, runnable);
    }
}

