/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.mapping.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.lsm.mapping.internal.CustomXPathUtils;
import org.jkiss.dbeaver.model.lsm.mapping.internal.NodesList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XFunctionResolver
implements XPathFunctionResolver {
    @NotNull
    private final Map<String, XPathFunction> functionByName = Map.ofEntries(XFunctionResolver.xfunction("echo", args -> {
        for (Object o : args) {
            if (o instanceof NodeList) {
                NodeList nodeList = (NodeList)o;
                if (nodeList.getLength() == 0) {
                    System.out.println("[]");
                    continue;
                }
                System.out.println(CustomXPathUtils.streamOf(nodeList).map(n -> "  " + n.getLocalName() + ": \"" + n.getNodeValue() + "\"").collect(Collectors.joining(",\n", "[\n", "\n]")));
                continue;
            }
            if (o instanceof Node) {
                Node node = (Node)o;
                System.out.println(node.getLocalName() + ": \"" + node.getNodeValue() + "\"");
                continue;
            }
            System.out.println(o);
        }
        return args.size() > 0 ? args.get(0) : null;
    }), XFunctionResolver.xfunction("rootOf", args -> {
        if (args.size() > 0 && args.get(0) instanceof NodeList) {
            NodeList nodeList = (NodeList)args.get(0);
            if (nodeList.getLength() > 0) {
                Node node = nodeList.item(0);
                while (node.getParentNode() != null) {
                    node = node.getParentNode();
                }
                return node;
            }
            return null;
        }
        return null;
    }), XFunctionResolver.xfunction("flatten", args -> {
        if (args.size() < 2) {
            throw new XPathFunctionException("At least two arguments required for flatten(roots:NodeList, stepExpr:String, justLeaves:bool = false, incudeRoot:bool = ture)");
        }
        if (args.size() > 4) {
            throw new XPathFunctionException("No more than four arguments required for flatten(roots:NodeList, stepExpr:String, justLeaves:bool = false, incudeRoot:bool = ture)");
        }
        NodeList roots = (NodeList)args.get(0);
        XPathExpression stepExpr = this.prepareExpr(args.get(1).toString());
        boolean justLeaves = args.size() > 2 ? (Boolean)args.get(2) : false;
        boolean includeRoot = args.size() > 3 ? (Boolean)args.get(3) : true;
        NodesList<Node> result = new NodesList<Node>();
        if (includeRoot && !justLeaves) {
            result.ensureCapacity(roots.getLength());
        }
        for (Node root : CustomXPathUtils.iterableOf(roots)) {
            if (includeRoot && !justLeaves) {
                result.add(root);
                continue;
            }
            CustomXPathUtils.flattenExclusiveImpl(root, stepExpr, justLeaves, result);
        }
        return result;
    }), XFunctionResolver.xfunction("joinStrings", args -> {
        if (args.size() < 2) {
            throw new XPathFunctionException("At least two arguments required for joinStrings(separator:String, nodes...:NodeList)");
        }
        StringBuilder sb = new StringBuilder();
        String separator = args.get(0).toString();
        int count = 0;
        int i = 1;
        while (i < args.size()) {
            for (Node node : CustomXPathUtils.iterableOf((NodeList)args.get(i))) {
                if (count > 0) {
                    sb.append(separator);
                }
                sb.append(node.getTextContent());
                ++count;
            }
            ++i;
        }
        return sb.toString();
    }));
    private final XPath xpath;
    private final Map<String, XPathExpression> exprs = new HashMap<String, XPathExpression>();

    @NotNull
    private static Map.Entry<String, XPathFunction> xfunction(@NotNull String name, @Nullable MyXPathFunction impl) {
        return Map.entry(name, args -> {
            try {
                if (impl == null) {
                    throw new IllegalArgumentException("Can't evaluate function " + name);
                }
                return impl.evaluate(args);
            }
            catch (XPathExpressionException ex) {
                throw new XPathFunctionException(ex);
            }
        });
    }

    public XFunctionResolver(XPath xpath) {
        this.xpath = xpath;
    }

    private XPathExpression prepareExpr(String exprStr) throws XPathExpressionException {
        XPathExpression expr = this.exprs.get(exprStr);
        if (expr == null) {
            expr = this.xpath.compile(exprStr);
            this.exprs.put(exprStr, expr);
        }
        return expr;
    }

    @Override
    public XPathFunction resolveFunction(QName functionName, int arity) {
        return this.functionByName.get(functionName.getLocalPart());
    }

    @FunctionalInterface
    private static interface MyXPathFunction {
        @Nullable
        public Object evaluate(@NotNull List<?> var1) throws XPathExpressionException;
    }
}

