/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.mapping;

import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.misc.Pair;
import org.antlr.v4.runtime.tree.Tree;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.lsm.mapping.AbstractSyntaxNode;
import org.jkiss.dbeaver.model.lsm.mapping.ModelErrorsCollection;
import org.jkiss.dbeaver.model.lsm.mapping.SyntaxLiteral;
import org.jkiss.dbeaver.model.lsm.mapping.SyntaxLiteralCase;
import org.jkiss.dbeaver.model.lsm.mapping.SyntaxModelMappingResult;
import org.jkiss.dbeaver.model.lsm.mapping.SyntaxModelMappingSession;
import org.jkiss.dbeaver.model.lsm.mapping.SyntaxNode;
import org.jkiss.dbeaver.model.lsm.mapping.SyntaxSubnode;
import org.jkiss.dbeaver.model.lsm.mapping.SyntaxTerm;
import org.jkiss.dbeaver.model.lsm.mapping.internal.FieldTypeKind;
import org.jkiss.dbeaver.model.lsm.mapping.internal.LiteralTypeInfo;
import org.jkiss.dbeaver.model.lsm.mapping.internal.NodeFieldInfo;
import org.jkiss.dbeaver.model.lsm.mapping.internal.NodeTypeInfo;
import org.jkiss.dbeaver.model.lsm.mapping.internal.XFunctionResolver;
import org.jkiss.dbeaver.model.lsm.mapping.internal.XTreeNodeBase;

public class SyntaxModel {
    private final Parser parser;
    private final Map<String, NodeTypeInfo> nodeTypeByRuleName = new HashMap<String, NodeTypeInfo>();
    private final Map<Class<?>, NodeTypeInfo> nodeTypeByClass = new HashMap();
    private final Map<String, LiteralTypeInfo> literalTypeByRuleName = new HashMap<String, LiteralTypeInfo>();
    private final Map<Class<?>, LiteralTypeInfo> literalTypeByClass = new HashMap();
    private final XPath xpath;

    public SyntaxModel(@NotNull Parser parser) {
        this.parser = parser;
        XPathFactory xf = XPathFactory.newInstance();
        this.xpath = xf.newXPath();
        this.xpath.setXPathFunctionResolver(new XFunctionResolver(this.xpath));
    }

    @NotNull
    private XTreeNodeBase prepareTree(@NotNull Tree root) {
        if (!(root instanceof XTreeNodeBase)) {
            throw new IllegalArgumentException("Failed to prepare syntax model due to unsupported syntax tree typeing.Consider using adapted grammar with correct superClass and contextSuperClass options.");
        }
        XTreeNodeBase rootNode = (XTreeNodeBase)root;
        if (rootNode.getIndex() < 0) {
            rootNode.fixup(this.parser, 0);
        }
        return rootNode;
    }

    @NotNull
    public String toXml(@NotNull Tree root) throws FactoryConfigurationError, TransformerException {
        XTreeNodeBase rootInfo = this.prepareTree(root);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        StringWriter buffer = new StringWriter();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(rootInfo), new StreamResult(buffer));
        return buffer.toString();
    }

    @NotNull
    public <T extends AbstractSyntaxNode> SyntaxModelMappingResult<T> map(@NotNull Tree root, @NotNull Class<T> type) {
        XTreeNodeBase rootInfo = this.prepareTree(root);
        SyntaxModelMappingSession mappingSession = new SyntaxModelMappingSession(this);
        return mappingSession.map(rootInfo, type);
    }

    private void appendIndent(@NotNull StringBuilder sb, int indent) {
        sb.append("\t".repeat(Math.max(0, indent)));
    }

    @NotNull
    public String stringify(@NotNull AbstractSyntaxNode model) {
        StringBuilder sb = new StringBuilder();
        this.stringifyImpl(model, sb, 0);
        return sb.toString();
    }

    private void stringifyImpl(@NotNull AbstractSyntaxNode model, @NotNull StringBuilder sb, int indent) {
        this.appendIndent(sb, indent);
        sb.append("{");
        NodeTypeInfo typeInfo = this.nodeTypeByRuleName.get(model.getName());
        int n = 0;
        sb.append("\n");
        this.appendIndent(sb, ++indent);
        sb.append("\"_sourceInterval\": \"").append(model.getAstNode().getSourceInterval()).append("\"");
        sb.append(",").append("\n");
        this.appendIndent(sb, indent);
        sb.append("\"_realInterval\": \"").append(model.getAstNode().getRealInterval()).append("\"");
        sb.append(",").append("\n");
        this.appendIndent(sb, indent);
        sb.append("\"_type\": \"").append(model.getClass().getName()).append("\"");
        sb.append(",").append("\n");
        this.appendIndent(sb, indent);
        sb.append("\"_ruleName\": \"").append(model.getName()).append("\"");
        sb.append(",").append("\n");
        this.appendIndent(sb, indent);
        sb.append("\"_bindings\": ");
        ++indent;
        sb.append("[");
        int m = 0;
        for (AbstractSyntaxNode.BindingInfo binding : model.getBindings()) {
            if (m > 0) {
                sb.append(",");
            }
            sb.append("{\n");
            this.appendIndent(sb, ++indent);
            sb.append("\"").append("sourceInterval").append("\"");
            sb.append(": ");
            sb.append("\"").append(binding.astNode.getSourceInterval()).append("\"");
            sb.append(",\n");
            this.appendIndent(sb, indent);
            sb.append("\"").append("realInterval").append("\"");
            sb.append(": ");
            sb.append("\"").append(binding.astNode.getRealInterval()).append("\"");
            sb.append(",\n");
            this.appendIndent(sb, indent);
            sb.append("\"").append("text").append("\"");
            sb.append(": ");
            sb.append("\"").append(binding.astNode.getTextContent().replace("\n", "\\n ").replace("\r", "\\r")).append("\"");
            sb.append(",\n");
            this.appendIndent(sb, indent);
            sb.append("\"").append("model").append("\"");
            sb.append(": ");
            sb.append("\"").append(binding.field.getDeclaringClassName()).append(".").append(binding.field.getFieldName()).append("\"");
            sb.append(",\n");
            this.appendIndent(sb, indent);
            sb.append("\"").append("node").append("\"");
            sb.append(": ");
            sb.append("\"");
            sb.append(binding.astNode.getFullPathName().substring(model.getAstNode().getFullPathName().length()));
            sb.append("\"");
            sb.append("\n");
            this.appendIndent(sb, --indent);
            sb.append("}");
            ++m;
        }
        sb.append("\n");
        this.appendIndent(sb, --indent);
        sb.append("]");
        if (typeInfo == null) {
            sb.append(",").append("\n");
            this.appendIndent(sb, indent);
            sb.append("\"_error\": \"").append("syntax model type info not found").append("\"");
        }
        n += 2;
        if (typeInfo != null) {
            for (NodeFieldInfo field : typeInfo.getFields()) {
                Object value;
                try {
                    value = field.getValue(model);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    value = ex;
                }
                if (n > 0) {
                    sb.append(",");
                }
                sb.append("\n");
                this.appendIndent(sb, indent);
                sb.append("\"").append(field.getFieldName()).append("\"").append(": ");
                if (value == null) {
                    sb.append("null");
                } else if (value instanceof Throwable) {
                    this.appendIndent(sb, indent);
                    sb.append("{");
                    sb.append("\n");
                    this.appendIndent(sb, ++indent);
                    sb.append("\"_type\": \"").append(value.getClass().getName()).append("\"");
                    sb.append(",").append("\n");
                    this.appendIndent(sb, indent);
                    sb.append("\"_error\": \"").append(value).append("\"");
                    sb.append("\n");
                    this.appendIndent(sb, --indent);
                    sb.append("}");
                    sb.append("\n");
                } else {
                    switch (field.kind) {
                        case String: 
                        case Enum: {
                            sb.append('\"').append(value.toString().replace("\"", "\\\"")).append('\"');
                            break;
                        }
                        case Byte: 
                        case Short: 
                        case Int: 
                        case Long: 
                        case Bool: 
                        case Float: 
                        case Double: {
                            sb.append(value);
                            break;
                        }
                        case LiteralList: {
                            ++indent;
                            sb.append("[");
                            int m2 = 0;
                            for (Object item : (Iterable)value) {
                                if (m2 > 0) {
                                    sb.append(",");
                                }
                                sb.append("\n");
                                this.appendIndent(sb, indent);
                                sb.append("\"");
                                sb.append(item.toString());
                                sb.append("\"");
                                ++m2;
                            }
                            sb.append("\n");
                            this.appendIndent(sb, --indent);
                            sb.append("]");
                            break;
                        }
                        case Object: {
                            this.stringifyImpl((AbstractSyntaxNode)value, sb, indent);
                            break;
                        }
                        case Array: 
                        case List: {
                            ++indent;
                            sb.append("[");
                            int m3 = 0;
                            for (Object item : (Iterable)value) {
                                if (m3 > 0) {
                                    sb.append(",");
                                }
                                sb.append("\n");
                                this.stringifyImpl((AbstractSyntaxNode)item, sb, indent);
                                ++m3;
                            }
                            sb.append("\n");
                            this.appendIndent(sb, --indent);
                            sb.append("]");
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected syntax model field kind " + String.valueOf((Object)field.kind));
                        }
                    }
                }
                ++n;
            }
        }
        sb.append("\n");
        this.appendIndent(sb, --indent);
        sb.append("}");
    }

    private <T, R> Function<T, R> captureExceptionInfo(ThrowableFunction<T, R> mapper, BiConsumer<T, Throwable> handler) {
        return o -> {
            try {
                return mapper.apply(o);
            }
            catch (Throwable ex) {
                handler.accept(o, ex);
                return null;
            }
        };
    }

    private void introduceEnum(Class<?> type, ModelErrorsCollection errors) {
        SyntaxLiteral literalAnnotation = type.getAnnotation(SyntaxLiteral.class);
        if (literalAnnotation == null) {
            errors.add("Type " + type.getName() + " is not marked as syntax ruleName!");
        } else if (!type.isEnum()) {
            errors.add("Type " + type.getName() + " is not a enum while marked as syntax literal!");
        }
        assert (literalAnnotation != null);
        LiteralTypeInfo existing = this.literalTypeByRuleName.get(literalAnnotation.name());
        if (existing == null) {
            int countOfUpperCasedNames;
            List enumEntries = Stream.of(type.getFields()).filter(Field::isEnumConstant).map(this.captureExceptionInfo(f -> new Object((Field)f){
                public final Object value;
                public final String name;
                public final String upperCasedName;
                public final SyntaxLiteralCase literalCaseAnnotation;
                {
                    this.value = field.get(null);
                    this.name = field.getName();
                    this.upperCasedName = field.getName().toUpperCase();
                    this.literalCaseAnnotation = field.getAnnotation(SyntaxLiteralCase.class);
                }
            }, (f, ex) -> errors.add((Throwable)ex, "Failed to introduce model enum case " + f.getName() + " of type " + type.getName()))).collect(Collectors.toList());
            int countOfDefaultCasedNames = enumEntries.stream().map(e -> e.name).collect(Collectors.toSet()).size();
            boolean isCaseSensitive = countOfDefaultCasedNames != (countOfUpperCasedNames = enumEntries.stream().map(e -> e.upperCasedName).collect(Collectors.toSet()).size());
            Map<String, Object> valuesByName = isCaseSensitive ? enumEntries.stream().collect(Collectors.toMap(e -> e.name, e -> e.value)) : enumEntries.stream().collect(Collectors.toMap(e -> e.upperCasedName, e -> e.value));
            LinkedHashMap exprByValue = enumEntries.stream().filter(e -> e.literalCaseAnnotation != null && e.literalCaseAnnotation.xcondition().length() > 0).collect(Collectors.toMap(e -> e.value, this.captureExceptionInfo(e -> this.xpath.compile(e.literalCaseAnnotation.xcondition()), (f, ex) -> errors.add((Throwable)ex, "Failed to prepare condition xpath for enum case " + f.name + " of type " + type.getName())), (x, y) -> {
                throw new IllegalStateException("Duplicated enum values");
            }, LinkedHashMap::new));
            try {
                XPathExpression xstringExpr = literalAnnotation.xstring().length() > 0 ? this.xpath.compile(literalAnnotation.xstring()) : null;
                LiteralTypeInfo literalTypeInfo = new LiteralTypeInfo(literalAnnotation.name(), type, xstringExpr, exprByValue, valuesByName, isCaseSensitive);
                this.literalTypeByRuleName.put(literalAnnotation.name(), literalTypeInfo);
                this.literalTypeByClass.put(type, literalTypeInfo);
            }
            catch (XPathException ex2) {
                errors.add(ex2, "Failed to prepare xstring xpath exprssion for literal of type " + type.getName());
            }
        } else if (!existing.type.equals(type)) {
            errors.add("Ambiguous syntax literal: both " + type.getName() + " and " + existing.type.getName() + "  are marked with the same name " + literalAnnotation.name());
        }
    }

    public <T extends AbstractSyntaxNode> ModelErrorsCollection introduce(Class<T> modelType) {
        ModelErrorsCollection errors = new ModelErrorsCollection();
        HashSet processedTypes = new HashSet();
        LinkedList<NodeFieldInfo> fieldsToFixup = new LinkedList<NodeFieldInfo>();
        LinkedList<Pair> queue = new LinkedList<Pair>();
        queue.add(new Pair(null, modelType));
        while (!queue.isEmpty()) {
            Constructor ctor;
            String referrent;
            Pair entry = (Pair)queue.remove();
            Class type = (Class)entry.b;
            if (!processedTypes.add(type)) continue;
            SyntaxNode ruleAnnotation = type.getAnnotation(SyntaxNode.class);
            if (ruleAnnotation == null) {
                referrent = entry.a == null ? " " : " referenced from field " + ((Field)entry.a).getName() + " of type " + ((Field)entry.a).getDeclaringClass().getName() + " ";
                errors.add("Type " + type.getName() + referrent + " is not marked as syntax node with SyntaxNode annotation");
                continue;
            }
            if (!AbstractSyntaxNode.class.isAssignableFrom(type)) {
                referrent = entry.a == null ? " " : " referenced from field " + ((Field)entry.a).getName() + " of type " + ((Field)entry.a).getDeclaringClass().getName() + " ";
                errors.add("Type " + type.getName() + referrent + " is not a subclass of AbstractSyntaxNode and cannot be supported as part of syntax model");
            }
            List fields = Stream.of(type.getFields()).map(f -> new Object((Field)f){
                public final Field info;
                public final SyntaxSubnode[] subnodeSpecs;
                public final SyntaxTerm[] termSpecs;
                {
                    this.info = field;
                    this.subnodeSpecs = (SyntaxSubnode[])field.getAnnotationsByType(SyntaxSubnode.class);
                    this.termSpecs = (SyntaxTerm[])field.getAnnotationsByType(SyntaxTerm.class);
                }
            }).filter(f -> !Modifier.isStatic(f.info.getModifiers())).collect(Collectors.toList());
            HashMap<String, NodeFieldInfo> modelFields = new HashMap<String, NodeFieldInfo>(fields.size());
            for (3 field : fields) {
                boolean expectsLiteral;
                Class<?> fieldType = field.info.getType();
                boolean expectsSubnode = field.subnodeSpecs.length > 0;
                boolean bl = expectsLiteral = field.termSpecs.length > 0;
                if (expectsSubnode && expectsLiteral) {
                    errors.add("Field of terminal value kind cannot be bound with complex subnode type");
                }
                FieldTypeKind kind = expectsSubnode ? FieldTypeKind.resolveModelSubnodeFieldKind(fieldType) : FieldTypeKind.resolveModelLiteralFieldKind(fieldType);
                ArrayList<XPathExpression> termExprs = new ArrayList<XPathExpression>(field.termSpecs.length);
                ArrayList<NodeFieldInfo.SubnodeInfo> subnodeExprs = new ArrayList<NodeFieldInfo.SubnodeInfo>(field.subnodeSpecs.length);
                Annotation[] annotationArray = field.termSpecs;
                int n = field.termSpecs.length;
                int n2 = 0;
                while (n2 < n) {
                    SyntaxTerm termSpec = annotationArray[n2];
                    try {
                        termExprs.add(this.xpath.compile(termSpec.xpath()));
                        if (fieldType.isEnum() && processedTypes.add(fieldType)) {
                            this.introduceEnum(fieldType, errors);
                        }
                    }
                    catch (XPathExpressionException e) {
                        errors.add(e, "Failed to prepare literal xpath exprssion for field " + field.info.getName() + " of type " + type.getName());
                    }
                    ++n2;
                }
                annotationArray = field.subnodeSpecs;
                n = field.subnodeSpecs.length;
                n2 = 0;
                while (n2 < n) {
                    block18: {
                        Class<AbstractSyntaxNode> subnodeType;
                        Annotation subnodeSpec;
                        block17: {
                            block15: {
                                block16: {
                                    subnodeSpec = annotationArray[n2];
                                    if (subnodeSpec.type() != null && !subnodeSpec.type().equals(AbstractSyntaxNode.class)) break block15;
                                    if (!AbstractSyntaxNode.class.isAssignableFrom(fieldType)) break block16;
                                    Class<?> ft = fieldType;
                                    subnodeType = ft;
                                    break block17;
                                }
                                errors.add("Failed to resolve subnode type for field " + field.info.getName() + " of type " + type.getName() + ": either " + fieldType.getName() + " should be a subclass of AbstractSyntaxNode or explicit target type required for subnode annotation");
                                break block18;
                            }
                            subnodeType = subnodeSpec.type();
                        }
                        try {
                            XPathExpression scopeExpr = subnodeSpec.xpath() != null && subnodeSpec.xpath().length() > 0 ? this.xpath.compile(subnodeSpec.xpath()) : null;
                            subnodeExprs.add(new NodeFieldInfo.SubnodeInfo(scopeExpr, subnodeType, subnodeSpec.lookup()));
                            queue.add(new Pair((Object)field.info, subnodeType));
                        }
                        catch (XPathExpressionException ex) {
                            errors.add(ex, "Failed to prepare subnode xpath exprssion for field " + field.info.getName() + " of type " + type.getName());
                        }
                    }
                    ++n2;
                }
                NodeFieldInfo fieldInfo = new NodeFieldInfo(kind, field.info, termExprs, subnodeExprs);
                modelFields.put(field.info.getName(), fieldInfo);
                fieldsToFixup.addLast(fieldInfo);
            }
            try {
                ctor = type.getConstructor(new Class[0]);
            }
            catch (Throwable ex) {
                errors.add(ex, "Failed to resolve default contructor for syntax model type " + type.getName());
                continue;
            }
            String ruleName = ruleAnnotation.name() != null && ruleAnnotation.name().length() > 0 ? ruleAnnotation.name() : type.getName();
            NodeTypeInfo nodeTypeInfo = new NodeTypeInfo(ruleName, type, ctor, modelFields);
            this.nodeTypeByRuleName.put(ruleName, nodeTypeInfo);
            this.nodeTypeByClass.put(type, nodeTypeInfo);
        }
        for (NodeFieldInfo fieldInfo : fieldsToFixup) {
            fieldInfo.fixup(this);
        }
        return errors;
    }

    public NodeTypeInfo findNodeTypeInfo(Class<?> type) {
        return this.nodeTypeByClass.get(type);
    }

    public LiteralTypeInfo findLiteralTypeInfo(Class<?> type) {
        return this.literalTypeByClass.get(type);
    }

    @FunctionalInterface
    private static interface ThrowableFunction<T, R> {
        public R apply(T var1) throws Throwable;
    }
}

