/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.auth;

import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.auth.SQLServerAuthModelAbstract;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SQLServerAuthModelKerberos
extends SQLServerAuthModelAbstract {
    public static final String ID = "sqlserver_kerberos";

    public boolean isUserNameApplicable() {
        return true;
    }

    public boolean isUserPasswordApplicable() {
        return true;
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelDatabaseNativeCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        connProperties.put("integratedSecurity", String.valueOf(true));
        connProperties.put("authenticationScheme", "JavaKerberos");
        String userName = credentials.getUserName();
        String userPassword = credentials.getUserPassword();
        if (!CommonUtils.isEmpty((String)userName)) {
            connProperties.put("userName", userName);
        }
        if (!CommonUtils.isEmpty((String)userPassword)) {
            connProperties.put("password", userPassword);
        }
        return credentials;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }
}

