/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.impl.app.ApplicationDescriptor;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.EclipsePluginApplicationImpl;

public abstract class BaseApplicationImpl
implements IApplication,
DBPApplication {
    private static final Log log = Log.getLog(BaseApplicationImpl.class);
    private static DBPApplication INSTANCE;
    private String applicationRunId;
    private final long applicationStartTime = System.currentTimeMillis();

    protected BaseApplicationImpl() {
        if (INSTANCE != null && !(INSTANCE instanceof EclipsePluginApplicationImpl)) {
            log.error((Object)("Multiple application instances created: " + INSTANCE.getClass().getName() + ", " + this.getClass().getName()));
        }
        INSTANCE = this;
    }

    public static DBPApplication getInstance() {
        if (INSTANCE == null) {
            EclipsePluginApplicationImpl instance = null;
            ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
            if (application != null && application.getImplClass() != null) {
                try {
                    instance = (DBPApplication)application.getImplClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable e) {
                    log.error((Object)e);
                }
            }
            if (instance == null) {
                instance = new EclipsePluginApplicationImpl();
            }
            INSTANCE = instance;
        }
        return INSTANCE;
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean isPrimaryInstance() {
        return true;
    }

    public boolean isHeadlessMode() {
        return false;
    }

    public boolean isExclusiveMode() {
        return false;
    }

    public boolean isMultiuser() {
        return false;
    }

    public boolean isDistributed() {
        return false;
    }

    public boolean isDetachedProcess() {
        return false;
    }

    @NotNull
    public String getApplicationRunId() {
        if (this.applicationRunId == null) {
            this.applicationRunId = UUID.randomUUID().toString();
        }
        return this.applicationRunId;
    }

    public long getApplicationStartTime() {
        return this.applicationStartTime;
    }

    public String getInfoDetails(DBRProgressMonitor monitor) {
        return "N/A";
    }

    @Nullable
    public String getProductProperty(@NotNull String propName) {
        return Platform.getProduct().getProperty(propName);
    }

    public boolean hasProductFeature(@NotNull String featureName) {
        return switch (featureName) {
            case "multi-fs" -> false;
            default -> true;
        };
    }

    public Object start(IApplicationContext context) throws Exception {
        return EXIT_OK;
    }

    public void stop() {
    }
}

