/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.net;

import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.app.DBACertificateStorage;
import org.jkiss.dbeaver.model.impl.app.CertificateGenHelper;
import org.jkiss.dbeaver.model.impl.app.DefaultCertificateStorage;
import org.jkiss.dbeaver.model.impl.net.SSLConfigurationMethod;
import org.jkiss.dbeaver.model.impl.net.SSLHandlerImpl;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class SSLHandlerTrustStoreImpl
extends SSLHandlerImpl {
    public static final String CERT_VALUE_SUFFIX = ".value";
    public static final String PROP_SSL_CA_CERT = "ssl.ca.cert";
    public static final String PROP_SSL_CA_CERT_VALUE = "ssl.ca.cert.value";
    public static final String PROP_SSL_CLIENT_CERT = "ssl.client.cert";
    public static final String PROP_SSL_CLIENT_CERT_VALUE = "ssl.client.cert.value";
    public static final String PROP_SSL_CLIENT_KEY = "ssl.client.key";
    public static final String PROP_SSL_CLIENT_KEY_VALUE = "ssl.client.key.value";
    public static final String PROP_SSL_KEYSTORE = "ssl.keystore";
    public static final String PROP_SSL_KEYSTORE_VALUE = "ssl.keystore.value";
    public static final String PROP_SSL_KEYSTORE_PASSWORD = "ssl.keystore.password";
    public static final String PROP_SSL_SELF_SIGNED_CERT = "ssl.self-signed-cert";
    public static final String PROP_SSL_METHOD = "ssl.method";
    public static final String PROP_SSL_FORCE_TLS12 = "ssl.forceTls12";
    public static final String CERT_TYPE = "ssl";
    public static final String TLS_PROTOCOL_VAR_NAME = "jdk.tls.client.protocols";
    public static final String TLS_1_2_VERSION = "TLSv1.2";

    public static void initializeTrustStore(DBRProgressMonitor monitor, DBPDataSource dataSource, DBWHandlerConfiguration sslConfig) throws DBException, IOException {
        DBACertificateStorage securityManager = DBWorkbench.getPlatform().getCertificateStorage();
        String selfSignedCert = sslConfig.getStringProperty(PROP_SSL_SELF_SIGNED_CERT);
        String keyStore = sslConfig.getStringProperty(PROP_SSL_KEYSTORE);
        String keyStoreData = sslConfig.getSecureProperty(PROP_SSL_KEYSTORE_VALUE);
        SSLConfigurationMethod method = (SSLConfigurationMethod)CommonUtils.valueOf(SSLConfigurationMethod.class, (String)sslConfig.getStringProperty(PROP_SSL_METHOD), (Enum)SSLConfigurationMethod.CERTIFICATES);
        if (method == SSLConfigurationMethod.KEYSTORE) {
            char[] keyStorePasswordData;
            monitor.subTask("Load keystore");
            String password = sslConfig.getPassword() == null ? sslConfig.getSecureProperty(PROP_SSL_KEYSTORE_PASSWORD) : sslConfig.getPassword();
            char[] cArray = keyStorePasswordData = CommonUtils.isEmpty((String)password) ? new char[]{} : password.toCharArray();
            if (keyStore != null) {
                securityManager.addCertificate(dataSource.getContainer(), CERT_TYPE, keyStore, keyStorePasswordData);
            } else if (keyStoreData != null) {
                securityManager.addCertificate(dataSource.getContainer(), CERT_TYPE, Base64.getDecoder().decode(keyStoreData), keyStorePasswordData);
            }
        } else if (CommonUtils.toBoolean((Object)selfSignedCert)) {
            monitor.subTask("Generate self-signed certificate");
            securityManager.addSelfSignedCertificate(dataSource.getContainer(), CERT_TYPE, "CN=" + dataSource.getContainer().getActualConnectionConfiguration().getHostName());
        } else {
            byte[] caCertData = SSLHandlerTrustStoreImpl.readCertificate(sslConfig, PROP_SSL_CA_CERT);
            byte[] clientCertData = SSLHandlerTrustStoreImpl.readCertificate(sslConfig, PROP_SSL_CLIENT_CERT);
            byte[] keyData = SSLHandlerTrustStoreImpl.readCertificate(sslConfig, PROP_SSL_CLIENT_KEY);
            if (caCertData != null || clientCertData != null) {
                monitor.subTask("Load certificates");
                securityManager.addCertificate(dataSource.getContainer(), CERT_TYPE, caCertData, clientCertData, keyData);
            } else {
                securityManager.deleteCertificate(dataSource.getContainer(), CERT_TYPE);
            }
        }
    }

    public static byte[] readCertificate(DBWHandlerConfiguration configuration, String basePropName) throws IOException {
        return SSLHandlerTrustStoreImpl.readCertificate(configuration, basePropName, null);
    }

    public static byte[] readCertificate(DBWHandlerConfiguration configuration, String basePropName, String altPropName) throws IOException {
        String filePath = configuration.getStringProperty(basePropName);
        if (CommonUtils.isEmpty((String)filePath) && altPropName != null) {
            filePath = configuration.getStringProperty(altPropName);
        }
        if (!CommonUtils.isEmpty((String)filePath)) {
            return Files.readAllBytes(Path.of(filePath, new String[0]));
        }
        String certValue = configuration.getSecureProperty(String.valueOf(basePropName) + CERT_VALUE_SUFFIX);
        if (!CommonUtils.isEmpty((String)certValue)) {
            return certValue.getBytes(StandardCharsets.UTF_8);
        }
        return null;
    }

    public static Map<String, String> setGlobalTrustStore(DBPDataSource dataSource) {
        DBACertificateStorage securityManager = DBWorkbench.getPlatform().getCertificateStorage();
        String keyStorePath = securityManager.getKeyStorePath(dataSource.getContainer(), CERT_TYPE).toAbsolutePath().toString();
        String keyStoreType = securityManager.getKeyStoreType(dataSource.getContainer());
        char[] keyStorePass = securityManager.getKeyStorePassword(dataSource.getContainer(), CERT_TYPE);
        LinkedHashMap<String, String> oldProps = new LinkedHashMap<String, String>();
        SSLHandlerTrustStoreImpl.setSystemProperty("javax.net.ssl.trustStore", keyStorePath, oldProps);
        SSLHandlerTrustStoreImpl.setSystemProperty("javax.net.ssl.trustStoreType", keyStoreType, oldProps);
        SSLHandlerTrustStoreImpl.setSystemProperty("javax.net.ssl.trustStorePassword", String.valueOf(keyStorePass), oldProps);
        SSLHandlerTrustStoreImpl.setSystemProperty("javax.net.ssl.keyStore", keyStorePath, oldProps);
        SSLHandlerTrustStoreImpl.setSystemProperty("javax.net.ssl.keyStoreType", keyStoreType, oldProps);
        SSLHandlerTrustStoreImpl.setSystemProperty("javax.net.ssl.keyStorePassword", String.valueOf(keyStorePass), oldProps);
        return oldProps;
    }

    public static void resetGlobalTrustStore(Map<String, String> oldProps) {
        for (Map.Entry<String, String> pe : oldProps.entrySet()) {
            if (pe.getValue() == null) {
                System.clearProperty(pe.getKey());
                continue;
            }
            System.setProperty(pe.getKey(), pe.getValue());
        }
    }

    private static void setSystemProperty(String propName, String propValue, Map<String, String> oldProps) {
        String oldValue = System.setProperty(propName, propValue);
        oldProps.put(propName, oldValue);
    }

    public static SSLContext createTrustStoreSslContext(DBPDataSource dataSource, DBWHandlerConfiguration sslConfig) throws Exception {
        TrustManager[] trustManagers;
        DBACertificateStorage securityManager = DBWorkbench.getPlatform().getCertificateStorage();
        KeyStore trustStore = securityManager.getKeyStore(dataSource.getContainer(), CERT_TYPE);
        char[] keyStorePass = securityManager.getKeyStorePassword(dataSource.getContainer(), CERT_TYPE);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(trustStore, keyStorePass);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        if (sslConfig.getBooleanProperty(PROP_SSL_SELF_SIGNED_CERT)) {
            trustManagers = CertificateGenHelper.NON_VALIDATING_TRUST_MANAGERS;
        } else {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        boolean forceTLS12 = sslConfig.getBooleanProperty(PROP_SSL_FORCE_TLS12);
        SSLContext sslContext = forceTLS12 ? SSLContext.getInstance(TLS_1_2_VERSION) : SSLContext.getInstance("SSL");
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        return sslContext;
    }

    public static SSLSocketFactory createTrustStoreSslSocketFactory(DBPDataSource dataSource, DBWHandlerConfiguration sslConfig) throws Exception {
        return SSLHandlerTrustStoreImpl.createTrustStoreSslContext(dataSource, sslConfig).getSocketFactory();
    }

    public static void loadDerFromPem(@NotNull DBWHandlerConfiguration handler, @NotNull Path tempDerFile) throws IOException {
        byte[] key = SSLHandlerTrustStoreImpl.readCertificate(handler, PROP_SSL_CLIENT_KEY);
        StringReader reader = new StringReader(new String(key, StandardCharsets.UTF_8));
        Files.write(tempDerFile, DefaultCertificateStorage.loadDerFromPem(reader), new OpenOption[0]);
        String derCertPath = tempDerFile.toAbsolutePath().toString();
        if (DBWorkbench.isDistributed() || DBWorkbench.getPlatform().getApplication().isMultiuser()) {
            handler.setSecureProperty(PROP_SSL_CLIENT_KEY, derCertPath);
        } else {
            handler.setProperty(PROP_SSL_CLIENT_KEY, derCertPath);
        }
    }

    @NotNull
    public static SSLSocketFactory createNonValidatingSslSocketFactory() throws Exception {
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(null, CertificateGenHelper.NON_VALIDATING_TRUST_MANAGERS, new SecureRandom());
        return context.getSocketFactory();
    }

    public static byte[] readTrustStoreData(@NotNull DBWHandlerConfiguration configuration, @NotNull String property) throws DBException {
        String propertyValue = configuration.getSecureProperty(property);
        if (!CommonUtils.isEmpty((String)propertyValue)) {
            try {
                return Files.readAllBytes(Path.of(propertyValue, new String[0]));
            }
            catch (IOException e) {
                throw new DBException("Error reading file '" + property + "' data", e);
            }
        }
        String valueProperty = configuration.getSecureProperty(String.valueOf(property) + CERT_VALUE_SUFFIX);
        if (!CommonUtils.isEmpty((String)valueProperty)) {
            return Base64.getDecoder().decode(valueProperty);
        }
        return null;
    }
}

