/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDContext;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDLogicalAssociation;
import org.jkiss.dbeaver.erd.model.ERDLogicalPrimaryKey;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.erd.model.ERDUtils;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.utils.CommonUtils;

public class ERDAssociation
extends ERDObject<DBSEntityAssociation> {
    private static final Log log = Log.getLog(ERDAssociation.class);
    private ERDElement<?> sourceEntity;
    private ERDElement<?> targetEntity;
    private List<ERDEntityAttribute> sourceAttributes;
    private List<ERDEntityAttribute> targetAttributes;
    private List<int[]> initBends;

    public ERDAssociation(ERDElement<?> sourceEntity, ERDElement<?> targetEntity, boolean reflect) {
        super(new ERDLogicalAssociation(sourceEntity, String.valueOf(sourceEntity.getName()) + " -> " + targetEntity.getName(), "", new ERDLogicalPrimaryKey(targetEntity, "Logical primary key", "")));
        this.targetEntity = targetEntity;
        this.sourceEntity = sourceEntity;
        this.targetEntity.addReferenceAssociation(this, reflect);
        this.sourceEntity.addAssociation(this, reflect);
    }

    public ERDAssociation(DBSEntityAssociation association, @NotNull ERDEntity sourceEntity, @NotNull ERDEntity targetEntity, boolean reflect) {
        super(association);
        this.targetEntity = targetEntity;
        this.sourceEntity = sourceEntity;
        if (association instanceof DBSEntityReferrer) {
            this.resolveAttributes((DBSEntityReferrer)association, sourceEntity, targetEntity);
        }
        this.targetEntity.addReferenceAssociation(this, reflect);
        this.sourceEntity.addAssociation(this, reflect);
    }

    protected void resolveAttributes(DBSEntityReferrer association, ERDEntity sourceEntity, ERDEntity targetEntity) {
        try {
            List attrRefs = association.getAttributeReferences((DBRProgressMonitor)new VoidProgressMonitor());
            if (!CommonUtils.isEmpty((Collection)attrRefs)) {
                for (DBSEntityAttributeRef attrRef : attrRefs) {
                    if (!(attrRef instanceof DBSTableForeignKeyColumn)) continue;
                    DBSEntityAttribute targetAttr = ((DBSTableForeignKeyColumn)attrRef).getReferencedColumn();
                    DBSEntityAttribute sourceAttr = attrRef.getAttribute();
                    if (sourceAttr == null || targetAttr == null) continue;
                    ERDEntityAttribute erdSourceAttr = ERDUtils.getAttributeByModel(sourceEntity, sourceAttr);
                    ERDEntityAttribute erdTargetAttr = ERDUtils.getAttributeByModel(targetEntity, targetAttr);
                    if (erdSourceAttr != null || erdTargetAttr != null) {
                        this.addCondition(erdSourceAttr, erdTargetAttr);
                        continue;
                    }
                    log.error((Object)"Error resolving ERD association attributes (source/target attribute is null)");
                }
            }
        }
        catch (DBException e) {
            log.error((Object)"Error resolving ERD association attributes", (Throwable)e);
        }
    }

    public boolean isLogical() {
        return this.getObject() instanceof ERDLogicalAssociation;
    }

    public ERDElement<?> getSourceEntity() {
        return this.sourceEntity;
    }

    public ERDElement<?> getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(ERDElement<?> targetPrimaryKey) {
        this.targetEntity = targetPrimaryKey;
    }

    public void setSourceEntity(ERDElement<?> sourceForeignKey) {
        this.sourceEntity = sourceForeignKey;
    }

    @NotNull
    public List<ERDEntityAttribute> getSourceAttributes() {
        return this.sourceAttributes == null ? Collections.emptyList() : this.sourceAttributes;
    }

    @NotNull
    public List<ERDEntityAttribute> getTargetAttributes() {
        return this.targetAttributes == null ? Collections.emptyList() : this.targetAttributes;
    }

    public void addCondition(@Nullable ERDEntityAttribute sourceAttribute, @Nullable ERDEntityAttribute targetAttribute) {
        if (sourceAttribute != null) {
            if (this.sourceAttributes == null) {
                this.sourceAttributes = new ArrayList<ERDEntityAttribute>();
            }
            this.sourceAttributes.add(sourceAttribute);
        }
        if (targetAttribute != null) {
            if (this.targetAttributes == null) {
                this.targetAttributes = new ArrayList<ERDEntityAttribute>();
            }
            this.targetAttributes.add(targetAttribute);
        }
    }

    public List<int[]> getInitBends() {
        return this.initBends;
    }

    public void setInitBends(List<int[]> bends) {
        this.initBends = bends;
    }

    public String toString() {
        return this.getObject() + " [" + this.sourceEntity + "->" + this.targetEntity + "]";
    }

    @NotNull
    public String getName() {
        return ((DBSEntityAssociation)this.getObject()).getName();
    }

    @Override
    public void fromMap(@NotNull ERDContext context, Map<String, Object> map) {
    }

    @Override
    public Map<String, Object> toMap(@NotNull ERDContext context, boolean fullInfo) {
        LinkedHashMap<String, Object> assocMap = new LinkedHashMap<String, Object>();
        DBSEntityAssociation association = (DBSEntityAssociation)this.getObject();
        assocMap.put("name", association.getName());
        if (association instanceof DBPQualifiedObject) {
            assocMap.put("fqn", ((DBPQualifiedObject)association).getFullyQualifiedName(DBPEvaluationContext.UI));
        }
        assocMap.put("type", association.getConstraintType().getId());
        int pkInfo = context.getElementInfo(this.getSourceEntity());
        if (pkInfo == -1) {
            log.error((Object)("Cannot find PK table '" + this.getSourceEntity().getName() + "' in info map"));
        } else {
            assocMap.put("primary-entity", pkInfo);
        }
        int fkInfo = context.getElementInfo(this.getTargetEntity());
        if (fkInfo == -1) {
            log.error((Object)("Cannot find FK table '" + this.getSourceEntity().getName() + "' in info map"));
        } else {
            assocMap.put("foreign-entity", fkInfo);
        }
        try {
            ERDAssociation.saveRefAttributes(context.getMonitor(), (DBSEntityConstraint)association, assocMap, "primary-attributes", this.getSourceAttributes());
            ERDAssociation.saveRefAttributes(context.getMonitor(), association.getReferencedConstraint(), assocMap, "foreign-attributes", this.getTargetAttributes());
        }
        catch (DBException e) {
            log.error((Object)"Error reading ref attributes", (Throwable)e);
        }
        return assocMap;
    }

    private static void saveRefAttributes(DBRProgressMonitor monitor, DBSEntityConstraint association, Map<String, Object> map, String refName, List<ERDEntityAttribute> attributes) throws DBException {
        if (!CommonUtils.isEmpty(attributes)) {
            List refAttrList = attributes.stream().map(ERDEntityAttribute::getName).collect(Collectors.toList());
            map.put(refName, refAttrList);
        }
    }
}

