/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.ArrayUtils;

public class DatabaseObjectsTreeManager
implements ICheckStateListener {
    private static final Log log = Log.getLog(DatabaseObjectsTreeManager.class);
    private final DBRRunnableContext runnableContext;
    private final CheckboxTreeViewer viewer;
    private final Class<?>[] targetTypes;
    private IdentityHashMap<Object, Boolean> checkedElements = new IdentityHashMap();
    private final ViewerFilter[] filters;

    public DatabaseObjectsTreeManager(DBRRunnableContext runnableContext, CheckboxTreeViewer viewer, Class<?>[] targetTypes) {
        this.runnableContext = runnableContext;
        this.viewer = viewer;
        this.targetTypes = targetTypes;
        this.filters = viewer.getFilters();
        viewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.updateElementsCheck(new Object[]{event.getElement()}, event.getChecked(), true);
    }

    private void updateElementsCheck(Object[] elements, boolean checked, boolean change) {
        this.checkedElements.clear();
        boolean inWizard = UIUtils.isInWizard((Control)this.viewer.getControl());
        try {
            this.runnableContext.run(!inWizard, true, monitor -> {
                monitor.beginTask("Load sources tree", 100 * elements.length);
                try {
                    try {
                        Object[] objectArray2 = elements;
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object element = objectArray2[n2];
                            if (element instanceof DBNNode) {
                                DBNNode node = (DBNNode)element;
                                monitor.subTask("Search in '" + node.getName() + "'");
                                CollectInfo collectInfo = new CollectInfo();
                                collectInfo.rootElement = node;
                                collectInfo.wasChecked = checked;
                                this.updateElementHierarchy(monitor, node, collectInfo, change);
                                if (change) {
                                    DBNNode parent = ((DBNNode)element).getParentNode();
                                    while (parent != null) {
                                        this.updateElementHierarchy(monitor, parent, collectInfo, false);
                                        if (parent instanceof DBNDataSource) break;
                                        parent = parent.getParentNode();
                                    }
                                }
                                monitor.worked(1);
                            }
                            ++n2;
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)"Error updating checkbox state", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object ce = objectArray[n2];
            this.checkedElements.put(ce, Boolean.TRUE);
            ++n2;
        }
    }

    private void updateElementHierarchy(DBRProgressMonitor monitor, DBNNode element, CollectInfo collectInfo, boolean change) throws DBException {
        try {
            this.collectChildren(monitor, element, collectInfo, !change);
        }
        catch (DBException e) {
            log.debug((Object)"Error collecting child elements", (Throwable)e);
        }
        UIUtils.syncExec(() -> {
            if (change) {
                for (DBNNode child : collectInfo.targetChildren) {
                    this.viewer.setChecked((Object)child, collectInfo.wasChecked);
                }
            }
            for (DBNNode container : change ? collectInfo.targetContainers : Collections.singletonList(element)) {
                try {
                    DBNNode[] directChildren = container.getChildren(monitor);
                    if (directChildren == null) continue;
                    boolean missingOne = false;
                    boolean missingAll = true;
                    DBNNode[] dBNNodeArray = directChildren;
                    int n = directChildren.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBNNode node = dBNNodeArray[n2];
                        if (!this.viewer.getChecked((Object)node)) {
                            missingOne = true;
                        } else {
                            missingAll = false;
                        }
                        ++n2;
                    }
                    this.viewer.setChecked((Object)container, change ? collectInfo.wasChecked : !missingAll);
                    this.viewer.setGrayed((Object)container, missingOne);
                }
                catch (DBException dBException) {}
            }
        });
    }

    private boolean collectChildren(DBRProgressMonitor monitor, DBNNode element, CollectInfo collectInfo, boolean onlyChecked) throws DBException {
        Object[] children;
        boolean isChecked;
        if (monitor.isCanceled()) {
            return false;
        }
        ViewerFilter[] viewerFilterArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (!filter.select((Viewer)this.viewer, (Object)element.getParentNode(), (Object)element)) {
                return false;
            }
            ++n2;
        }
        boolean bl = isChecked = this.checkedElements.containsKey(element) || element == collectInfo.rootElement;
        if (onlyChecked && !collectInfo.wasChecked && !isChecked) {
            return false;
        }
        if (!onlyChecked || isChecked) {
            Class<?>[] classArray = this.targetTypes;
            int n3 = this.targetTypes.length;
            n = 0;
            while (n < n3) {
                boolean filterObjects;
                Class<?> type = classArray[n];
                boolean bl2 = filterObjects = !DBNNode.class.isAssignableFrom(type);
                if (!(filterObjects ? !(element instanceof DBNDatabaseNode) || !type.isInstance(((DBNDatabaseNode)element).getObject()) : !type.isInstance(element))) {
                    collectInfo.targetChildren.add(element);
                    return true;
                }
                ++n;
            }
        }
        if (element instanceof DBNDatabaseNode) {
            ((DBNDatabaseNode)element).initializeNode(monitor, null);
        }
        if (!ArrayUtils.isEmpty((Object[])(children = element.getChildren(monitor)))) {
            boolean foundChild = false;
            Object[] objectArray = children;
            int n4 = children.length;
            int n5 = 0;
            while (n5 < n4) {
                Object child = objectArray[n5];
                if (onlyChecked) {
                    if (this.checkedElements.containsKey(child)) {
                        foundChild = true;
                        break;
                    }
                } else {
                    try {
                        if (this.collectChildren(monitor, (DBNNode)child, collectInfo, false)) {
                            foundChild = true;
                        }
                    }
                    catch (DBException e) {
                        log.debug((Object)("Error reading child nodes of '" + child.getName() + "'"), (Throwable)e);
                    }
                }
                ++n5;
            }
            if (foundChild && !collectInfo.targetContainers.contains(element)) {
                collectInfo.targetContainers.add(element);
                if (onlyChecked) {
                    this.checkedElements.put(element, Boolean.TRUE);
                }
            }
            return foundChild;
        }
        return false;
    }

    public void updateCheckStates() {
        LinkedHashSet<DBNNode> parentList = new LinkedHashSet<DBNNode>();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            DBNNode node = ((DBNNode)element).getParentNode();
            while (node != null) {
                parentList.add(node);
                this.viewer.setChecked((Object)node, true);
                node = node.getParentNode();
            }
            ++n2;
        }
        this.updateElementsCheck(parentList.toArray(), true, false);
    }

    private static class CollectInfo {
        DBNNode rootElement;
        boolean wasChecked;
        final List<DBNNode> targetChildren = new ArrayList<DBNNode>();
        final List<DBNNode> targetContainers = new ArrayList<DBNNode>();

        private CollectInfo() {
        }
    }
}

