/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.JSCHUIMessages;
import org.jkiss.dbeaver.model.net.ssh.JSCHUserInfoPromptProvider;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementationAbstract;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.net.ssh.config.SSHAuthConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHPortForwardConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SSHImplementationJsch
extends SSHImplementationAbstract {
    private static final String CHANNEL_TYPE_SFTP = "sftp";
    private static final Log log = Log.getLog(SSHImplementationJsch.class);
    private transient JSch jsch;
    private volatile transient Session[] sessions;

    protected synchronized void setupTunnel(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, @NotNull SSHHostConfiguration[] hosts, @NotNull SSHPortForwardConfiguration portForward) throws DBException, IOException {
        if (this.jsch == null) {
            this.jsch = new JSch();
            JSch.setLogger((Logger)new JschLoggerProxy());
        }
        this.sessions = new Session[hosts.length];
        int index = 0;
        while (index < hosts.length) {
            Session session;
            SSHHostConfiguration host = hosts[index];
            SSHAuthConfiguration auth = host.getAuthConfiguration();
            if (auth.getType() == SSHConstants.AuthType.PUBLIC_KEY) {
                log.debug((Object)"Adding identity key");
                try {
                    if (auth.getKeyFile() != null) {
                        this.addIdentityKeyFile(monitor, configuration.getDataSource(), auth.getKeyFile(), auth.getPassword());
                    }
                    this.addIdentityKeyValue(auth.getKeyValue(), auth.getPassword());
                }
                catch (JSchException e) {
                    throw new DBException("Cannot add identity key", (Throwable)e);
                }
            } else if (auth.getType() == SSHConstants.AuthType.AGENT) {
                log.debug((Object)"Creating identity repository");
                this.jsch.setIdentityRepository((IdentityRepository)this.agentIdentityRepository);
            }
            try {
                if (index > 0) {
                    int port = this.sessions[index - 1].setPortForwardingL(0, host.getHostname(), host.getPort());
                    monitor.subTask("Instantiate tunnel " + hosts[index - 1].getHostname() + ":" + port + " -> " + host.getHostname() + ":" + host.getPort());
                    session = this.jsch.getSession(host.getUsername(), "localhost", port);
                } else {
                    monitor.subTask("Instantiate tunnel to " + host.getHostname() + ":" + host.getPort());
                    session = this.jsch.getSession(host.getUsername(), host.getHostname(), host.getPort());
                }
                log.debug((Object)"Configure tunnel");
                UserInfo userInfo = null;
                JSCHUserInfoPromptProvider userInfoPromptProvider = (JSCHUserInfoPromptProvider)GeneralUtils.adapt((Object)((Object)this), JSCHUserInfoPromptProvider.class);
                if (userInfoPromptProvider != null) {
                    userInfo = userInfoPromptProvider.createUserInfoPrompt(host, session);
                }
                if (userInfo == null) {
                    userInfo = new JschUserInfo(auth);
                }
                session.setUserInfo(userInfo);
                session.setHostKeyAlias(host.getHostname());
                this.setupHostKeyVerification(session, configuration);
                session.setServerAliveInterval(configuration.getIntProperty("aliveInterval"));
                session.setTimeout(configuration.getIntProperty("sshConnectTimeout"));
                if (auth.getType() == SSHConstants.AuthType.PASSWORD) {
                    session.setConfig("PreferredAuthentications", "password,keyboard-interactive");
                } else {
                    session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
                }
                log.debug((Object)"Connect to tunnel host");
                session.connect();
                if (index == hosts.length - 1) {
                    log.debug((Object)("Set port forwarding " + portForward.getLocalHost() + ":" + portForward.getLocalPort() + " -> " + portForward.getRemoteHost() + ":" + portForward.getRemotePort()));
                    session.setPortForwardingL(portForward.getLocalHost(), portForward.getLocalPort(), portForward.getRemoteHost(), portForward.getRemotePort());
                }
            }
            catch (JSchException e) {
                this.closeTunnel(monitor);
                throw new DBException("Cannot establish tunnel to " + host.getHostname() + ":" + host.getPort(), (Throwable)e);
            }
            this.sessions[index] = session;
            ++index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupHostKeyVerification(Session session, DBWHandlerConfiguration configuration) throws JSchException {
        if (DBWorkbench.getPlatform().getApplication().isHeadlessMode() || configuration.getBooleanProperty("bypassHostVerification")) {
            session.setConfig("StrictHostKeyChecking", "no");
            return;
        } else {
            File knownHosts = SSHUtils.getKnownSshHostsFileOrNull();
            if (knownHosts != null) {
                try {
                    this.jsch.setKnownHosts(knownHosts.getAbsolutePath());
                    session.setConfig("StrictHostKeyChecking", "ask");
                    return;
                }
                catch (JSchException e) {
                    if (!(e.getCause() instanceof ArrayIndexOutOfBoundsException)) return;
                    if (!DBWorkbench.getPlatformUI().confirmAction(JSCHUIMessages.ssh_file_corrupted_dialog_title, JSCHUIMessages.ssh_file_corrupted_dialog_message, true)) throw e;
                    session.setConfig("StrictHostKeyChecking", "no");
                    return;
                }
            } else {
                session.setConfig("StrictHostKeyChecking", "ask");
            }
        }
    }

    public synchronized void closeTunnel(DBRProgressMonitor monitor) {
        if (ArrayUtils.isEmpty((Object[])this.sessions)) {
            return;
        }
        RuntimeUtils.runTask(monitor1 -> {
            Object[] sessions = this.sessions;
            if (ArrayUtils.isEmpty((Object[])sessions)) {
                return;
            }
            Object[] objectArray = sessions;
            int n = sessions.length;
            int n2 = 0;
            while (n2 < n) {
                Object session = objectArray[n2];
                if (session != null && session.isConnected()) {
                    session.disconnect();
                }
                ++n2;
            }
        }, (String)"Close SSH session", (long)1000L);
        this.sessions = null;
    }

    public synchronized String getClientVersion() {
        return ArrayUtils.isEmpty((Object[])this.sessions) ? null : this.sessions[this.sessions.length - 1].getClientVersion();
    }

    public synchronized String getServerVersion() {
        return ArrayUtils.isEmpty((Object[])this.sessions) ? null : this.sessions[this.sessions.length - 1].getServerVersion();
    }

    public void invalidateTunnel(DBRProgressMonitor monitor) throws DBException, IOException {
        boolean isAlive = false;
        if (isAlive) {
            try {
                Session[] sessionArray = this.sessions;
                int n = this.sessions.length;
                int n2 = 0;
                while (n2 < n) {
                    Session session = sessionArray[n2];
                    session.sendKeepAliveMsg();
                    ++n2;
                }
            }
            catch (Exception exception) {
                isAlive = false;
            }
        }
        if (!isAlive) {
            this.closeTunnel(monitor);
            this.initTunnel(monitor, this.savedConfiguration, this.savedConnectionInfo);
        }
    }

    public void getFile(@NotNull String src, @NotNull OutputStream dst, @NotNull DBRProgressMonitor monitor) throws DBException, IOException {
        ChannelSftp channel = this.openSftpChannel();
        try {
            try {
                channel.get(src, dst, (SftpProgressMonitor)new SftpProgressMonitorAdapter(monitor));
            }
            catch (SftpException e) {
                throw new IOException("Error downloading file through SFTP channel", e);
            }
        }
        finally {
            channel.disconnect();
        }
    }

    public void putFile(@NotNull InputStream src, @NotNull String dst, @NotNull DBRProgressMonitor monitor) throws DBException, IOException {
        ChannelSftp channel = this.openSftpChannel();
        try {
            try {
                channel.put(src, dst, (SftpProgressMonitor)new SftpProgressMonitorAdapter(monitor));
            }
            catch (SftpException e) {
                throw new IOException("Error uploading file through SFTP channel", e);
            }
        }
        finally {
            channel.disconnect();
        }
    }

    @NotNull
    private ChannelSftp openSftpChannel() throws DBException, IOException {
        ChannelSftp channel;
        Object[] sessions = this.sessions;
        if (ArrayUtils.isEmpty((Object[])sessions)) {
            throw new DBException("No active session available");
        }
        try {
            channel = (ChannelSftp)sessions[sessions.length - 1].openChannel(CHANNEL_TYPE_SFTP);
            channel.connect();
        }
        catch (JSchException e) {
            throw new IOException("Error opening SFTP channel", e);
        }
        return channel;
    }

    private void addIdentityKeyValue(String keyValue, String password) throws JSchException {
        byte[] keyBinary = keyValue.getBytes(StandardCharsets.UTF_8);
        if (!CommonUtils.isEmpty((String)password)) {
            this.jsch.addIdentity("key", keyBinary, null, password.getBytes());
        } else {
            this.jsch.addIdentity("key", keyBinary, null, null);
        }
    }

    private void addIdentityKeyFile(DBRProgressMonitor monitor, DBPDataSourceContainer dataSource, Path key, String password) throws IOException, JSchException {
        block33: {
            String header;
            Throwable throwable = null;
            Object var7_7 = null;
            try (BufferedReader reader = Files.newBufferedReader(key);){
                header = reader.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (header.equals("-----BEGIN OPENSSH PRIVATE KEY-----")) {
                log.debug((Object)"Attempting to convert an unsupported key into suitable format");
                String id = dataSource != null ? dataSource.getId() : "profile";
                Path dir = DBWorkbench.getPlatform().getTempFolder(monitor, "openssh-pkey");
                Path tmp = dir.resolve(String.valueOf(id) + ".pem");
                Files.copy(key, tmp, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                password = CommonUtils.notEmpty((String)password);
                if (RuntimeUtils.isWindows()) {
                    password = String.valueOf('\"') + password + '\"';
                }
                Process process = new ProcessBuilder(new String[0]).command("ssh-keygen", "-p", "-P", password, "-N", password, "-m", "PEM", "-f", tmp.toAbsolutePath().toString(), "-q").start();
                try {
                    try {
                        int status;
                        if (!process.waitFor(5000L, TimeUnit.MILLISECONDS)) {
                            process.destroyForcibly();
                        }
                        if ((status = process.exitValue()) != 0) {
                            String message;
                            Throwable throwable3 = null;
                            Object var13_16 = null;
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                                message = reader.lines().collect(Collectors.joining("\n"));
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                            throw new IOException("Specified private key cannot be converted:\n" + message);
                        }
                        this.addIdentityKey0(tmp, password);
                        break block33;
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                finally {
                    try {
                        Files.delete(tmp);
                    }
                    catch (IOException e) {
                        log.debug((Object)"Failed to delete private key file", (Throwable)e);
                    }
                }
            }
            this.addIdentityKey0(key, password);
        }
    }

    private void addIdentityKey0(Path key, String password) throws JSchException {
        if (!CommonUtils.isEmpty((String)password)) {
            this.jsch.addIdentity(key.toAbsolutePath().toString(), password);
        } else {
            this.jsch.addIdentity(key.toAbsolutePath().toString());
        }
    }

    private static class JschLoggerProxy
    implements Logger {
        private JschLoggerProxy() {
        }

        public boolean isEnabled(int level) {
            return true;
        }

        public void log(int level, String message) {
            log.debug((Object)("SSH " + (switch (level) {
                case 1 -> "INFO";
                case 2 -> "WARN";
                case 3 -> "ERROR";
                case 4 -> "FATAL";
                default -> "DEBUG";
            }) + ": " + message));
        }
    }

    private static class JschUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private final SSHAuthConfiguration configuration;

        private JschUserInfo(@NotNull SSHAuthConfiguration configuration) {
            this.configuration = configuration;
        }

        public String getPassphrase() {
            return this.configuration.getPassword();
        }

        public String getPassword() {
            return this.configuration.getPassword();
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptYesNo(String message) {
            return false;
        }

        public void showMessage(String message) {
            log.info((Object)message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            log.debug((Object)"JSCH keyboard interactive auth");
            return new String[]{this.configuration.getPassword()};
        }
    }

    private static class SftpProgressMonitorAdapter
    implements SftpProgressMonitor {
        private final DBRProgressMonitor delegate;

        public SftpProgressMonitorAdapter(@NotNull DBRProgressMonitor delegate) {
            this.delegate = delegate;
        }

        public void init(int op, String src, String dst, long max) {
            if (op == 0) {
                this.delegate.beginTask(NLS.bind((String)"Upload file ''{0}'' -> ''{1}''", (Object)src, (Object)dst), (int)max);
            } else {
                this.delegate.beginTask(NLS.bind((String)"Download file ''{0}'' -> ''{1}''", (Object)src, (Object)dst), (int)max);
            }
        }

        public boolean count(long count) {
            this.delegate.worked((int)count);
            return !this.delegate.isCanceled();
        }

        public void end() {
            this.delegate.done();
        }
    }
}

