/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics.model;

import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsSourceModel;

public class SQLQueryRowsTableDataModel
extends SQLQueryRowsSourceModel
implements SQLQuerySymbolDefinition {
    private final SQLQueryQualifiedName name;
    private DBSEntity table = null;

    public SQLQueryRowsTableDataModel(@NotNull SQLQueryQualifiedName name) {
        this.name = name;
    }

    public SQLQueryQualifiedName getName() {
        return this.name;
    }

    public DBSEntity getTable() {
        return this.table;
    }

    @Override
    @NotNull
    public SQLQuerySymbolClass getSymbolClass() {
        return this.table != null ? SQLQuerySymbolClass.TABLE : SQLQuerySymbolClass.ERROR;
    }

    @NotNull
    private SQLQuerySymbol prepareColumnSymbol(@NotNull SQLQueryDataContext context, @NotNull DBSEntityAttribute attr) {
        SQLDialect dialect = context.getDialect();
        String name = dialect.mustBeQuoted(attr.getName(), false) ? dialect.getQuotedIdentifier(attr.getName(), false, false) : attr.getName().toLowerCase();
        SQLQuerySymbol symbol = new SQLQuerySymbol(name);
        symbol.setDefinition(new SQLQuerySymbolByDbObjectDefinition((DBSObject)attr, SQLQuerySymbolClass.COLUMN));
        return symbol;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        this.table = context.findRealTable(this.name.toListOfStrings());
        if (this.table != null) {
            this.name.setDefinition(this.table);
            context = context.extendWithRealTable(this.table, this);
            try {
                List attributes = this.table.getAttributes((DBRProgressMonitor)new VoidProgressMonitor());
                if (attributes != null) {
                    SQLQueryDataContext attrsContext = context;
                    List<SQLQuerySymbol> columns = attributes.stream().filter(a -> !DBUtils.isHiddenObject((Object)a)).map(a -> this.prepareColumnSymbol(attrsContext, (DBSEntityAttribute)a)).collect(Collectors.toList());
                    context = context.overrideResultTuple(columns);
                }
            }
            catch (DBException ex) {
                statistics.appendError(this.name.entityName, "Failed to resolve table", ex);
            }
        } else {
            this.name.setSymbolClass(SQLQuerySymbolClass.ERROR);
            statistics.appendError(this.name.entityName, "Table not found");
        }
        return context;
    }
}

