/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDAttributeVisibility;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.erd.ui.ERDUIUtils;
import org.jkiss.dbeaver.erd.ui.command.AttributeCheckCommand;
import org.jkiss.dbeaver.erd.ui.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.erd.ui.editor.ERDHighlightingHandle;
import org.jkiss.dbeaver.erd.ui.figures.AttributeItemFigure;
import org.jkiss.dbeaver.erd.ui.figures.EditableLabel;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIActivator;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIMessages;
import org.jkiss.dbeaver.erd.ui.part.AssociationPart;
import org.jkiss.dbeaver.erd.ui.part.NodePart;
import org.jkiss.dbeaver.erd.ui.policy.AttributeConnectionEditPolicy;
import org.jkiss.dbeaver.erd.ui.policy.AttributeDragAndDropEditPolicy;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;

public class AttributePart
extends NodePart {
    public static final String PROP_CHECKED = "CHECKED";
    private ERDHighlightingHandle associatedRelationsHighlighing = null;
    private AbstractGraphicalEditPart.AccessibleGraphicalEditPart accPart;

    public boolean isSelectable() {
        return true;
    }

    public ERDEntityAttribute getAttribute() {
        return (ERDEntityAttribute)this.getModel();
    }

    public ERDEntity getEntity() {
        return (ERDEntity)this.getParent().getModel();
    }

    public String getAttributeLabel() {
        return ERDUIUtils.getFullAttributeLabel(this.getDiagram(), this.getAttribute(), false);
    }

    protected void addSourceConnection(ConnectionEditPart connection, int index) {
        if (!this.getEditor().getDiagramRouter().supportedAttributeAssociation() || ERDAttributeVisibility.isHideAttributeAssociations((DBPPreferenceStore)ERDUIActivator.getDefault().getPreferences())) {
            return;
        }
        if (((AssociationPart)connection).getAssociation().getSourceAttributes().contains(this.getAttribute())) {
            super.addSourceConnection(connection, index);
        }
    }

    @Override
    protected List<ERDAssociation> getModelSourceConnections() {
        if (!this.getEditor().getDiagramRouter().supportedAttributeAssociation() || ERDAttributeVisibility.isHideAttributeAssociations((DBPPreferenceStore)ERDUIActivator.getDefault().getPreferences())) {
            return Collections.emptyList();
        }
        ArrayList<ERDAssociation> list = new ArrayList<ERDAssociation>();
        for (ERDAssociation erdAssociation : super.getModelSourceConnections()) {
            if (!erdAssociation.getSourceAttributes().contains(this.getAttribute()) || erdAssociation.getSourceEntity() == null) continue;
            list.add(erdAssociation);
        }
        return list;
    }

    @Override
    protected List<ERDAssociation> getModelTargetConnections() {
        if (!this.getEditor().getDiagramRouter().supportedAttributeAssociation() || ERDAttributeVisibility.isHideAttributeAssociations((DBPPreferenceStore)ERDUIActivator.getDefault().getPreferences())) {
            return Collections.emptyList();
        }
        ArrayList<ERDAssociation> list = new ArrayList<ERDAssociation>();
        for (ERDAssociation erdAssociation : super.getModelTargetConnections()) {
            if (!erdAssociation.getTargetAttributes().contains(this.getAttribute()) || erdAssociation.getTargetEntity() == null) continue;
            list.add(erdAssociation);
        }
        return list;
    }

    protected void addTargetConnection(ConnectionEditPart connection, int index) {
        if (!this.getEditor().getDiagramRouter().supportedAttributeAssociation() || ERDAttributeVisibility.isHideAttributeAssociations((DBPPreferenceStore)ERDUIActivator.getDefault().getPreferences())) {
            return;
        }
        if (((AssociationPart)connection).getAssociation().getTargetAttributes().contains(this.getAttribute())) {
            super.addTargetConnection(connection, index);
        }
    }

    protected AttributeItemFigure createFigure() {
        return new AttributeItemFigure(this);
    }

    public AttributeItemFigure getFigure() {
        return (AttributeItemFigure)super.getFigure();
    }

    protected void createEditPolicies() {
        if (!this.getEditor().isReadOnly()) {
            if (this.isLayoutEnabled() && this.getEditPolicy("ContainerEditPolicy") == null && this.isColumnDragAndDropSupported()) {
                this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new AttributeConnectionEditPolicy(this));
                this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new AttributeDragAndDropEditPolicy(this));
            }
            this.getDiagram().getModelAdapter().installPartEditPolicies((EditPart)this);
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            ERDUIUtils.openObjectEditor(this.getDiagram(), (ERDObject)this.getAttribute());
        } else {
            this.getDiagram().getModelAdapter().performPartRequest((EditPart)this, request);
        }
    }

    public AttributeCheckCommand createAttributeCheckCommand(boolean newChecked) {
        return new AttributeCheckCommand<AttributePart>(this, newChecked);
    }

    public void setSelected(int value) {
        super.setSelected(value);
        EditableLabel columnLabel = this.getFigure().getLabel();
        columnLabel.setSelected(value != 0);
        columnLabel.repaint();
        if (value != 0) {
            if (this.getViewer() instanceof ERDGraphicalViewer && this.associatedRelationsHighlighing == null) {
                Color color = UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.fk.highlighting");
                this.associatedRelationsHighlighing = ((ERDGraphicalViewer)this.getViewer()).getEditor().getHighlightingManager().highlightAttributeAssociations(this, color);
            }
        } else if (this.associatedRelationsHighlighing != null) {
            this.associatedRelationsHighlighing.release();
            this.associatedRelationsHighlighing = null;
        }
    }

    public void handleNameChange() {
        AttributeItemFigure figure = this.getFigure();
        figure.updateLabels();
        this.setSelected(0);
        figure.revalidate();
    }

    @Override
    protected void commitNameChange(PropertyChangeEvent evt) {
        AttributeItemFigure figure = this.getFigure();
        figure.updateLabels();
        this.setSelected(2);
        figure.revalidate();
    }

    protected void refreshVisuals() {
        this.getFigure().updateLabels();
    }

    public DragTracker getDragTracker(Request request) {
        DragEditPartsTracker dragTracker = new DragEditPartsTracker((EditPart)this);
        dragTracker.setDefaultCursor(SharedCursors.CURSOR_TREE_MOVE);
        return dragTracker;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    protected void registerVisuals() {
        super.registerVisuals();
        Map visualPartMap = this.getViewer().getVisualPartMap();
        visualPartMap.put(this.getFigure().getCheckBox(), this);
        visualPartMap.put(this.getFigure().getLabel(), this);
    }

    protected void unregisterVisuals() {
        Map visualPartMap = this.getViewer().getVisualPartMap();
        visualPartMap.remove((Object)this.getFigure().getLabel());
        visualPartMap.remove((Object)this.getFigure().getCheckBox());
        super.unregisterVisuals();
    }

    public String toString() {
        return String.valueOf(ERDUIMessages.column_.trim()) + " " + this.getAttribute().getLabelText();
    }

    @Override
    public ERDElement getElement() {
        return this.getEntity();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accPart == null) {
            this.accPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                public void getName(AccessibleEvent e) {
                    e.result = NLS.bind((String)ERDUIMessages.erd_accessibility_attribute_part, (Object)ERDUIUtils.getFullAttributeLabel(AttributePart.this.getDiagram(), AttributePart.this.getAttribute(), true, true));
                }
            };
        }
        return this.accPart;
    }
}

