/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.wmi.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.wmi.service.WMIException;
import org.jkiss.wmi.service.WMIObject;
import org.jkiss.wmi.service.WMIObjectSink;
import org.jkiss.wmi.service.WMIObjectSinkStatus;
import org.jkiss.wmi.service.WMIService;

class WMIObjectCollectorSink
implements WMIObjectSink {
    private static final Log log = Log.getLog(WMIObjectCollectorSink.class);
    private final DBRProgressMonitor monitor;
    private final WMIService service;
    private final List<WMIObject> objectList = new ArrayList<WMIObject>();
    private final long firstRow;
    private final long maxRows;
    private volatile boolean finished = false;
    private long totalIndicated = 0L;
    private String errorDesc;

    public WMIObjectCollectorSink(DBRProgressMonitor monitor, WMIService service) {
        this.monitor = monitor;
        this.service = service;
        this.firstRow = 0L;
        this.maxRows = 0L;
    }

    WMIObjectCollectorSink(DBRProgressMonitor monitor, WMIService service, long firstRow, long maxRows) {
        this.monitor = monitor;
        this.service = service;
        this.firstRow = firstRow;
        this.maxRows = maxRows;
    }

    public List<WMIObject> getObjectList() {
        return this.objectList;
    }

    public void indicate(WMIObject[] objects) {
        if (this.finished) {
            return;
        }
        if (this.firstRow <= 0L && this.maxRows <= 0L) {
            Collections.addAll(this.objectList, objects);
            this.totalIndicated += (long)objects.length;
        } else {
            int startPos;
            int lastPos = objects.length - 1;
            if (this.firstRow > 0L) {
                if (this.totalIndicated + (long)objects.length < this.firstRow) {
                    this.totalIndicated += (long)objects.length;
                    return;
                }
                startPos = this.totalIndicated < this.firstRow ? (int)(this.firstRow - this.totalIndicated) : 0;
            } else {
                startPos = 0;
            }
            this.totalIndicated += (long)startPos;
            int i = startPos;
            while (i <= lastPos) {
                if ((long)this.objectList.size() >= this.maxRows) {
                    this.finished = true;
                    break;
                }
                this.objectList.add(objects[i]);
                ++this.totalIndicated;
                ++i;
            }
            if (this.finished) {
                try {
                    this.service.cancelSink((WMIObjectSink)this);
                }
                catch (WMIException e) {
                    log.warn((Object)e);
                }
            }
        }
        this.monitor.subTask(String.valueOf(String.valueOf(this.objectList.size())) + " objects loaded");
    }

    public void setStatus(WMIObjectSinkStatus status, int result, String param, WMIObject errorObject) {
        if (status == WMIObjectSinkStatus.complete || status == WMIObjectSinkStatus.error) {
            this.finished = true;
            if (status == WMIObjectSinkStatus.error) {
                this.errorDesc = param;
            }
        }
        if (errorObject != null) {
            errorObject.release();
        }
    }

    public void waitForFinish() throws WMIException {
        try {
            while (!this.monitor.isCanceled() && !this.finished) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {}
        if (this.monitor.isCanceled()) {
            this.finished = true;
            this.service.cancelSink((WMIObjectSink)this);
        }
        if (this.errorDesc != null) {
            throw new WMIException(this.errorDesc);
        }
    }
}

