/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.data.StringContent;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressLoaderVisualizer;
import org.jkiss.dbeaver.ui.data.IStreamValueEditor;
import org.jkiss.dbeaver.ui.data.IStreamValueManager;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;
import org.jkiss.dbeaver.ui.data.registry.StreamValueManagerDescriptor;
import org.jkiss.dbeaver.ui.data.registry.ValueManagerRegistry;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class ContentPanelEditor
extends BaseValueEditor<Control>
implements IAdaptable {
    private static final Log log = Log.getLog(ContentPanelEditor.class);
    private static final String PROP_VALUE_MANAGER = "valueManager";
    private static Map<String, String> valueToManagerMap = new HashMap<String, String>();
    private Map<StreamValueManagerDescriptor, IStreamValueManager.MatchType> streamManagers;
    private volatile StreamValueManagerDescriptor curStreamManager;
    private IStreamValueEditor<Control> streamEditor;
    private Control editorControl;
    private IContributionManager toolbarManager;

    public ContentPanelEditor(IValueController controller) {
        super(controller);
        DBPPreferenceStore store;
        String managerId;
        if (controller.getExecutionContext() != null && CommonUtils.isNotEmpty((String)(managerId = (store = controller.getExecutionContext().getDataSource().getContainer().getPreferenceStore()).getString("valueManager." + this.makeValueId(false))))) {
            valueToManagerMap.put(this.makeValueId(true), managerId);
        }
    }

    @Override
    public void dispose() {
        if (this.streamEditor != null) {
            this.streamEditor.disposeEditor();
            this.streamEditor = null;
        }
        super.dispose();
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller) throws DBCException {
        manager.add((IAction)new ContentTypeSwitchAction());
        if (this.streamEditor != null) {
            this.streamEditor.contributeActions(manager, this.editorControl);
        } else {
            this.toolbarManager = manager;
        }
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        this.primeEditorValue(value, true);
    }

    protected void primeEditorValue(@Nullable Object value, boolean loadInService) throws DBException {
        Object content = this.valueController.getValue();
        if (this.streamEditor == null) {
            return;
        }
        if (content instanceof DBDContent) {
            this.streamManagers = ValueManagerRegistry.getInstance().getApplicableStreamManagers((DBRProgressMonitor)new VoidProgressMonitor(), this.valueController.getValueType(), (DBDContent)content);
            if (this.streamManagers != null && !this.streamManagers.containsKey((Object)this.curStreamManager)) {
                if (this.curStreamManager != null) {
                    if (this.streamEditor != null) {
                        this.streamEditor.disposeEditor();
                        this.streamEditor = null;
                    }
                    if (this.editorControl != null) {
                        this.editorControl.dispose();
                        this.editorControl = null;
                    }
                    this.curStreamManager = null;
                    this.control.dispose();
                }
                this.control = this.createControl(this.valueController.getEditPlaceholder());
                this.valueController.getEditPlaceholder().layout(true, true);
            }
        }
        if (this.isStringValue()) {
            this.streamEditor.primeEditorValue((DBRProgressMonitor)new VoidProgressMonitor(), this.control, (DBDContent)new StringContent(this.valueController.getExecutionContext(), CommonUtils.toString((Object)content)));
        } else if (content instanceof DBDContent) {
            boolean bl = loadInService = !(content instanceof DBDContentCached);
            if (loadInService) {
                StreamValueLoadService loadingService = new StreamValueLoadService((DBDContent)content);
                Composite ph = this.control instanceof Composite ? (Composite)this.control : this.valueController.getEditPlaceholder();
                LoadingJob.createService((ILoadService)loadingService, (ILoadVisualizer)new StreamValueLoadVisualizer(loadingService, ph)).schedule();
            } else {
                this.streamEditor.primeEditorValue((DBRProgressMonitor)new VoidProgressMonitor(), this.control, (DBDContent)content);
            }
        } else if (content == null) {
            this.valueController.showMessage("NULL content value. Must be DBDContent.", DBPMessageType.ERROR);
        } else {
            this.valueController.showMessage("Unsupported content value. Must be DBDContent or String.", DBPMessageType.ERROR);
        }
    }

    private boolean isStringValue() {
        return !(this.valueController.getValue() instanceof DBDContent);
    }

    @Override
    public Object extractEditorValue() throws DBException {
        Object content = this.valueController.getValue();
        if (this.isStringValue()) {
            StringContent stringContent = new StringContent(this.valueController.getExecutionContext(), null);
            this.streamEditor.extractEditorValue((DBRProgressMonitor)new VoidProgressMonitor(), this.control, (DBDContent)stringContent);
            return stringContent.getRawValue();
        }
        if (content == null) {
            log.warn((Object)"NULL content value. Must be DBDContent.");
        } else if (this.streamEditor == null) {
            log.warn((Object)"NULL content editor.");
        } else {
            try {
                this.streamEditor.extractEditorValue((DBRProgressMonitor)new VoidProgressMonitor(), this.control, (DBDContent)content);
            }
            catch (Throwable e) {
                log.debug((Object)e);
                this.valueController.showMessage(e.getMessage(), DBPMessageType.ERROR);
            }
        }
        return content;
    }

    @Override
    protected Control createControl(Composite editPlaceholder) {
        Object content = this.valueController.getValue();
        if (this.curStreamManager == null) {
            if (this.isStringValue()) {
                try {
                    this.loadStringStreamManagers();
                }
                catch (Throwable e) {
                    DBWorkbench.getPlatformUI().showError("No string editor", "Can't load string content managers", e);
                }
            } else {
                try {
                    this.detectStreamManager((DBRProgressMonitor)new VoidProgressMonitor(), (DBDContent)content);
                }
                catch (DBException e) {
                    log.error((Object)e);
                    this.valueController.showMessage(e.getMessage(), DBPMessageType.ERROR);
                    return editPlaceholder;
                }
            }
        }
        return this.createStreamManagerControl(editPlaceholder);
    }

    private Control createStreamManagerControl(Composite editPlaceholder) {
        if (this.curStreamManager != null) {
            try {
                this.streamEditor = this.curStreamManager.getInstance().createPanelEditor(this.valueController);
            }
            catch (Throwable e) {
                DBWorkbench.getPlatformUI().showError("No stream editor", "Can't create stream editor", e);
            }
        }
        if (this.streamEditor == null) {
            return UIUtils.createInfoLabel((Composite)editPlaceholder, (String)"No Editor");
        }
        this.editorControl = this.streamEditor.createControl(this.valueController);
        if (this.toolbarManager != null) {
            if (this.toolbarManager instanceof ToolBarManager) {
                ((ToolBarManager)this.toolbarManager).getControl().setRedraw(false);
            }
            try {
                try {
                    this.streamEditor.contributeActions(this.toolbarManager, this.editorControl);
                    this.toolbarManager.update(true);
                }
                catch (Exception e) {
                    log.error((Object)e);
                    if (this.toolbarManager instanceof ToolBarManager) {
                        ((ToolBarManager)this.toolbarManager).getControl().setRedraw(true);
                    }
                    this.toolbarManager = null;
                }
            }
            finally {
                if (this.toolbarManager instanceof ToolBarManager) {
                    ((ToolBarManager)this.toolbarManager).getControl().setRedraw(true);
                }
                this.toolbarManager = null;
            }
        }
        return this.editorControl;
    }

    private void loadStringStreamManagers() throws DBException {
        this.streamManagers = ValueManagerRegistry.getInstance().getStreamManagersByMimeType("text", "text/plain");
        String savedManagerId = valueToManagerMap.get(this.makeValueId(true));
        this.detectCurrentStreamManager(savedManagerId);
    }

    private void detectCurrentStreamManager(String savedManagerId) throws DBException {
        if (savedManagerId != null) {
            this.curStreamManager = this.findManager(savedManagerId);
        }
        if (this.curStreamManager == null) {
            this.curStreamManager = this.findManager(IStreamValueManager.MatchType.EXCLUSIVE);
            if (this.curStreamManager == null) {
                this.curStreamManager = this.findManager(IStreamValueManager.MatchType.PRIMARY);
            }
            if (this.curStreamManager == null) {
                this.curStreamManager = this.findManager(IStreamValueManager.MatchType.DEFAULT);
            }
            if (this.curStreamManager == null) {
                this.curStreamManager = this.findManager(IStreamValueManager.MatchType.APPLIES);
            }
            if (this.curStreamManager == null) {
                throw new DBException("Can't find appropriate stream manager");
            }
        }
    }

    private void runSreamManagerDetector(DBDContent content, Composite editPlaceholder) {
        StreamManagerDetectService loadingService = new StreamManagerDetectService(content);
        LoadingJob.createService((ILoadService)loadingService, (ILoadVisualizer)new StreamManagerDetectVisualizer(loadingService, editPlaceholder)).schedule();
    }

    @Nullable
    public StreamValueManagerDescriptor getCurrentStreamManager() {
        return this.curStreamManager;
    }

    @Nullable
    public IStreamValueEditor<Control> getStreamEditor() {
        return this.streamEditor;
    }

    public void setCurrentStreamManager(@NotNull StreamValueManagerDescriptor newManager) {
        if (this.curStreamManager == newManager) {
            return;
        }
        this.curStreamManager = newManager;
        if (this.curStreamManager != null) {
            String valueId = this.makeValueId(true);
            String managerId = this.curStreamManager.getId();
            if (this.valueController.getExecutionContext() != null) {
                DBPPreferenceStore store = this.valueController.getExecutionContext().getDataSource().getContainer().getPreferenceStore();
                store.setValue("valueManager." + this.makeValueId(false), managerId);
                PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
            }
            valueToManagerMap.put(valueId, managerId);
            this.valueController.refreshEditor();
        }
    }

    private String makeValueId(boolean includeDataSource) {
        String valueId;
        DBSTypedObject valueType = this.valueController.getValueType();
        if (valueType instanceof DBDAttributeBinding) {
            valueType = ((DBDAttributeBinding)valueType).getAttribute();
        }
        if (valueType instanceof DBSObject) {
            DBSObject object = (DBSObject)valueType;
            valueId = DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DDL);
            if (object.getParentObject() != null) {
                valueId = String.valueOf(DBUtils.getObjectFullName((DBPNamedObject)object.getParentObject(), (DBPEvaluationContext)DBPEvaluationContext.DDL)) + ":" + valueId;
            }
        } else {
            valueId = this.valueController.getValueName();
        }
        if (includeDataSource) {
            String dsId = "unknown";
            if (this.valueController.getExecutionContext() != null) {
                dsId = this.valueController.getExecutionContext().getDataSource().getContainer().getId();
            }
            return String.valueOf(dsId) + ":" + valueId;
        }
        return valueId;
    }

    private StreamValueManagerDescriptor findManager(String id) {
        for (Map.Entry<StreamValueManagerDescriptor, IStreamValueManager.MatchType> entry : this.streamManagers.entrySet()) {
            if (!entry.getKey().getId().equals(id)) continue;
            return entry.getKey();
        }
        return null;
    }

    private StreamValueManagerDescriptor findManager(IStreamValueManager.MatchType matchType) {
        for (Map.Entry<StreamValueManagerDescriptor, IStreamValueManager.MatchType> entry : this.streamManagers.entrySet()) {
            if (entry.getValue() != matchType) continue;
            return entry.getKey();
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.streamEditor != null) {
            if (adapter.isAssignableFrom(this.streamEditor.getClass())) {
                return adapter.cast(this.streamEditor);
            }
            if (this.streamEditor instanceof IAdaptable) {
                return (T)((IAdaptable)this.streamEditor).getAdapter(adapter);
            }
        }
        return null;
    }

    private void detectStreamManager(DBRProgressMonitor monitor, DBDContent content) throws DBException {
        this.streamManagers = ValueManagerRegistry.getInstance().getApplicableStreamManagers(monitor, this.valueController.getValueType(), content);
        String savedManagerId = valueToManagerMap.get(this.makeValueId(true));
        this.detectCurrentStreamManager(savedManagerId);
    }

    private class ContentLoadVisualizer
    extends ProgressLoaderVisualizer<DBDContent> {
        protected Composite editPlaceholder;

        public ContentLoadVisualizer(ContentLoaderService loadingService, Composite parent) {
            super((ILoadService)loadingService, parent);
            this.editPlaceholder = parent;
        }

        public void completeLoading(DBDContent result) {
            super.completeLoading((Object)result);
            super.visualizeLoading();
        }
    }

    abstract class ContentLoaderService
    extends AbstractLoadService<DBDContent> {
        protected DBDContent content;

        protected ContentLoaderService(DBDContent content) {
            super("Load LOB value");
            this.content = content;
        }

        public Object getFamily() {
            return ContentPanelEditor.this.valueController.getExecutionContext();
        }
    }

    private class ContentTypeSwitchAction
    extends Action
    implements SelectionListener {
        private Menu menu;

        ContentTypeSwitchAction() {
            super(null, 4);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PAGES));
            this.setToolTipText("Content viewer settings");
        }

        public void runWithEvent(Event event) {
            if (event.widget instanceof ToolItem) {
                ToolItem toolItem = (ToolItem)event.widget;
                Menu menu = this.createMenu(toolItem);
                Rectangle bounds = toolItem.getBounds();
                Point point = toolItem.getParent().toDisplay(bounds.x, bounds.y + bounds.height);
                menu.setLocation(point.x, point.y);
                menu.setVisible(true);
            }
        }

        private Menu createMenu(ToolItem toolItem) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            MenuManager menuManager = new MenuManager();
            ToolBar toolBar = toolItem.getParent();
            this.menu = new Menu((Control)toolBar);
            ArrayList<StreamValueManagerDescriptor> managers = new ArrayList<StreamValueManagerDescriptor>(ContentPanelEditor.this.streamManagers.keySet());
            managers.sort(Comparator.comparing(StreamValueManagerDescriptor::getLabel));
            for (StreamValueManagerDescriptor manager : managers) {
                CommandContributionItemParameter parameters = new CommandContributionItemParameter((IServiceLocator)ContentPanelEditor.this.valueController.getValueSite(), manager.getId(), "org.jkiss.dbeaver.core.resultset.grid.switchContentViewer", 16);
                parameters.parameters = Map.of("managerId", manager.getId());
                menuManager.add((IContributionItem)new CommandContributionItem(parameters));
            }
            try {
                ContentPanelEditor.this.streamEditor.contributeSettings((IContributionManager)menuManager, ContentPanelEditor.this.editorControl);
            }
            catch (DBCException e2) {
                log.error((Object)e2);
            }
            IContributionItem[] iContributionItemArray = menuManager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                item.fill(this.menu, -1);
                ++n2;
            }
            toolBar.addDisposeListener(e -> this.menu.dispose());
            MenuItem[] menuItemArray = this.menu.getItems();
            int n3 = menuItemArray.length;
            int n4 = 0;
            while (n4 < n3) {
                MenuItem item = menuItemArray[n4];
                if (item.getData() instanceof StreamValueManagerDescriptor) {
                    item.setSelection(item.getData() == ContentPanelEditor.this.curStreamManager);
                }
                ++n4;
            }
            return this.menu;
        }

        public void widgetSelected(SelectionEvent e) {
            MenuItem[] menuItemArray = this.menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                StreamValueManagerDescriptor newManager;
                Object itemData;
                MenuItem item = menuItemArray[n2];
                if (item.getSelection() && (itemData = item.getData()) instanceof StreamValueManagerDescriptor && (newManager = (StreamValueManagerDescriptor)((Object)itemData)) != ContentPanelEditor.this.curStreamManager) {
                    ContentPanelEditor.this.setCurrentStreamManager(newManager);
                }
                ++n2;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class StreamManagerDetectService
    extends ContentLoaderService {
        public StreamManagerDetectService(DBDContent content) {
            super(content);
        }

        public DBDContent evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Detect appropriate editor", 1);
            try {
                try {
                    monitor.subTask("Load LOB value");
                    ContentPanelEditor.this.detectStreamManager(monitor, this.content);
                }
                catch (Exception e) {
                    ContentPanelEditor.this.valueController.showMessage(e.getMessage(), DBPMessageType.ERROR);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return this.content;
        }
    }

    private class StreamManagerDetectVisualizer
    extends ContentLoadVisualizer {
        public StreamManagerDetectVisualizer(StreamManagerDetectService loadingService, Composite parent) {
            super(loadingService, parent);
        }

        @Override
        public void completeLoading(DBDContent result) {
            super.completeLoading(result);
            UIUtils.disposeChildControls((Composite)this.editPlaceholder);
            Control editorControl = ContentPanelEditor.this.createStreamManagerControl(this.editPlaceholder);
            this.editPlaceholder.layout(true);
            ContentPanelEditor.this.setControl(editorControl);
            try {
                ContentPanelEditor.this.primeEditorValue(result, false);
            }
            catch (Exception e) {
                ContentPanelEditor.this.valueController.showMessage(CommonUtils.notEmpty((String)e.getMessage()), DBPMessageType.ERROR);
            }
        }
    }

    private class StreamValueLoadService
    extends ContentLoaderService {
        public StreamValueLoadService(DBDContent content) {
            super(content);
        }

        public DBDContent evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Detect appropriate editor", 1);
            try {
                monitor.subTask("Prime LOB value");
                UIUtils.syncExec(() -> {
                    try {
                        if (ContentPanelEditor.this.streamEditor != null && !ContentPanelEditor.this.control.isDisposed()) {
                            ContentPanelEditor.this.streamEditor.primeEditorValue(monitor, ContentPanelEditor.this.control, this.content);
                        }
                    }
                    catch (Exception e) {
                        ContentPanelEditor.this.valueController.showMessage(e.getMessage(), DBPMessageType.ERROR);
                        DBWorkbench.getPlatformUI().showError("Value panel", "Error loading contents", (Throwable)e);
                    }
                });
            }
            finally {
                monitor.done();
            }
            return this.content;
        }
    }

    private class StreamValueLoadVisualizer
    extends ContentLoadVisualizer {
        public StreamValueLoadVisualizer(StreamValueLoadService loadingService, Composite parent) {
            super(loadingService, parent);
        }

        @Override
        public void completeLoading(DBDContent result) {
            super.completeLoading(result);
        }
    }
}

