/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.stm;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMTreeTermNode;

public class STMUtils {
    @NotNull
    public static List<STMTreeNode> expandSubtree(@NotNull STMTreeNode root, @Nullable Set<String> toExpand, @NotNull Set<String> toCollect) {
        ArrayList<STMTreeNode> result = new ArrayList<STMTreeNode>();
        Stack<STMTreeNode> stack = new Stack<STMTreeNode>();
        stack.add(root);
        while (stack.size() > 0) {
            STMTreeNode node = (STMTreeNode)stack.pop();
            String nodeName = node.getNodeName();
            if (toCollect.contains(nodeName)) {
                result.add(node);
                continue;
            }
            if (toExpand != null && !toExpand.contains(nodeName)) continue;
            int i = node.getChildCount() - 1;
            while (i >= 0) {
                stack.push((STMTreeNode)node.getChild(i));
                --i;
            }
        }
        return result;
    }

    @NotNull
    public static List<STMTreeTermNode> expandTerms(@NotNull STMTreeNode root) {
        ArrayList<STMTreeTermNode> result = new ArrayList<STMTreeTermNode>();
        Stack<STMTreeNode> stack = new Stack<STMTreeNode>();
        stack.add(root);
        while (stack.size() > 0) {
            STMTreeNode node = (STMTreeNode)stack.pop();
            if (node instanceof STMTreeTermNode var4_4) {
                result.add((STMTreeTermNode)term);
                continue;
            }
            int i = 0;
            while (i < node.getChildCount()) {
                stack.push((STMTreeNode)node.getChild(i));
                ++i;
            }
        }
        return result;
    }

    @NotNull
    public static List<String> expandTermStrings(@NotNull STMTreeNode root) {
        ArrayList<String> result = new ArrayList<String>();
        Stack<STMTreeNode> stack = new Stack<STMTreeNode>();
        stack.add(root);
        while (stack.size() > 0) {
            STMTreeNode node = (STMTreeNode)stack.pop();
            if (node instanceof STMTreeTermNode var4_4) {
                result.add(term.getText());
                continue;
            }
            int i = 0;
            while (i < node.getChildCount()) {
                stack.push((STMTreeNode)node.getChild(i));
                ++i;
            }
        }
        return result;
    }
}

