/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

final class MessageBoxModern
extends BaseDialog {
    @Nullable
    private String message;
    @Nullable
    private List<String> labels;
    private int defaultAnswerIdx;
    @Nullable
    private DBPImage primaryImage;
    @Nullable
    private Consumer<? super Composite> customArea;
    @Nullable
    private List<Button> buttons;

    MessageBoxModern(@Nullable Shell parentShell) {
        super(parentShell, null, null);
    }

    void setMessage(@Nullable String message) {
        this.message = message;
    }

    void setPrimaryImage(@NotNull DBPImage primaryImage) {
        this.primaryImage = primaryImage;
    }

    void setLabels(@NotNull List<String> labels) {
        this.labels = labels;
    }

    void setDefaultAnswerIdx(int defaultAnswerIdx) {
        this.defaultAnswerIdx = defaultAnswerIdx;
    }

    void setCustomArea(Consumer<? super Composite> customArea) {
        this.customArea = customArea;
    }

    @Override
    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        Point defaultSpacing = LayoutConstants.getSpacing();
        gl.horizontalSpacing = defaultSpacing.x * 2;
        gl.verticalSpacing = defaultSpacing.y;
        Point defaultMargins = LayoutConstants.getMargins();
        gl.marginWidth = defaultMargins.x;
        gl.marginHeight = defaultMargins.y;
        gl.numColumns = 2;
        parent.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        parent.setLayoutData((Object)gd);
        this.dialogArea = this.createDialogArea(parent);
        this.buttonBar = this.createButtonBar(parent);
        MessageBoxModern.applyDialogFont((Control)parent);
        return parent;
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        GridData gd;
        if (this.primaryImage != null) {
            Label imageLabel = UIUtils.createLabel(parent, this.primaryImage);
            gd = new GridData();
            gd.minimumWidth = 1;
            gd.minimumHeight = 1;
            gd.horizontalAlignment = 0x1000000;
            gd.verticalAlignment = 1;
            imageLabel.setLayoutData((Object)gd);
        }
        Composite content = UIUtils.createComposite(parent, 1);
        content.setLayoutData((Object)new GridData(1808));
        if (this.message != null) {
            gd = new GridData();
            gd.minimumWidth = 1;
            gd.minimumHeight = 1;
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = this.convertHorizontalDLUsToPixels(300);
            if (this.message.contains("</a>")) {
                Link messageLink = new Link(content, 64);
                messageLink.setText(this.message);
                messageLink.setLayoutData((Object)gd);
                messageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ShellUtils.launchProgram(e.text);
                    }
                });
            } else {
                Label messageLabel = new Label(content, 64);
                messageLabel.setText(this.message);
                messageLabel.setLayoutData((Object)gd);
            }
        }
        UIUtils.createEmptyLabel(content, 1, 1);
        if (this.customArea != null) {
            this.customArea.accept((Composite)content);
            UIUtils.createEmptyLabel(content, 1, 1);
        }
        Composite composite = UIUtils.createComposite(parent, 1);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        return composite;
    }

    @Override
    protected Control createButtonBar(@NotNull Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(0, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.labels == null) {
            return;
        }
        this.buttons = new ArrayList<Button>(this.labels.size());
        int i = 0;
        while (i < this.labels.size()) {
            this.buttons.add(this.createButton(parent, i, this.labels.get(i), this.defaultAnswerIdx == i));
            ++i;
        }
    }

    @Override
    @Nullable
    protected Button getButton(int index) {
        if (this.buttons != null && CommonUtils.isValidIndex((int)index, (int)this.buttons.size())) {
            return this.buttons.get(index);
        }
        return null;
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (defaultButton) {
            button.setFocus();
        }
        return button;
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.setReturnCode(-1);
    }
}

