/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.ProxyValueHandler;
import org.jkiss.dbeaver.model.impl.data.transformers.TransformerPresentationAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class RadixAttributeTransformer
implements DBDAttributeTransformer {
    private static final Log log = Log.getLog(RadixAttributeTransformer.class);
    public static final String PROP_RADIX = "radix";
    public static final String PROP_BITS = "bits";
    public static final String PROP_PREFIX = "prefix";
    public static final String PROP_UNSIGNED = "unsigned";
    public static final String PREFIX_HEX = "0x";
    public static final String PREFIX_OCT = "0";
    public static final String PREFIX_BIN = "0b";

    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        int radix = 16;
        int bits = 32;
        boolean showPrefix = false;
        boolean unsigned = false;
        if (options.containsKey(PROP_RADIX)) {
            radix = CommonUtils.toInt((Object)options.get(PROP_RADIX), (int)radix);
        }
        if (options.containsKey(PROP_BITS)) {
            bits = CommonUtils.toInt((Object)options.get(PROP_BITS), (int)bits);
        }
        if (options.containsKey(PROP_PREFIX)) {
            showPrefix = CommonUtils.getBoolean((Object)options.get(PROP_PREFIX), (boolean)showPrefix);
        }
        if (options.containsKey(PROP_UNSIGNED)) {
            unsigned = CommonUtils.getBoolean((Object)options.get(PROP_UNSIGNED), (boolean)unsigned);
        }
        attribute.setTransformHandler(new RadixValueHandler(attribute.getValueHandler(), radix, bits, showPrefix, unsigned));
        attribute.setPresentationAttribute(new TransformerPresentationAttribute(attribute, "StringNumber", -1, DBPDataKind.STRING));
    }

    private static class RadixValueHandler
    extends ProxyValueHandler {
        private final int radix;
        private final int bits;
        private final boolean showPrefix;
        private final boolean unsigned;

        public RadixValueHandler(DBDValueHandler target, int radix, int bits, boolean showPrefix, boolean unsigned) {
            super(target);
            this.radix = radix;
            this.bits = bits;
            this.showPrefix = showPrefix;
            this.unsigned = unsigned;
        }

        @Override
        @NotNull
        public String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
            if (value instanceof Number) {
                String strValue;
                long longValue = ((Number)value).longValue();
                StringBuilder sb = new StringBuilder();
                if (this.unsigned || longValue >= 0L) {
                    strValue = Long.toUnsignedString(longValue, this.radix).toUpperCase(Locale.ENGLISH);
                } else {
                    strValue = Long.toString(longValue, this.radix).substring(1).toUpperCase(Locale.ENGLISH);
                    sb.append("-");
                }
                if (this.showPrefix) {
                    if (this.radix == 16) {
                        sb.append(RadixAttributeTransformer.PREFIX_HEX);
                    } else if (this.radix == 8) {
                        sb.append(RadixAttributeTransformer.PREFIX_OCT);
                    } else if (this.radix == 2) {
                        sb.append(RadixAttributeTransformer.PREFIX_BIN);
                    }
                }
                if (this.radix == 2) {
                    sb.append(strValue, 0, CommonUtils.clamp((int)strValue.length(), (int)1, (int)this.bits));
                } else {
                    sb.append(strValue);
                }
                return sb.toString();
            }
            return DBValueFormatting.getDefaultValueDisplayString(value, format);
        }

        @Override
        @Nullable
        public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy, boolean validateValue) throws DBCException {
            if (object instanceof String) {
                String strValue = (String)object;
                String strValueSign = "";
                if (strValue.isEmpty()) {
                    return 0;
                }
                if (strValue.charAt(0) == '-') {
                    strValue = strValue.substring(1);
                    strValueSign = "-";
                }
                if (this.showPrefix) {
                    if (this.radix == 16 && strValue.startsWith(RadixAttributeTransformer.PREFIX_HEX)) {
                        strValue = strValue.substring(2);
                    } else if (this.radix == 8 && strValue.startsWith(RadixAttributeTransformer.PREFIX_OCT)) {
                        strValue = strValue.substring(1);
                    } else if (this.radix == 2 && strValue.startsWith(RadixAttributeTransformer.PREFIX_BIN)) {
                        strValue = strValue.substring(2);
                    }
                }
                try {
                    return Long.parseLong(String.valueOf(strValueSign) + strValue, this.radix);
                }
                catch (NumberFormatException e) {
                    log.debug(e);
                }
            }
            return super.getValueFromObject(session, type, object, copy, validateValue);
        }
    }
}

