/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public class SQLGroupingQueryGenerator {
    private static final Log log = Log.getLog(SQLGroupingQueryGenerator.class);
    public static final String FUNCTION_COUNT = "COUNT";
    public static final String DEFAULT_FUNCTION = "COUNT(*)";
    @NotNull
    private final DBPDataSource dataSource;
    @NotNull
    private final DBSDataContainer container;
    @NotNull
    private final SQLDialect dialect;
    @NotNull
    private final SQLSyntaxManager syntaxManager;
    @NotNull
    private final List<String> groupAttributes;
    @NotNull
    private final List<String> groupFunctions;
    private final boolean showDuplicatesOnly;
    private String[] funcAliases = new String[0];

    public SQLGroupingQueryGenerator(@NotNull DBPDataSource dataSource, @NotNull DBSDataContainer container, @NotNull SQLDialect dialect, @NotNull SQLSyntaxManager syntaxManager, @NotNull List<String> groupAttributes, @NotNull List<String> groupFunctions, boolean showDuplicatesOnly) {
        this.dataSource = dataSource;
        this.container = container;
        this.dialect = dialect;
        this.syntaxManager = syntaxManager;
        this.groupAttributes = groupAttributes;
        this.groupFunctions = groupFunctions;
        this.showDuplicatesOnly = showDuplicatesOnly;
    }

    public String generateGroupingQuery(String queryText) throws DBException {
        boolean isDefaultGrouping;
        if (queryText == null || queryText.isEmpty()) {
            if (this.container != null) {
                queryText = this.container.getName();
            } else {
                throw new DBException("Empty data container");
            }
        }
        String[] stringArray = this.syntaxManager.getStatementDelimiters();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String delimiter = stringArray[n2];
            while (queryText.endsWith(delimiter)) {
                queryText = queryText.substring(0, queryText.length() - delimiter.length());
            }
            ++n2;
        }
        boolean useAliasForColumns = this.dataSource.getSQLDialect().supportsAliasInConditions();
        StringBuilder sql = new StringBuilder();
        this.funcAliases = new String[this.groupFunctions.size()];
        int i = 0;
        while (i < this.groupFunctions.size()) {
            this.funcAliases[i] = useAliasForColumns ? this.makeGroupFunctionAlias(this.groupFunctions, i) : this.groupFunctions.get(i);
            ++i;
        }
        if (!(this.container instanceof DBSEntity) && this.dialect.supportsSubqueries()) {
            sql.append("SELECT ");
            i = 0;
            while (i < this.groupAttributes.size()) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(this.quotedGroupingString(this.dataSource, this.groupAttributes.get(i)));
                ++i;
            }
            i = 0;
            while (i < this.groupFunctions.size()) {
                String func = this.groupFunctions.get(i);
                sql.append(", ").append(func);
                if (useAliasForColumns) {
                    sql.append(" as ").append(this.funcAliases[i]);
                }
                ++i;
            }
            sql.append(" FROM (\n");
            sql.append(queryText);
            sql.append("\n) src");
        } else {
            try {
                Statement statement = SQLSemanticProcessor.parseQuery((SQLDialect)this.dataSource.getSQLDialect(), (String)queryText);
                if (statement instanceof Select && ((Select)statement).getSelectBody() instanceof PlainSelect) {
                    PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
                    select.setOrderByElements(null);
                    ArrayList<SelectExpressionItem> selectItems = new ArrayList<SelectExpressionItem>();
                    select.setSelectItems(selectItems);
                    for (String groupAttribute : this.groupAttributes) {
                        selectItems.add(new SelectExpressionItem((Expression)new Column(this.quotedGroupingString(this.dataSource, groupAttribute))));
                    }
                    int i2 = 0;
                    while (i2 < this.groupFunctions.size()) {
                        String func = this.groupFunctions.get(i2);
                        Expression expression = SQLSemanticProcessor.parseExpression((String)func);
                        SelectExpressionItem sei = new SelectExpressionItem(expression);
                        if (useAliasForColumns) {
                            sei.setAlias(new Alias(this.funcAliases[i2]));
                        }
                        selectItems.add(sei);
                        ++i2;
                    }
                }
                queryText = statement.toString();
            }
            catch (Throwable e) {
                log.debug((Object)"SQL parse error", e);
            }
            sql.append(queryText);
        }
        sql.append("\nGROUP BY ");
        i = 0;
        while (i < this.groupAttributes.size()) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(this.quotedGroupingString(this.dataSource, this.groupAttributes.get(i)));
            ++i;
        }
        boolean bl = isDefaultGrouping = this.groupFunctions.size() == 1 && this.groupFunctions.get(0).equalsIgnoreCase(DEFAULT_FUNCTION);
        if (isDefaultGrouping && this.showDuplicatesOnly) {
            sql.append("\nHAVING ");
            if (this.dataSource.getSQLDialect().supportsAliasInHaving()) {
                sql.append(this.funcAliases[0]);
            } else {
                sql.append(DEFAULT_FUNCTION);
            }
            sql.append(" > 1");
        }
        return sql.toString();
    }

    private String makeGroupFunctionAlias(List<String> groupFunctions, int funcIndex) {
        String function = groupFunctions.get(funcIndex);
        StringBuilder alias = new StringBuilder();
        int i = 0;
        while (i < function.length()) {
            char c = function.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                alias.append(c);
            }
            ++i;
        }
        if (alias.length() > 0) {
            alias.append('_');
            return alias.toString().toLowerCase(Locale.ENGLISH);
        }
        return "i_" + funcIndex;
    }

    private String quotedGroupingString(DBPDataSource dataSource, String string) {
        try {
            Expression expression = SQLSemanticProcessor.parseExpression((String)string);
            if (!(expression instanceof Column)) {
                return string;
            }
        }
        catch (DBException e) {
            log.debug((Object)("Can't parse expression " + string), (Throwable)e);
        }
        return DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)string);
    }

    public String[] getFuncAliases() {
        return this.funcAliases;
    }
}

