/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.app.DBPWorkspaceDesktop;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNStreamData;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;

public class DBNPath
extends DBNPathBase
implements DBNStreamData {
    private static final Log log = Log.getLog(DBNPath.class);
    private Path path;
    private Boolean isDirectory;

    public DBNPath(DBNNode parentNode, Path path) {
        super(parentNode);
        this.path = path;
        DBPWorkspace workspace = this.getOwnerProject().getWorkspace();
        if (workspace instanceof DBPWorkspaceDesktop) {
            ((DBPWorkspaceDesktop)workspace).getDefaultResourceHandler().updateNavigatorNodeFromResource(this, this.getResource());
        }
    }

    @Override
    public boolean isDisposed() {
        return this.path == null || super.isDisposed();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    protected void dispose(boolean reflect) {
        this.path = null;
        super.dispose(reflect);
    }

    @Override
    public String getNodeType() {
        return String.valueOf(DBNNode.NodePathType.dbvfs.name()) + (this.allowsChildren() ? ".folder" : ".file");
    }

    @Override
    public String getNodeDescription() {
        return null;
    }

    @Override
    public String getNodeTargetName() {
        return super.getNodeTargetName();
    }

    @Override
    public boolean allowsChildren() {
        if (this.isDirectory == null) {
            this.isDirectory = Files.isDirectory(this.path, new LinkOption[0]);
        }
        return this.isDirectory;
    }

    @Override
    public boolean supportsStreamData() {
        return !this.allowsChildren();
    }

    @Override
    public long getStreamSize() throws IOException {
        return Files.size(this.path);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this.allowsChildren()) {
            return null;
        }
        return Files.newInputStream(this.path, new OpenOption[0]);
    }
}

