/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.ProxyValueHandler;
import org.jkiss.dbeaver.model.impl.data.transformers.TransformerPresentationAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class EpochTimeAttributeTransformer
implements DBDAttributeTransformer {
    private static final Log log = Log.getLog(EpochTimeAttributeTransformer.class);
    static final String PROP_UNIT = "unit";
    static final String ZONE_ID = "zoneId";
    private static final int GIGA = 1000000000;
    private static final int TEN_MEGA = 10000000;
    private static final int MEGA = 1000000;
    private static final int TICKS_TO_NANOS = 100;
    private static final int NANOS_TO_MICROS = 1000;
    private static final long DOTNET_TICKS_OFFSET = 621355968000000000L;
    private static final long W32_FILETIME_OFFSET = 116444736000000000L;
    private static final double OADATE_OFFSET = 25569.0;
    private static final double SQLITE_JULIAN_OFFSET = 2440587.5;
    private static final int SECONDS_IN_DAY = 86400;
    private static final DateTimeFormatter SECONDS_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    private static final DateTimeFormatter MILLIS_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
    private static final DateTimeFormatter MICROS_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.nnnnnn", Locale.ENGLISH);
    private static final DateTimeFormatter NANOS_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.nnnnnnnnn", Locale.ENGLISH);
    private static final DateTimeFormatter SQLITE_JULIAN_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.nnnnn", Locale.ENGLISH);
    private static final DateTimeFormatter DOTNET_TICKS_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.nnnnnnn", Locale.ENGLISH);

    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        attribute.setPresentationAttribute(new TransformerPresentationAttribute(attribute, "EpochTime", -1, DBPDataKind.DATETIME));
        EpochUnit unit = EpochUnit.milliseconds;
        try {
            unit = EpochUnit.valueOf(CommonUtils.toString((Object)options.get(PROP_UNIT)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Bad unit type");
        }
        attribute.setTransformHandler(new EpochValueHandler(attribute.getValueHandler(), unit, CommonUtils.toString((Object)options.get(ZONE_ID))));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum EpochUnit {
        seconds{

            @Override
            Instant toInstant(Number value) {
                long longValue = value.longValue();
                return Instant.ofEpochSecond(longValue);
            }

            @Override
            DateTimeFormatter getFormatter() {
                return SECONDS_FORMATTER;
            }

            @Override
            Long toRawValue(Instant instant) {
                return instant.getEpochSecond();
            }
        }
        ,
        milliseconds{

            @Override
            Instant toInstant(Number value) {
                long longValue = value.longValue();
                return Instant.ofEpochMilli(longValue);
            }

            @Override
            DateTimeFormatter getFormatter() {
                return MILLIS_FORMATTER;
            }

            @Override
            Long toRawValue(Instant instant) {
                return instant.toEpochMilli();
            }
        }
        ,
        microseconds{

            @Override
            Instant toInstant(Number value) {
                long longValue = value.longValue();
                return Instant.ofEpochSecond(longValue / 1000000L, longValue % 1000000L);
            }

            @Override
            DateTimeFormatter getFormatter() {
                return MICROS_FORMATTER;
            }

            @Override
            Long toRawValue(Instant instant) {
                return instant.getEpochSecond() * 1000000L + (long)(instant.getNano() / 1000);
            }
        }
        ,
        nanoseconds{

            @Override
            Instant toInstant(Number value) {
                long longValue = value.longValue();
                return Instant.ofEpochSecond(longValue / 1000000000L, longValue % 1000000000L);
            }

            @Override
            DateTimeFormatter getFormatter() {
                return NANOS_FORMATTER;
            }

            @Override
            Long toRawValue(Instant instant) {
                return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
            }
        }
        ,
        dotnet{

            @Override
            Instant toInstant(Number value) {
                return EpochUnit.ticksToInstant(value.longValue(), 621355968000000000L);
            }

            @Override
            DateTimeFormatter getFormatter() {
                return DOTNET_TICKS_FORMATTER;
            }

            @Override
            Long toRawValue(Instant instant) {
                return EpochUnit.instantToTicks(instant, 621355968000000000L);
            }
        }
        ,
        w32filetime{

            @Override
            Instant toInstant(Number value) {
                return EpochUnit.ticksToInstant(value.longValue(), 116444736000000000L);
            }

            @Override
            DateTimeFormatter getFormatter() {
                return DOTNET_TICKS_FORMATTER;
            }

            @Override
            Long toRawValue(Instant instant) {
                return EpochUnit.instantToTicks(instant, 116444736000000000L);
            }
        }
        ,
        oadate{

            @Override
            Instant toInstant(Number value) {
                return EpochUnit.daysToInstant(value.doubleValue(), 25569.0);
            }

            @Override
            DateTimeFormatter getFormatter() {
                return NANOS_FORMATTER;
            }

            @Override
            Double toRawValue(Instant instant) {
                return EpochUnit.instantToDays(instant, 25569.0);
            }
        }
        ,
        sqliteJulian{

            @Override
            Instant toInstant(Number value) {
                return EpochUnit.daysToInstant(value.doubleValue(), 2440587.5);
            }

            @Override
            DateTimeFormatter getFormatter() {
                return SQLITE_JULIAN_FORMATTER;
            }

            @Override
            Double toRawValue(Instant instant) {
                return EpochUnit.instantToDays(instant, 2440587.5);
            }
        };


        private static Instant ticksToInstant(long rawValue, long offset) {
            long sinceUnixEpoch = rawValue - offset;
            return Instant.ofEpochSecond(sinceUnixEpoch / 10000000L, sinceUnixEpoch % 10000000L * 100L);
        }

        private static long instantToTicks(Instant instant, long offset) {
            return instant.getEpochSecond() * 10000000L + (long)(instant.getNano() / 100) + offset;
        }

        private static Instant daysToInstant(double rawValue, double offset) {
            double daysSinceUnixEpoch = rawValue - offset;
            long wholeDaysSinceUnixEpoch = (long)daysSinceUnixEpoch;
            double fractionalDay = daysSinceUnixEpoch - (double)wholeDaysSinceUnixEpoch;
            long fractionalDayNanos = (long)(fractionalDay * 86400.0 * 1.0E9);
            return Instant.ofEpochSecond(wholeDaysSinceUnixEpoch * 86400L, fractionalDayNanos);
        }

        private static double instantToDays(Instant instant, double offset) {
            double daysSinceUnixEpoch = ((double)instant.getEpochSecond() + 1.0E-9 * (double)instant.getNano()) / 86400.0;
            return daysSinceUnixEpoch + offset;
        }

        abstract Instant toInstant(Number var1);

        abstract DateTimeFormatter getFormatter();

        abstract Number toRawValue(Instant var1);
    }

    private static class EpochValueHandler
    extends ProxyValueHandler {
        private final EpochUnit unit;
        private final String zoneName;
        @Nullable
        private ZoneId zoneId;

        EpochValueHandler(DBDValueHandler target, EpochUnit unit, String zoneName) {
            super(target);
            this.unit = unit;
            this.zoneName = zoneName;
        }

        private ZoneId getZoneId() {
            if (this.zoneId != null) {
                return this.zoneId;
            }
            if (this.zoneName.isEmpty()) {
                return ZoneId.systemDefault();
            }
            this.zoneId = ZoneId.of(this.zoneName);
            return this.zoneId;
        }

        @Override
        @NotNull
        public String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
            if (!(value instanceof Number)) {
                return DBValueFormatting.getDefaultValueDisplayString(value, format);
            }
            Instant instant = this.unit.toInstant((Number)value);
            ZonedDateTime dateTime = ZonedDateTime.ofInstant(instant, this.getZoneId());
            return this.unit.getFormatter().format(dateTime);
        }

        @Override
        @Nullable
        public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy, boolean validateValue) throws DBCException {
            ZonedDateTime dateTime;
            if (!(object instanceof String)) {
                return super.getValueFromObject(session, type, object, copy, validateValue);
            }
            try {
                dateTime = ZonedDateTime.of(LocalDateTime.parse((String)object, this.unit.getFormatter()), this.getZoneId());
            }
            catch (DateTimeException dateTimeException) {
                return new DBCException("Incorrect zoneId");
            }
            return this.unit.toRawValue(Instant.from(dateTime));
        }
    }
}

