/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFFileSystemDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DBFUtils {
    private static final Log log = Log.getLog(DBFUtils.class);
    private static volatile Boolean SUPPORT_MULTI_FS = null;
    private static Map<FileSystem, String> fileSystemIdCache = new IdentityHashMap<FileSystem, String>();

    public static boolean supportsMultiFileSystems(@NotNull DBPProject project) {
        if (SUPPORT_MULTI_FS == null) {
            DBFFileSystemDescriptor[] dBFFileSystemDescriptorArray = DBWorkbench.getPlatform().getFileSystemRegistry().getFileSystemProviders();
            int n = dBFFileSystemDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBFFileSystemDescriptor fsProvider = dBFFileSystemDescriptorArray[n2];
                Object[] fsList = fsProvider.getInstance().getAvailableFileSystems(new VoidProgressMonitor(), project);
                if (!ArrayUtils.isEmpty((Object[])fsList)) {
                    SUPPORT_MULTI_FS = true;
                    break;
                }
                ++n2;
            }
            if (SUPPORT_MULTI_FS == null) {
                SUPPORT_MULTI_FS = false;
            }
        }
        return SUPPORT_MULTI_FS;
    }

    @NotNull
    public static Path resolvePathFromString(@NotNull DBRProgressMonitor monitor, @Nullable DBPProject project, @NotNull String pathOrUri) throws DBException {
        if (project != null) {
            return project.getFileSystemManager().getPathFromString(monitor, pathOrUri);
        }
        return Path.of(pathOrUri, new String[0]);
    }

    @NotNull
    public static Path resolvePathFromURI(@NotNull DBRProgressMonitor monitor, @Nullable DBPProject project, @NotNull URI uri) throws DBException {
        if (project != null) {
            return project.getFileSystemManager().getPathFromURI(monitor, uri);
        }
        return Path.of(uri);
    }

    @NotNull
    public static Path resolvePathFromString(@NotNull DBRRunnableContext runnableContext, @Nullable DBPProject project, @NotNull String pathOrUri) throws DBException {
        if (!IOUtils.isLocalFile((String)pathOrUri) && project != null && DBFUtils.supportsMultiFileSystems(project)) {
            try {
                Path[] result = new Path[1];
                runnableContext.run(true, true, monitor -> {
                    try {
                        pathArray[0] = project.getFileSystemManager().getPathFromString(monitor, pathOrUri);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                return result[0];
            }
            catch (InvocationTargetException e) {
                throw new DBException("Error getting path", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                throw new DBException("Canceled");
            }
        }
        if (pathOrUri.startsWith("file:")) {
            try {
                return Path.of(new URI(pathOrUri));
            }
            catch (URISyntaxException e) {
                log.debug(e);
            }
        }
        return Path.of(pathOrUri, new String[0]);
    }

    public static URI getUriFromPath(Path path) {
        URI uri = path.toUri();
        String fileSystemId = DBFUtils.getFileSystemId(path.getFileSystem());
        if (!CommonUtils.isEmpty((String)fileSystemId)) {
            try {
                uri = !CommonUtils.isEmpty((String)uri.getAuthority()) ? new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "file-system-id=" + fileSystemId, null) : new URI(uri.getScheme(), uri.getHost(), uri.getPath(), "file-system-id=" + fileSystemId);
            }
            catch (URISyntaxException e) {
                log.debug("Error generating FS URI", e);
            }
        }
        return uri;
    }

    public static Map<String, String> getQueryParameters(String query) {
        String[] pairs;
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String[] stringArray = pairs = query.split("&");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            int idx = pair.indexOf("=");
            String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8) : pair;
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8) : null;
            result.put(key, value);
            ++n2;
        }
        return result;
    }

    public static String getFileSystemId(FileSystem fs) {
        return fileSystemIdCache.get(fs);
    }

    public static void mapFileSystem(FileSystem fs, String id) {
        if (id == null) {
            fileSystemIdCache.remove(fs);
        } else {
            fileSystemIdCache.put(fs, id);
        }
    }
}

