/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNObjectNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNStreamData;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.IDataSourceContainerUpdate;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dnd.DatabaseObjectTransfer;
import org.jkiss.dbeaver.ui.dnd.TreeNodeTransfer;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContextBase;
import org.jkiss.dbeaver.ui.editors.DatabaseNodeEditorInput;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.INavigatorObjectManager;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerRefresh;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorContent;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorView;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.dbeaver.ui.navigator.project.ProjectNavigatorView;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorUtils {
    private static final Log log = Log.getLog(NavigatorUtils.class);

    public static DBNNode getSelectedNode(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            return null;
        }
        return NavigatorUtils.getSelectedNode(selectionProvider.getSelection());
    }

    public static DBNNode getSelectedNode(ISelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof DBNNode) {
                return (DBNNode)selectedObject;
            }
            if (selectedObject != null) {
                return (DBNNode)RuntimeUtils.getObjectAdapter((Object)selectedObject, DBNNode.class);
            }
        }
        return null;
    }

    @NotNull
    public static List<DBNNode> getSelectedNodes(@NotNull ISelection selection) {
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DBNNode> nodes = new ArrayList<DBNNode>();
        if (selection instanceof IStructuredSelection) {
            for (Object selectedObject : (IStructuredSelection)selection) {
                if (selectedObject instanceof DBNNode) {
                    nodes.add((DBNNode)selectedObject);
                    continue;
                }
                DBNNode node = (DBNNode)RuntimeUtils.getObjectAdapter(selectedObject, DBNNode.class);
                if (node == null) continue;
                nodes.add(node);
            }
        }
        return Collections.unmodifiableList(nodes);
    }

    public static DBNNode getSelectedNode(UIElement element) {
        ISelectionProvider selectionProvider = UIUtils.getSelectionProvider((IServiceLocator)element.getServiceLocator());
        if (selectionProvider != null) {
            return NavigatorUtils.getSelectedNode(selectionProvider);
        }
        return null;
    }

    public static DBSObject getSelectedObject(ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        return DBUtils.getFromObject((Object)((IStructuredSelection)selection).getFirstElement());
    }

    public static List<DBSObject> getSelectedObjects(ISelection selection) {
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DBSObject> result = new ArrayList<DBSObject>();
        if (selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                DBSObject selectedObject = DBUtils.getFromObject(iter.next());
                if (selectedObject == null) continue;
                result.add(selectedObject);
            }
        }
        return result;
    }

    public static void addContextMenu(IWorkbenchSite workbenchSite, Viewer viewer) {
        NavigatorUtils.addContextMenu(workbenchSite, viewer, (ISelectionProvider)viewer);
    }

    public static void addContextMenu(@Nullable IWorkbenchSite workbenchSite, @NotNull Viewer viewer, @NotNull ISelectionProvider selectionProvider) {
        MenuManager menuMgr = NavigatorUtils.createContextMenu(workbenchSite, viewer, selectionProvider, null);
        if (workbenchSite instanceof IWorkbenchPartSite) {
            ((IWorkbenchPartSite)workbenchSite).registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        } else if (workbenchSite instanceof IPageSite) {
            ((IPageSite)workbenchSite).registerContextMenu("navigatorMenu", menuMgr, (ISelectionProvider)viewer);
        }
    }

    public static MenuManager createContextMenu(@Nullable IWorkbenchSite workbenchSite, @NotNull Viewer viewer, @NotNull IMenuListener menuListener) {
        return NavigatorUtils.createContextMenu(workbenchSite, viewer, (ISelectionProvider)viewer, menuListener);
    }

    public static MenuManager createContextMenu(@Nullable IWorkbenchSite workbenchSite, final @NotNull Viewer viewer, @NotNull ISelectionProvider selectionProvider, @Nullable IMenuListener menuListener) {
        Control control = viewer.getControl();
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(control);
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                DBNNode node = NavigatorUtils.getSelectedNode(viewer.getSelection());
                if (node != null && !node.isLocked() && node.allowsOpen()) {
                    String commandID = NavigatorUtils.getNodeActionCommand(DBXTreeNodeHandler.Action.open, node, "org.jkiss.dbeaver.core.object.open");
                    try {
                        MenuItem[] menuItemArray = m.getItems();
                        int n = menuItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String contribId;
                            MenuItem item = menuItemArray[n2];
                            Object itemData = item.getData();
                            if (itemData instanceof IContributionItem && (contribId = ((IContributionItem)itemData).getId()) != null && contribId.equals(commandID)) {
                                m.setDefaultItem(item);
                            }
                            ++n2;
                        }
                    }
                    catch (Exception ex) {
                        log.debug((Object)ex);
                    }
                }
            }
        });
        menuMgr.addMenuListener(manager -> {
            ViewerColumnController columnController = ViewerColumnController.getFromControl(control);
            if (columnController != null && columnController.isClickOnHeader()) {
                columnController.fillConfigMenu((IContributionManager)manager);
                manager.add((IContributionItem)new Separator());
                return;
            }
            manager.add((IContributionItem)new Separator());
            NavigatorUtils.addStandardMenuItem(workbenchSite, manager, selectionProvider);
            if (menuListener != null) {
                menuListener.menuAboutToShow(manager);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menu);
        return menuMgr;
    }

    public static void addStandardMenuItem(@Nullable IWorkbenchSite workbenchSite, @NotNull IMenuManager manager, @NotNull ISelectionProvider selectionProvider) {
        ISelection selection = selectionProvider.getSelection();
        DBNNode selectedNode = NavigatorUtils.getSelectedNode(selectionProvider);
        if (selectedNode != null && !selectedNode.isLocked() && workbenchSite != null) {
            NavigatorUtils.addSetDefaultObjectAction(workbenchSite, manager, selectedNode);
        }
        manager.add((IContributionItem)new GroupMarker("navigator_additions"));
        manager.add((IContributionItem)new GroupMarker("tools"));
        manager.add((IContributionItem)new GroupMarker("tools_end"));
        manager.add((IContributionItem)new GroupMarker("navigator_additions_end"));
        manager.add((IContributionItem)new GroupMarker("additions_end"));
        if (selectedNode != null && !selectedNode.isLocked() && workbenchSite != null) {
            Object firstElement;
            manager.add((IContributionItem)new Separator());
            if (selection instanceof IStructuredSelection && PreferencesUtil.hasPropertiesContributors((Object)(firstElement = ((IStructuredSelection)selection).getFirstElement())) && firstElement instanceof DBNResource) {
                manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.eclipse.ui.file.properties"));
            }
            if (selectedNode.isPersisted()) {
                manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.eclipse.ui.file.refresh"));
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private static void addSetDefaultObjectAction(IWorkbenchSite workbenchSite, IMenuManager manager, DBNNode selectedNode) {
        boolean addSetActive = false;
        if (selectedNode.isPersisted() && selectedNode instanceof DBNDatabaseNode && !(selectedNode instanceof DBNDatabaseFolder) && ((DBNDatabaseNode)selectedNode).getObject() != null) {
            DBCExecutionContext defaultContext;
            DBCExecutionContextDefaults contextDefaults;
            DBSObject selectedObject = ((DBNDatabaseNode)selectedNode).getObject();
            DBPDataSource dataSource = ((DBNDatabaseNode)selectedNode).getDataSource();
            if (dataSource != null && (contextDefaults = (defaultContext = dataSource.getDefaultInstance().getDefaultContext((DBRProgressMonitor)new VoidProgressMonitor(), false)).getContextDefaults()) != null && (selectedObject instanceof DBSCatalog && contextDefaults.supportsCatalogChange() && contextDefaults.getDefaultCatalog() != selectedObject || selectedObject instanceof DBSSchema && contextDefaults.supportsSchemaChange() && contextDefaults.getDefaultSchema() != selectedObject)) {
                addSetActive = true;
            }
        }
        if (addSetActive) {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.jkiss.dbeaver.core.navigator.set.default"));
        }
        manager.add((IContributionItem)new Separator());
    }

    public static void executeNodeAction(DBXTreeNodeHandler.Action action, Object node, IServiceLocator serviceLocator) {
        NavigatorUtils.executeNodeAction(action, node, null, serviceLocator);
    }

    public static void executeNodeAction(DBXTreeNodeHandler.Action action, Object node, Map<String, Object> parameters, IServiceLocator serviceLocator) {
        String actionCommand;
        String defCommandId = null;
        if (action == DBXTreeNodeHandler.Action.open) {
            defCommandId = "org.jkiss.dbeaver.core.object.open";
        }
        if ((actionCommand = NavigatorUtils.getNodeActionCommand(action, node, defCommandId)) != null) {
            ActionUtils.runCommand((String)actionCommand, (ISelection)new StructuredSelection(node), parameters, (IServiceLocator)serviceLocator);
        }
    }

    public static String getNodeActionCommand(DBXTreeNodeHandler.Action action, Object node, String defCommand) {
        DBXTreeNodeHandler handler;
        if (node instanceof DBNDatabaseNode && (handler = ((DBNDatabaseNode)node).getMeta().getHandler(action)) != null && handler.getPerform() == DBXTreeNodeHandler.Perform.command && !CommonUtils.isEmpty((String)handler.getCommand())) {
            return handler.getCommand();
        }
        return defCommand;
    }

    public static void addDragAndDropSupport(Viewer viewer) {
        NavigatorUtils.addDragAndDropSupport(viewer, true, true);
    }

    public static void addDragAndDropSupport(final Viewer viewer, boolean enableDrag, boolean enableDrop) {
        if (enableDrag) {
            Object[] dragTransferTypes = new Transfer[]{TextTransfer.getInstance(), TreeNodeTransfer.getInstance(), DatabaseObjectTransfer.getInstance(), EditorInputTransfer.getInstance(), FileTransfer.getInstance()};
            if (RuntimeUtils.isGtk()) {
                ArrayUtils.reverse((Object[])dragTransferTypes);
            }
            int operations = 7;
            DragSource source = new DragSource(viewer.getControl(), operations);
            source.setTransfer((Transfer[])dragTransferTypes);
            source.addDragListener(new DragSourceListener(){
                private IStructuredSelection selection;

                public void dragStart(DragSourceEvent event) {
                    this.selection = (IStructuredSelection)viewer.getSelection();
                }

                public void dragSetData(DragSourceEvent event) {
                    if (!this.selection.isEmpty()) {
                        LinkedHashMap<DBNNode, TransferInfo> info = new LinkedHashMap<DBNNode, TransferInfo>();
                        for (Object nextSelected : this.selection) {
                            String nodeName;
                            DBSObject nodeObject;
                            DBNNode node;
                            block31: {
                                if (!(nextSelected instanceof DBNNode)) continue;
                                node = (DBNNode)nextSelected;
                                nodeObject = null;
                                if (nextSelected instanceof DBNDatabaseNode && !(nextSelected instanceof DBNDataSource)) {
                                    object = ((DBNDatabaseNode)nextSelected).getObject();
                                    if (object == null) continue;
                                    nodeName = DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI);
                                    nodeObject = object;
                                } else if (nextSelected instanceof DBNDataSource) {
                                    object = ((DBNDataSource)nextSelected).getDataSourceContainer();
                                    nodeName = object.getName();
                                    nodeObject = object;
                                } else {
                                    if (nextSelected instanceof DBNStreamData && ((DBNStreamData)nextSelected).supportsStreamData() && (EditorInputTransfer.getInstance().isSupportedType(event.dataType) || FileTransfer.getInstance().isSupportedType(event.dataType))) {
                                        String fileName = node.getNodeName();
                                        try {
                                            java.nio.file.Path tmpFile = DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), "dnd-files").resolve(CommonUtils.escapeFileName((String)fileName));
                                            if (!Files.exists(tmpFile, new LinkOption[0])) {
                                                try {
                                                    Files.createFile(tmpFile, new FileAttribute[0]);
                                                }
                                                catch (IOException e) {
                                                    log.error((Object)("Can't create new file" + tmpFile.toAbsolutePath()), (Throwable)e);
                                                    continue;
                                                }
                                                UIUtils.runInProgressService(monitor -> {
                                                    try {
                                                        long streamSize = ((DBNStreamData)nextSelected).getStreamSize();
                                                        Throwable throwable = null;
                                                        Object var6_7 = null;
                                                        try (InputStream is = ((DBNStreamData)nextSelected).openInputStream();){
                                                            Throwable throwable2 = null;
                                                            Object var9_12 = null;
                                                            try (OutputStream out = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                                                                ContentUtils.copyStreams((InputStream)is, (long)streamSize, (OutputStream)out, (DBRProgressMonitor)monitor);
                                                            }
                                                            catch (Throwable throwable3) {
                                                                if (throwable2 == null) {
                                                                    throwable2 = throwable3;
                                                                } else if (throwable2 != throwable3) {
                                                                    throwable2.addSuppressed(throwable3);
                                                                }
                                                                throw throwable2;
                                                            }
                                                        }
                                                        catch (Throwable throwable4) {
                                                            if (throwable == null) {
                                                                throwable = throwable4;
                                                            } else if (throwable != throwable4) {
                                                                throwable.addSuppressed(throwable4);
                                                            }
                                                            throw throwable;
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        try {
                                                            Files.delete(tmpFile);
                                                        }
                                                        catch (IOException iOException) {
                                                            log.error((Object)("Error deleting temp file " + tmpFile.toAbsolutePath()), (Throwable)e);
                                                        }
                                                        throw new InvocationTargetException(e);
                                                    }
                                                });
                                            }
                                            nodeName = tmpFile.toAbsolutePath().toString();
                                            break block31;
                                        }
                                        catch (Exception e) {
                                            log.error((Object)e.getMessage());
                                            continue;
                                        }
                                    }
                                    nodeName = node.getNodeTargetName();
                                }
                            }
                            info.put(node, new TransferInfo(nodeName, node, (DBPNamedObject)nodeObject));
                        }
                        if (TreeNodeTransfer.getInstance().isSupportedType(event.dataType)) {
                            event.data = info.keySet();
                        } else if (DatabaseObjectTransfer.getInstance().isSupportedType(event.dataType)) {
                            event.data = info.values().stream().map(TransferInfo::getObject).filter(Objects::nonNull).collect(Collectors.toList());
                        } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                            event.data = info.values().stream().map(TransferInfo::getName).collect(Collectors.joining(CommonUtils.getLineSeparator()));
                        } else if (EditorInputTransfer.getInstance().isSupportedType(event.dataType)) {
                            event.data = info.values().stream().map(TransferInfo::createEditorInputData).filter(Objects::nonNull).toArray(EditorInputTransfer.EditorInputData[]::new);
                        } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                            event.data = info.values().stream().map(TransferInfo::getName).filter(name -> Files.exists(java.nio.file.Path.of(name, new String[0]), new LinkOption[0])).toArray(String[]::new);
                        }
                    } else if (TreeNodeTransfer.getInstance().isSupportedType(event.dataType)) {
                        event.data = Collections.emptyList();
                    } else if (DatabaseObjectTransfer.getInstance().isSupportedType(event.dataType)) {
                        event.data = Collections.emptyList();
                    } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                        event.data = "";
                    } else if (EditorInputTransfer.getInstance().isSupportedType(event.dataType)) {
                        event.data = new EditorInputTransfer.EditorInputData[0];
                    } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                        event.data = new String[0];
                    }
                }

                public void dragFinished(DragSourceEvent event) {
                }
            });
        }
        if (enableDrop) {
            DropTarget dropTarget = new DropTarget(viewer.getControl(), 2);
            dropTarget.setTransfer(new Transfer[]{TreeNodeTransfer.getInstance(), FileTransfer.getInstance()});
            dropTarget.addDropListener(new DropTargetListener(){

                public void dragEnter(DropTargetEvent event) {
                    this.handleDragEvent(event);
                }

                public void dragLeave(DropTargetEvent event) {
                    this.handleDragEvent(event);
                }

                public void dragOperationChanged(DropTargetEvent event) {
                    this.handleDragEvent(event);
                }

                public void dragOver(DropTargetEvent event) {
                    this.handleDragEvent(event);
                }

                public void drop(DropTargetEvent event) {
                    this.handleDragEvent(event);
                    if (event.detail == 2) {
                        this.moveNodes(event);
                    }
                }

                public void dropAccept(DropTargetEvent event) {
                    this.handleDragEvent(event);
                }

                private void handleDragEvent(DropTargetEvent event) {
                    event.detail = this.isDropSupported(event) ? 2 : 0;
                    event.feedback = 1;
                }

                private boolean isDropSupported(DropTargetEvent event) {
                    Object curObject = NavigatorUtils.getDropTarget(event, viewer);
                    if (TreeNodeTransfer.getInstance().isSupportedType(event.currentDataType)) {
                        Collection nodesToDrop = (Collection)event.data;
                        if (curObject instanceof DBNNode) {
                            if (!CommonUtils.isEmpty((Collection)nodesToDrop)) {
                                for (DBNNode node : nodesToDrop) {
                                    if (((DBNNode)curObject).supportsDrop(node)) continue;
                                    return false;
                                }
                                return true;
                            }
                            return ((DBNNode)curObject).supportsDrop(null);
                        }
                        if (curObject == null) {
                            if (!CommonUtils.isEmpty((Collection)nodesToDrop)) {
                                for (DBNNode node : nodesToDrop) {
                                    if (node instanceof DBNDataSource) continue;
                                    return false;
                                }
                                return true;
                            }
                            Widget widget = event.widget;
                            if (widget instanceof DropTarget) {
                                widget = ((DropTarget)widget).getControl();
                            }
                            return widget == viewer.getControl();
                        }
                    }
                    if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && curObject instanceof IAdaptable) {
                        IResource curResource = (IResource)((IAdaptable)curObject).getAdapter(IResource.class);
                        return curResource != null;
                    }
                    return false;
                }

                private void moveNodes(final DropTargetEvent event) {
                    IResource curResource;
                    Object curObject = NavigatorUtils.getDropTarget(event, viewer);
                    if (TreeNodeTransfer.getInstance().isSupportedType(event.currentDataType)) {
                        if (curObject instanceof DBNNode) {
                            Collection nodesToDrop = (Collection)TreeNodeTransfer.getInstance().getObject();
                            try {
                                UIUtils.runInProgressService(monitor -> {
                                    try {
                                        ((DBNNode)curObject).dropNodes(monitor, nodesToDrop);
                                    }
                                    catch (Exception e) {
                                        throw new InvocationTargetException(e);
                                    }
                                });
                            }
                            catch (Exception e) {
                                DBWorkbench.getPlatformUI().showError("Drop error", "Can't drop node", (Throwable)e);
                                return;
                            }
                        } else if (curObject == null) {
                            for (DBNNode node : (Collection)TreeNodeTransfer.getInstance().getObject()) {
                                if (node instanceof DBNDataSource) {
                                    DBNNode rootNode;
                                    if (viewer.getInput() instanceof DatabaseNavigatorContent && (rootNode = ((DatabaseNavigatorContent)viewer.getInput()).getRootNode()) != null && rootNode.getOwnerProject() != null) {
                                        ((DBNDataSource)node).moveToFolder(rootNode.getOwnerProject(), null);
                                    }
                                } else {
                                    if (!(node instanceof DBNLocalFolder)) continue;
                                    ((DBNLocalFolder)node).getFolder().setParent(null);
                                }
                                DBNModel.updateConfigAndRefreshDatabases((DBNNode)node);
                            }
                        }
                    }
                    if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && curObject instanceof IAdaptable && (curResource = (IResource)((IAdaptable)curObject).getAdapter(IResource.class)) != null) {
                        if (curResource instanceof IFile) {
                            curResource = curResource.getParent();
                        }
                        if (curResource instanceof IContainer) {
                            final IContainer toFolder = (IContainer)curResource;
                            new AbstractJob("Copy files to workspace"){
                                {
                                    super($anonymous0);
                                    this.setUser(true);
                                }

                                protected IStatus run(DBRProgressMonitor monitor) {
                                    String[] fileNames = (String[])event.data;
                                    monitor.beginTask("Copy files", fileNames.length);
                                    try {
                                        try {
                                            NavigatorUtils.dropFilesIntoFolder(monitor, toFolder, fileNames);
                                        }
                                        catch (Exception e) {
                                            IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                                            monitor.done();
                                            return iStatus;
                                        }
                                    }
                                    finally {
                                        monitor.done();
                                    }
                                    return Status.OK_STATUS;
                                }
                            }.schedule();
                        } else {
                            DBWorkbench.getPlatformUI().showError("Drop error", "Can't drop file into '" + curResource.getName() + "'. Files can be dropped only into folders.");
                        }
                    }
                }
            });
        }
    }

    @Nullable
    private static Object getDropTarget(@NotNull DropTargetEvent event, @NotNull Viewer viewer) {
        if (event.item instanceof Item) {
            return event.item.getData();
        }
        Object input = viewer.getInput();
        if (input instanceof DatabaseNavigatorContent) {
            return ((DatabaseNavigatorContent)input).getRootNode();
        }
        if (input instanceof List && !((List)input).isEmpty()) {
            return ((List)input).get(0);
        }
        return null;
    }

    private static void dropFilesIntoFolder(DBRProgressMonitor monitor, IContainer toFolder, String[] data) throws Exception {
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String extFileName = stringArray[n2];
            java.nio.file.Path extFile = java.nio.file.Path.of(extFileName, new String[0]);
            NavigatorUtils.dropFileIntoContainer(monitor, toFolder, extFile);
            ++n2;
        }
    }

    private static void dropFileIntoContainer(DBRProgressMonitor monitor, IContainer toFolder, java.nio.file.Path extFile) throws CoreException, IOException {
        if (Files.exists(extFile, new LinkOption[0])) {
            Path ePath = new Path(extFile.getFileName().toString());
            if (Files.isDirectory(extFile, new LinkOption[0])) {
                List sourceFolderContents;
                IFolder subFolder = toFolder.getFolder((IPath)ePath);
                if (!subFolder.exists()) {
                    subFolder.create(true, true, monitor.getNestedMonitor());
                }
                Throwable throwable = null;
                Iterator iterator = null;
                try (Stream<java.nio.file.Path> list = Files.list(extFile);){
                    sourceFolderContents = list.collect(Collectors.toList());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                for (java.nio.file.Path folderFile : sourceFolderContents) {
                    NavigatorUtils.dropFileIntoContainer(monitor, (IContainer)subFolder, folderFile);
                }
            } else {
                monitor.subTask("Copy file " + extFile);
                try {
                    IFile targetFile;
                    if (toFolder instanceof IFolder && !toFolder.exists()) {
                        ((IFolder)toFolder).create(true, true, monitor.getNestedMonitor());
                    }
                    if ((targetFile = toFolder.getFile((IPath)ePath)).exists() && !UIUtils.confirmAction((String)"File exists", (String)("File '" + targetFile.getName() + "' exists. Do you want to overwrite it?"))) {
                        return;
                    }
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (InputStream is = Files.newInputStream(extFile, new OpenOption[0]);){
                        if (targetFile.exists()) {
                            targetFile.setContents(is, true, false, monitor.getNestedMonitor());
                        } else {
                            targetFile.create(is, true, monitor.getNestedMonitor());
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                finally {
                    monitor.worked(1);
                }
            }
        }
    }

    public static NavigatorViewBase getActiveNavigatorView(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof NavigatorViewBase) {
            return (NavigatorViewBase)activePart;
        }
        IWorkbenchPage activePage = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
        activePart = activePage.findView("org.jkiss.dbeaver.core.databaseNavigator");
        if (activePart instanceof NavigatorViewBase && activePage.isPartVisible(activePart)) {
            return (NavigatorViewBase)activePart;
        }
        activePart = activePage.findView("org.jkiss.dbeaver.core.projectNavigator");
        if (activePart instanceof NavigatorViewBase && activePage.isPartVisible(activePart)) {
            return (NavigatorViewBase)activePart;
        }
        return null;
    }

    public static void filterSelection(ISelection selection, boolean exclude) {
        if (selection instanceof IStructuredSelection) {
            HashMap<DBNDatabaseFolder, DBSObjectFilter> folders = new HashMap<DBNDatabaseFolder, DBSObjectFilter>();
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof DBNNode) {
                    DBNNode node = (DBNNode)item;
                    DBNDatabaseFolder folder = (DBNDatabaseFolder)node.getParentNode();
                    DBSObjectFilter nodeFilter = (DBSObjectFilter)folders.get(folder);
                    if (nodeFilter == null) {
                        nodeFilter = folder.getNodeFilter(folder.getItemsMeta(), true);
                        if (nodeFilter == null) {
                            nodeFilter = new DBSObjectFilter();
                        }
                        folders.put(folder, nodeFilter);
                    }
                    if (exclude) {
                        nodeFilter.addExclude(node.getNodeName());
                    } else {
                        nodeFilter.addInclude(node.getNodeName());
                    }
                    nodeFilter.setEnabled(true);
                }
                ++n2;
            }
            HashSet<DBPDataSourceContainer> changedContainers = new HashSet<DBPDataSourceContainer>();
            for (Map.Entry entry : folders.entrySet()) {
                ((DBNDatabaseFolder)entry.getKey()).setNodeFilter(((DBNDatabaseFolder)entry.getKey()).getItemsMeta(), (DBSObjectFilter)entry.getValue(), false);
                changedContainers.add(((DBNDatabaseFolder)entry.getKey()).getDataSourceContainer());
            }
            for (DBPDataSourceContainer ds : changedContainers) {
                ds.persistConfiguration();
            }
            NavigatorHandlerRefresh.refreshNavigator(folders.keySet());
        }
    }

    public static boolean syncEditorWithNavigator(INavigatorModelView navigatorView, IEditorPart activeEditor) {
        if (!(activeEditor instanceof IDataSourceContainerUpdate)) {
            return false;
        }
        IDataSourceContainerUpdate dsProvider = (IDataSourceContainerUpdate)activeEditor;
        Viewer navigatorViewer = navigatorView.getNavigatorViewer();
        if (navigatorViewer == null) {
            return false;
        }
        DBNNode selectedNode = NavigatorUtils.getSelectedNode(navigatorViewer.getSelection());
        DBPProject nodeProject = selectedNode.getOwnerProject();
        if (!(selectedNode instanceof DBNDatabaseNode) || nodeProject != null && !nodeProject.hasRealmPermission("project-resource-edit")) {
            return false;
        }
        DBNDatabaseNode databaseNode = (DBNDatabaseNode)selectedNode;
        DBSObject dbsObject = databaseNode.getObject();
        if (!(dbsObject instanceof DBSStructContainer)) {
            dbsObject = (DBSObject)DBUtils.getParentOfType(DBSStructContainer.class, (DBSObject)dbsObject);
        }
        DBPDataSourceContainer ds = databaseNode.getDataSourceContainer();
        if (dsProvider.getDataSourceContainer() != ds) {
            dsProvider.setDataSourceContainer(ds);
            DatabaseEditorContextBase editorContext = new DatabaseEditorContextBase(ds, dbsObject);
            EditorUtils.setInputDataSource((IEditorInput)activeEditor.getEditorInput(), (DatabaseEditorContext)editorContext);
        }
        if (activeEditor instanceof DBPContextProvider && dbsObject != null) {
            DBCExecutionContextDefaults editorContextDefaults;
            DBCExecutionContext navExecutionContext = null;
            try {
                navExecutionContext = DBUtils.getOrOpenDefaultContext((DBSObject)dbsObject, (boolean)false);
            }
            catch (DBCException dBCException) {}
            DBCExecutionContext editorExecutionContext = ((DBPContextProvider)activeEditor).getExecutionContext();
            if (navExecutionContext != null && editorExecutionContext != null && (editorContextDefaults = editorExecutionContext.getContextDefaults()) != null) {
                DBSObject dbObject = dbsObject;
                RuntimeUtils.runTask(monitor -> {
                    try {
                        monitor.beginTask("Change default object", 1);
                        if (dbObject instanceof DBSCatalog && dbObject != editorContextDefaults.getDefaultCatalog()) {
                            monitor.subTask("Change default catalog");
                            editorContextDefaults.setDefaultCatalog(monitor, (DBSCatalog)dbObject, null);
                        } else if (dbObject instanceof DBSSchema && dbObject != editorContextDefaults.getDefaultSchema()) {
                            monitor.subTask("Change default schema");
                            editorContextDefaults.setDefaultSchema(monitor, (DBSSchema)dbObject);
                        }
                        monitor.worked(1);
                        monitor.done();
                    }
                    catch (DBCException e) {
                        throw new InvocationTargetException(e);
                    }
                }, (String)"Set active object", (long)dbObject.getDataSource().getContainer().getPreferenceStore().getInt("connection.open.timeout"));
            }
        }
        return true;
    }

    public static void openNavigatorNode(Object node, IWorkbenchWindow window) {
        NavigatorUtils.openNavigatorNode(node, window, null);
    }

    public static void openNavigatorNode(Object node, IWorkbenchWindow window, Map<?, ?> parameters) {
        IResource resource;
        IResource iResource = resource = node instanceof IAdaptable ? (IResource)((IAdaptable)node).getAdapter(IResource.class) : null;
        if (resource instanceof IFile) {
            UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
            if (serviceSQL != null) {
                serviceSQL.openResource(resource);
            }
        } else if (node instanceof DBNNode && ((DBNNode)node).allowsOpen()) {
            INavigatorObjectManager objectManager;
            if (node instanceof DBNObjectNode && (objectManager = (INavigatorObjectManager)GeneralUtils.adapt((Object)((DBNObjectNode)node).getNodeObject(), INavigatorObjectManager.class)) != null) {
                if ((objectManager.getSupportedFeatures() & 1) != 0) {
                    try {
                        objectManager.openObjectEditor(window, (DBNObjectNode)node);
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError("Error opening object", "Error while opening object '" + ((DBNObjectNode)node).getNodeObject() + "'", (Throwable)e);
                    }
                }
                return;
            }
            Object activePage = parameters == null ? null : parameters.get("activePage");
            NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)node, CommonUtils.toString(activePage, null), window);
        }
    }

    @Nullable
    public static IStructuredSelection getSelectionFromPart(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        return (IStructuredSelection)selection;
    }

    public static DBPProject getSelectedProject() {
        ISelectionProvider selectionProvider;
        IWorkbenchPart activePart = UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart();
        ISelection selection = activePart == null ? null : ((selectionProvider = activePart.getSite().getSelectionProvider()) == null ? null : selectionProvider.getSelection());
        return NavigatorUtils.getSelectedProject(selection, activePart);
    }

    public static DBPProject getSelectedProject(ISelection currentSelection, IWorkbenchPart activePart) {
        Object selItem;
        DBPProject activeProject = null;
        if (currentSelection instanceof IStructuredSelection && !currentSelection.isEmpty() && (selItem = ((IStructuredSelection)currentSelection).getFirstElement()) instanceof DBNNode) {
            activeProject = ((DBNNode)selItem).getOwnerProject();
        }
        if (activeProject == null && activePart instanceof DBPContextProvider) {
            DBPDataSourceContainer container;
            DBCExecutionContext executionContext = ((DBPContextProvider)activePart).getExecutionContext();
            if (executionContext != null) {
                activeProject = executionContext.getDataSource().getContainer().getRegistry().getProject();
            } else if (activePart instanceof DBPDataSourceContainerProvider && (container = ((DBPDataSourceContainerProvider)activePart).getDataSourceContainer()) != null) {
                activeProject = container.getProject();
            }
        }
        if (activeProject == null) {
            activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        }
        return activeProject;
    }

    public static void showNodeInNavigator(DBNDatabaseNode dsNode) {
        NavigatorViewBase nodeView;
        IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
        try {
            if (dsNode.getOwnerProject() == DBWorkbench.getPlatform().getWorkspace().getActiveProject()) {
                nodeView = (NavigatorViewBase)UIUtils.findView((IWorkbenchWindow)workbenchWindow, DatabaseNavigatorView.class);
                if (nodeView == null) {
                    nodeView = (NavigatorViewBase)workbenchWindow.getActivePage().showView("org.jkiss.dbeaver.core.databaseNavigator");
                }
            } else {
                nodeView = (NavigatorViewBase)UIUtils.findView((IWorkbenchWindow)workbenchWindow, ProjectNavigatorView.class);
                if (nodeView == null) {
                    nodeView = (NavigatorViewBase)workbenchWindow.getActivePage().showView("org.jkiss.dbeaver.core.projectNavigator");
                }
            }
        }
        catch (PartInitException e) {
            DBWorkbench.getPlatformUI().showError("Can't open view", "Error opening navigator view", (Throwable)e);
            return;
        }
        if (nodeView != null) {
            if (!workbenchWindow.getActivePage().isPartVisible((IWorkbenchPart)nodeView)) {
                workbenchWindow.getActivePage().bringToTop((IWorkbenchPart)nodeView);
            }
            nodeView.showNode((DBNNode)dsNode);
        }
    }

    private static class TransferInfo {
        private final String name;
        private final DBNNode node;
        private final DBPNamedObject object;

        public TransferInfo(@NotNull String name, @NotNull DBNNode node, @Nullable DBPNamedObject object) {
            this.node = node;
            this.object = object;
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public DBPNamedObject getObject() {
            return this.object;
        }

        @Nullable
        public EditorInputTransfer.EditorInputData createEditorInputData() {
            if (this.node instanceof DBNDatabaseNode) {
                DatabaseNodeEditorInput input = new DatabaseNodeEditorInput((DBNDatabaseNode)this.node);
                return EditorInputTransfer.createEditorInputData((String)"org.jkiss.dbeaver.ui.editors.entity.EntityEditor", (IEditorInput)input);
            }
            File file = new File(this.name);
            if (file.exists()) {
                try {
                    IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
                    IEditorDescriptor editor = EditorUtils.getFileEditorDescriptor((File)file, (IWorkbenchWindow)window);
                    FileStoreEditorInput input = new FileStoreEditorInput(EFS.getStore((URI)file.toURI()));
                    return EditorInputTransfer.createEditorInputData((String)editor.getId(), (IEditorInput)input);
                }
                catch (Exception e) {
                    log.warn((Object)("Error creating editor input for file '" + file + "'"), (Throwable)e);
                }
            }
            return null;
        }
    }
}

