/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.valuefilter.FilterValueEditDialog;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum FilterByAttributeType {
    CLIPBOARD(ResultSetMessages.controls_resultset_viewer_action_filter_clipboard, (DBPImage)UIIcon.FILTER_CLIPBOARD){

        @Override
        Object getValue(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attribute, @NotNull DBCLogicalOperator operator, boolean useDefault) {
            try {
                Object value = ResultSetUtils.getAttributeValueFromClipboard(attribute);
                if (operator == DBCLogicalOperator.LIKE && value instanceof String && ((String)value).indexOf(37) < 0) {
                    return "%" + value + "%";
                }
                return value;
            }
            catch (Exception e) {
                log.debug((Object)"Error copying from clipboard", (Throwable)e);
                return null;
            }
        }
    }
    ,
    VALUE(ResultSetMessages.controls_resultset_viewer_action_filter_value, (DBPImage)UIIcon.FILTER_VALUE){

        @Override
        Object getValue(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attribute, @NotNull DBCLogicalOperator operator, boolean useDefault) {
            ResultSetRow row = viewer.getCurrentRow();
            if (attribute == null || row == null) {
                return null;
            }
            Object cellValue = viewer.getModel().getCellValue(attribute, row);
            if (operator == DBCLogicalOperator.LIKE && cellValue != null) {
                cellValue = "%" + cellValue + "%";
            }
            return cellValue;
        }
    }
    ,
    INPUT(ResultSetMessages.controls_resultset_viewer_action_filter_input, (DBPImage)UIIcon.FILTER_INPUT){

        @Override
        Object getValue(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attribute, @NotNull DBCLogicalOperator operator, boolean useDefault) {
            if (useDefault) {
                return "..";
            }
            ResultSetRow[] rows = null;
            if (operator.getArgumentCount() < 0) {
                List<ResultSetRow> selectedRows = viewer.getSelection().getSelectedRows();
                rows = selectedRows.toArray(new ResultSetRow[0]);
            } else {
                ResultSetRow focusRow = viewer.getCurrentRow();
                if (focusRow != null) {
                    rows = new ResultSetRow[]{focusRow};
                }
            }
            if (rows == null || rows.length == 0) {
                return null;
            }
            FilterValueEditDialog dialog = new FilterValueEditDialog(viewer, attribute, rows, operator);
            if (dialog.open() == 0) {
                Object value = dialog.getValue();
                if (operator == DBCLogicalOperator.LIKE && value instanceof String && ((String)value).indexOf(37) < 0) {
                    return "%" + value + "%";
                }
                return value;
            }
            return null;
        }
    }
    ,
    NONE("None", (DBPImage)UIIcon.FILTER_VALUE){

        @Override
        Object getValue(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attribute, @NotNull DBCLogicalOperator operator, boolean useDefault) {
            return null;
        }
    };

    final String title;
    final ImageDescriptor icon;
    private static final Log log;

    static {
        log = Log.getLog(ResultSetViewer.class);
    }

    private FilterByAttributeType(String title, DBPImage icon) {
        this.title = title;
        this.icon = DBeaverIcons.getImageDescriptor((DBPImage)icon);
    }

    @Nullable
    abstract Object getValue(@NotNull ResultSetViewer var1, @NotNull DBDAttributeBinding var2, @NotNull DBCLogicalOperator var3, boolean var4);
}

