/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt2;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferUtils;
import org.jkiss.dbeaver.tools.transfer.internal.DTActivator;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferAttributeTransformerDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.utils.CommonUtils;

public class DatabaseMappingAttribute
implements DatabaseMappingObject {
    private static final Log log = Log.getLog(DatabaseMappingAttribute.class);
    public static final String TARGET_NAME_SKIP = "[skip]";
    private final DatabaseMappingContainer parent;
    @Nullable
    private final DBSAttributeBase source;
    @Nullable
    private DBSEntityAttribute target;
    private String targetName;
    private String targetType;
    private DatabaseMappingType mappingType;
    private DataTransferAttributeTransformerDescriptor transformer;
    private final Map<String, Object> transformerProperties = new LinkedHashMap<String, Object>();

    DatabaseMappingAttribute(DatabaseMappingContainer parent, @NotNull DBSAttributeBase source) {
        this.parent = parent;
        this.source = source;
        this.mappingType = DatabaseMappingType.unspecified;
    }

    DatabaseMappingAttribute(@NotNull DatabaseMappingContainer parent, @Nullable DBSAttributeBase source, @Nullable DBSEntityAttribute target, @NotNull DatabaseMappingType mappingType) {
        this.parent = parent;
        this.source = source;
        this.target = target;
        this.mappingType = mappingType;
    }

    DatabaseMappingAttribute(@NotNull DatabaseMappingAttribute attribute, @NotNull DatabaseMappingContainer parent) {
        this.parent = parent;
        this.source = attribute.source;
        this.target = attribute.target;
        this.targetName = attribute.targetName;
        this.targetType = attribute.targetType;
        this.mappingType = attribute.mappingType;
    }

    public DatabaseMappingContainer getParent() {
        return this.parent;
    }

    @Override
    public DBPImage getIcon() {
        return DBValueFormatting.getObjectImage((DBPObject)this.source);
    }

    @Nullable
    public DBSAttributeBase getSource() {
        return this.source;
    }

    public String getSourceType() {
        String typeModifiers;
        if (this.source == null) {
            return null;
        }
        String typeName = this.source.getTypeName();
        DBSDataContainer container = this.parent.getSource();
        if (container != null && container.getDataSource() != null && (typeModifiers = container.getDataSource().getSQLDialect().getColumnTypeModifiers(container.getDataSource(), (DBSTypedObject)this.source, typeName, this.source.getDataKind())) != null) {
            typeName = String.valueOf(typeName) + typeModifiers;
        }
        return typeName;
    }

    @Override
    public String getTargetName() {
        switch (this.mappingType) {
            case existing: 
            case recreate: {
                if (this.target != null) {
                    return DBUtils.getObjectFullName((DBPNamedObject)this.target, (DBPEvaluationContext)DBPEvaluationContext.UI);
                }
                return this.targetName;
            }
            case create: {
                return this.targetName;
            }
            case skip: {
                return TARGET_NAME_SKIP;
            }
        }
        return "?";
    }

    @Override
    public DatabaseMappingType getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(DatabaseMappingType mappingType) {
        this.mappingType = mappingType;
        switch (mappingType) {
            case create: {
                this.targetName = this.getSourceLabelOrName(this.getSource(), true, false);
            }
        }
    }

    public void updateMappingType(DBRProgressMonitor monitor, boolean forceRefresh, boolean updateAttributesNames) throws DBException {
        String sourceLabelOrName;
        if (this.mappingType == DatabaseMappingType.skip) {
            return;
        }
        if (this.parent.getMappingType() == DatabaseMappingType.skip) {
            this.mappingType = DatabaseMappingType.skip;
            return;
        }
        this.mappingType = DatabaseMappingType.unspecified;
        if (this.parent.getTarget() instanceof DBSEntity) {
            DBSEntity targetEntity;
            List targetAttributes;
            if (forceRefresh || CommonUtils.isEmpty((String)this.targetName)) {
                this.targetName = this.getSourceLabelOrName(this.source, false, updateAttributesNames);
            }
            if (CommonUtils.isEmpty((Collection)(targetAttributes = (targetEntity = (DBSEntity)this.parent.getTarget()).getAttributes(monitor))) && targetEntity instanceof DBPRefreshableObject) {
                ((DBPRefreshableObject)targetEntity).refreshObject(monitor);
                targetAttributes = targetEntity.getAttributes(monitor);
            }
            this.target = targetAttributes != null ? (DBSEntityAttribute)CommonUtils.findBestCaseAwareMatch((Iterable)targetAttributes, (String)DBUtils.getUnQuotedIdentifier((DBPDataSource)targetEntity.getDataSource(), (String)this.targetName), DBPNamedObject::getName) : null;
            if (this.source instanceof StreamDataImporterColumnInfo && targetAttributes != null) {
                StreamDataImporterColumnInfo source = (StreamDataImporterColumnInfo)this.source;
                if (!source.isMappingMetadataPresent()) {
                    List suitableTargetAttributes = targetAttributes.stream().filter(attr -> !DBUtils.isPseudoAttribute((DBSAttributeBase)attr) && !DBUtils.isHiddenObject((Object)attr)).sorted(Comparator.comparing(DBSAttributeBase::getOrdinalPosition)).collect(Collectors.toList());
                    if (source.getOrdinalPosition() < suitableTargetAttributes.size()) {
                        DBSEntityAttribute targetAttribute = (DBSEntityAttribute)suitableTargetAttributes.get(source.getOrdinalPosition());
                        this.target = (DBSEntityAttribute)CommonUtils.findBestCaseAwareMatch((Iterable)targetAttributes, (String)DBUtils.getUnQuotedIdentifier((DBPDataSource)targetEntity.getDataSource(), (String)this.targetName), DBPNamedObject::getName);
                        this.targetName = this.target != null && !targetAttribute.getName().equalsIgnoreCase(this.target.getName()) ? this.target.getName() : targetAttribute.getName();
                    }
                }
                if (this.target != null) {
                    source.setTypeName(this.target.getTypeName());
                    source.setMaxLength(this.target.getMaxLength());
                    source.setDataKind(this.target.getDataKind());
                }
            }
            this.mappingType = this.target != null ? (this.parent.getMappingType() == DatabaseMappingType.recreate ? DatabaseMappingType.create : DatabaseMappingType.existing) : DatabaseMappingType.create;
        } else {
            this.mappingType = DatabaseMappingType.create;
            if (forceRefresh || CommonUtils.isEmpty((String)this.targetName)) {
                this.targetName = !updateAttributesNames && CommonUtils.isNotEmpty((String)this.targetName) ? this.getSourceLabelOrName(this.targetName, false, false) : this.getSourceLabelOrName(this.source, true, updateAttributesNames);
            }
        }
        if (this.mappingType == DatabaseMappingType.create && !CommonUtils.isEmpty((String)this.targetName)) {
            DBSObjectContainer container = this.parent.getSettings().getContainer();
            if (container != null && container.getDataSource() != null) {
                DBPDataSource targetDataSource;
                this.targetName = DatabaseTransferUtils.getTransformedName(targetDataSource, this.targetName, DBUtils.isQuotedIdentifier((DBPDataSource)(targetDataSource = container.getDataSource()), (String)this.targetName) || this.isSkipNameTransformation());
            }
        } else if (this.mappingType == DatabaseMappingType.unspecified && this.source != null && this.targetName != null && (sourceLabelOrName = this.getSourceLabelOrName(this.source, false, updateAttributesNames)) != null && sourceLabelOrName.equalsIgnoreCase(this.targetName) && !sourceLabelOrName.equals(this.targetName)) {
            this.targetName = sourceLabelOrName;
        }
    }

    String getSourceLabelOrName(DBSAttributeBase source, boolean addSpecialTransformation, boolean updateAttributesNames) {
        return this.getSourceLabelOrName(this.getSourceAttributeName(source), addSpecialTransformation, updateAttributesNames);
    }

    private String getSourceLabelOrName(String name, boolean addSpecialTransformation, boolean updateAttributesNames) {
        DBSObjectContainer container = this.parent.getSettings().getContainer();
        if (container != null && container.getDataSource() != null) {
            if (addSpecialTransformation) {
                name = DatabaseTransferUtils.getTransformedName(container.getDataSource(), name, DBUtils.isQuotedIdentifier((DBPDataSource)container.getDataSource(), (String)name) || this.isSkipNameTransformation() || !updateAttributesNames);
            } else if (!DBUtils.isQuotedIdentifier((DBPDataSource)container.getDataSource(), (String)name) && !this.isSkipNameTransformation()) {
                name = DBObjectNameCaseTransformer.transformName((DBPDataSource)container.getDataSource(), (String)name);
            }
        }
        return name;
    }

    @NotNull
    private String getSourceAttributeName(@NotNull DBSAttributeBase source) {
        String name = null;
        if (source instanceof DBDAttributeBinding) {
            name = ((DBDAttributeBinding)source).getLabel();
        }
        if (CommonUtils.isEmpty(name)) {
            name = source.getName();
        }
        return name;
    }

    private boolean isSkipNameTransformation() {
        boolean isSkipNameTransformation = false;
        if (this.source instanceof DBSObject) {
            DBPDataSource sourceDataSource = ((DBSObject)this.source).getDataSource();
            String sourceAttributeName = this.getSourceAttributeName(this.source);
            if (sourceDataSource != null && sourceDataSource.getSQLDialect() != null && CommonUtils.isNotEmpty((String)sourceAttributeName)) {
                isSkipNameTransformation = sourceDataSource.getSQLDialect().mustBeQuoted(sourceAttributeName, true);
            }
        }
        return isSkipNameTransformation;
    }

    @Nullable
    public DBSEntityAttribute getTarget() {
        return this.target;
    }

    public void setTarget(@Nullable DBSEntityAttribute target) {
        this.target = target;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetType(DBPDataSource targetDataSource, boolean addModifiers) {
        if (!CommonUtils.isEmpty((String)this.targetType)) {
            return this.targetType;
        }
        this.changeDataTypeLength(targetDataSource);
        return DBStructUtils.mapTargetDataType((DBSObject)targetDataSource, (DBSTypedObject)this.source, (boolean)addModifiers);
    }

    private void changeDataTypeLength(@NotNull DBPDataSource targetDataSource) {
        if (this.source instanceof DBSTypedObjectExt2) {
            DBPPreferenceStore preferenceStore = targetDataSource.getContainer().getPreferenceStore();
            DBPPreferenceStore store = DTActivator.getDefault().getPreferences();
            if (preferenceStore.contains("maxTypeLengthMapping") || store.contains("maxTypeLengthMapping")) {
                int maxDataTypeLength = preferenceStore.contains("maxTypeLengthMapping") ? preferenceStore.getInt("maxTypeLengthMapping") : store.getInt("maxTypeLengthMapping");
                DBSTypedObjectExt2 sourceExt = (DBSTypedObjectExt2)this.source;
                if (this.source.getDataKind() == DBPDataKind.NUMERIC && this.source.getPrecision() != null && this.source.getPrecision() > maxDataTypeLength) {
                    sourceExt.setPrecision(Integer.valueOf(maxDataTypeLength));
                } else if (this.source.getMaxLength() > (long)maxDataTypeLength) {
                    sourceExt.setMaxLength((long)maxDataTypeLength);
                }
            }
        }
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public DataTransferAttributeTransformerDescriptor getTransformer() {
        return this.transformer;
    }

    public void setTransformer(DataTransferAttributeTransformerDescriptor transformer) {
        this.transformer = transformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTransformerProperties() {
        Map<String, Object> map = this.transformerProperties;
        synchronized (map) {
            return new LinkedHashMap<String, Object>(this.transformerProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransformerProperties(Map<String, Object> properties) {
        Map<String, Object> map = this.transformerProperties;
        synchronized (map) {
            this.transformerProperties.clear();
            this.transformerProperties.putAll(properties);
        }
    }

    void saveSettings(Map<String, Object> settings) {
        if (this.targetName != null) {
            settings.put("targetName", this.targetName);
        }
        if (this.targetType != null) {
            settings.put("targetType", this.targetType);
        }
        if (this.mappingType != null) {
            settings.put("mappingType", this.mappingType.name());
            if (this.transformer != null) {
                settings.put("transformer", this.transformer.getId());
                settings.put("transformerProperties", new LinkedHashMap<String, Object>(this.transformerProperties));
                settings.put("transformerPropertiesNames", String.join((CharSequence)",", this.transformerProperties.keySet()));
            }
        }
    }

    public void loadSettings(Map<String, Object> settings) {
        Object transformerId;
        this.targetName = CommonUtils.toString((Object)settings.get("targetName"));
        this.targetType = CommonUtils.toString((Object)settings.get("targetType"));
        if (settings.get("mappingType") != null) {
            try {
                DBSEntity dbsEntity;
                DBSDataManipulator targetEntity;
                DatabaseMappingType newMappingType = DatabaseMappingType.valueOf((String)settings.get("mappingType"));
                if (!CommonUtils.isEmpty((String)this.targetName) && (targetEntity = this.parent.getTarget()) instanceof DBSEntity && (dbsEntity = (DBSEntity)targetEntity).getDataSource() != null) {
                    this.target = (DBSEntityAttribute)CommonUtils.findBestCaseAwareMatch((Iterable)CommonUtils.safeCollection((Collection)dbsEntity.getAttributes((DBRProgressMonitor)new VoidProgressMonitor())), (String)DBUtils.getUnQuotedIdentifier((DBPDataSource)dbsEntity.getDataSource(), (String)this.targetName), DBPNamedObject::getName);
                }
                if (this.target != null && newMappingType == DatabaseMappingType.create && this.parent.getMappingType() != DatabaseMappingType.recreate) {
                    newMappingType = DatabaseMappingType.existing;
                } else if (this.target == null && newMappingType == DatabaseMappingType.existing) {
                    newMappingType = DatabaseMappingType.create;
                }
                this.mappingType = newMappingType;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        if ((transformerId = settings.get("transformer")) != null) {
            this.transformer = DataTransferRegistry.getInstance().getAttributeTransformer(transformerId.toString());
            if (this.transformer == null) {
                log.error((Object)("Can't find attribute transformer " + transformerId));
            } else {
                Map tp = (Map)settings.get("transformerProperties");
                String[] tpNames = CommonUtils.toString((Object)settings.get("transformerPropertiesNames"), (String)"").split(",");
                this.transformerProperties.clear();
                if (tp != null) {
                    String[] stringArray = tpNames;
                    int n = tpNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        if (!CommonUtils.isEmpty((String)name)) {
                            this.transformerProperties.put(name, tp.get(name));
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    public String toString() {
        return this.source != null ? this.source.getName() : this.getTargetName();
    }
}

