/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.config;

import java.util.ArrayList;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.MySQLUtils;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLUser;
import org.jkiss.dbeaver.ext.mysql.ui.config.UserPropertyHandler;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandComposite;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class MySQLCommandChangeUser
extends DBECommandComposite<MySQLUser, UserPropertyHandler> {
    protected MySQLCommandChangeUser(MySQLUser user) {
        super((DBPObject)user, MySQLUIMessages.edit_command_change_user_name);
    }

    public boolean isDisableSessionLogging() {
        return this.getProperties().containsKey(UserPropertyHandler.PASSWORD.name());
    }

    public void updateModel() {
        for (Map.Entry entry : this.getProperties().entrySet()) {
            switch (UserPropertyHandler.valueOf((String)entry.getKey())) {
                case MAX_QUERIES: {
                    ((MySQLUser)this.getObject()).setMaxQuestions(CommonUtils.toInt(entry.getValue()));
                    break;
                }
                case MAX_UPDATES: {
                    ((MySQLUser)this.getObject()).setMaxUpdates(CommonUtils.toInt(entry.getValue()));
                    break;
                }
                case MAX_CONNECTIONS: {
                    ((MySQLUser)this.getObject()).setMaxConnections(CommonUtils.toInt(entry.getValue()));
                    break;
                }
                case MAX_USER_CONNECTIONS: {
                    ((MySQLUser)this.getObject()).setMaxUserConnections(CommonUtils.toInt(entry.getValue()));
                    break;
                }
            }
        }
    }

    public void validateCommand(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        String passValue = CommonUtils.toString((Object)this.getProperty(UserPropertyHandler.PASSWORD));
        String confirmValue = CommonUtils.toString((Object)this.getProperty(UserPropertyHandler.PASSWORD_CONFIRM));
        if (!CommonUtils.isEmpty((String)passValue) && !CommonUtils.equalObjects((Object)passValue, (Object)confirmValue)) {
            throw new DBException("Password confirmation value is invalid");
        }
    }

    public DBEPersistAction[] getPersistActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, Map<String, Object> options) {
        MySQLDataSource dataSource;
        ArrayList<SQLDatabasePersistAction> actions = new ArrayList<SQLDatabasePersistAction>();
        boolean newUser = !((MySQLUser)this.getObject()).isPersisted();
        boolean includeUserPassword = true;
        if (newUser) {
            StringBuilder script = new StringBuilder();
            includeUserPassword = this.generateCreateScript(script);
            actions.add(new SQLDatabasePersistAction(MySQLUIMessages.edit_command_change_user_action_create_new_user, script.toString()){

                public void afterExecute(DBCSession session, Throwable error) {
                    if (error == null) {
                        ((MySQLUser)MySQLCommandChangeUser.this.getObject()).setPersisted(true);
                    }
                }
            });
        }
        if (MySQLUtils.isAlterUSerSupported((MySQLDataSource)(dataSource = ((MySQLUser)this.getObject()).getDataSource()))) {
            StringBuilder script = new StringBuilder();
            if (this.generateAlterScript(script, includeUserPassword)) {
                actions.add(new SQLDatabasePersistAction(MySQLUIMessages.edit_command_change_user_action_update_user_record, script.toString()));
            }
        } else {
            String updateSQL = this.generateUpdateScript();
            if (updateSQL != null) {
                actions.add(new SQLDatabasePersistAction(MySQLUIMessages.edit_command_change_user_action_update_user_record, updateSQL));
            }
            if ((updateSQL = this.generatePasswordSet()) != null) {
                actions.add(new SQLDatabasePersistAction(MySQLUIMessages.edit_command_change_user_action_update_user_record, updateSQL));
            }
        }
        return actions.toArray(new DBEPersistAction[0]);
    }

    private String generateUpdateScript() {
        StringBuilder script = new StringBuilder();
        script.append("UPDATE mysql.user SET ");
        boolean hasSet = false;
        for (Map.Entry entry : this.getProperties().entrySet()) {
            String delim = hasSet ? "," : "";
            switch (UserPropertyHandler.valueOf((String)entry.getKey())) {
                case MAX_QUERIES: {
                    script.append(delim).append("Max_Questions=").append(CommonUtils.toInt(entry.getValue()));
                    hasSet = true;
                    break;
                }
                case MAX_UPDATES: {
                    script.append(delim).append("Max_Updates=").append(CommonUtils.toInt(entry.getValue()));
                    hasSet = true;
                    break;
                }
                case MAX_CONNECTIONS: {
                    script.append(delim).append("Max_Connections=").append(CommonUtils.toInt(entry.getValue()));
                    hasSet = true;
                    break;
                }
                case MAX_USER_CONNECTIONS: {
                    script.append(delim).append("Max_User_Connections=").append(CommonUtils.toInt(entry.getValue()));
                    hasSet = true;
                    break;
                }
            }
        }
        if (!hasSet) {
            return null;
        }
        script.append(" WHERE User='").append(((MySQLUser)this.getObject()).getUserName()).append("' AND Host='").append(((MySQLUser)this.getObject()).getHost()).append("'");
        return script.toString();
    }

    private String generatePasswordSet() {
        Object passwordValue = this.getProperties().get(UserPropertyHandler.PASSWORD.name());
        if (passwordValue == null) {
            return null;
        }
        MySQLUser user = (MySQLUser)this.getObject();
        return "SET PASSWORD FOR '" + user.getUserName() + "'@'" + user.getHost() + "' = PASSWORD(" + SQLUtils.quoteString((DBSObject)user, (String)passwordValue.toString()) + ")";
    }

    private boolean generateCreateScript(@NotNull StringBuilder script) {
        MySQLUser object = (MySQLUser)this.getObject();
        script.append("CREATE USER ").append(object.getFullName());
        if (this.getProperties().containsKey(UserPropertyHandler.PASSWORD.name())) {
            this.generateIdentifiedByClause(script);
            return false;
        }
        return true;
    }

    private boolean generateAlterScript(StringBuilder script, boolean includePassword) {
        boolean hasSet = false;
        boolean hasResOptions = false;
        script.append("ALTER USER ").append(((MySQLUser)this.getObject()).getFullName());
        if (this.getProperties().containsKey(UserPropertyHandler.PASSWORD.name()) && includePassword) {
            this.generateIdentifiedByClause(script);
            hasSet = true;
        }
        StringBuilder resOptions = new StringBuilder();
        for (Map.Entry entry : this.getProperties().entrySet()) {
            switch (UserPropertyHandler.valueOf((String)entry.getKey())) {
                case MAX_QUERIES: {
                    resOptions.append("\n\tMAX_QUERIES_PER_HOUR ").append(CommonUtils.toInt(entry.getValue()));
                    hasResOptions = true;
                    break;
                }
                case MAX_UPDATES: {
                    resOptions.append("\n\tMAX_UPDATES_PER_HOUR ").append(CommonUtils.toInt(entry.getValue()));
                    hasResOptions = true;
                    break;
                }
                case MAX_CONNECTIONS: {
                    resOptions.append("\n\tMAX_CONNECTIONS_PER_HOUR ").append(CommonUtils.toInt(entry.getValue()));
                    hasResOptions = true;
                    break;
                }
                case MAX_USER_CONNECTIONS: {
                    resOptions.append("\n\tMAX_USER_CONNECTIONS ").append(CommonUtils.toInt(entry.getValue()));
                    hasResOptions = true;
                }
            }
        }
        if (resOptions.length() > 0) {
            script.append("\nWITH").append((CharSequence)resOptions);
        }
        return hasSet || hasResOptions;
    }

    private void generateIdentifiedByClause(@NotNull StringBuilder script) {
        script.append(" IDENTIFIED BY ").append(SQLUtils.quoteString((DBSObject)((DBSObject)this.getObject()), (String)CommonUtils.toString(this.getProperties().get(UserPropertyHandler.PASSWORD.name()))));
    }
}

