/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.analyzer;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.lsm.LSMAnalyzer;
import org.jkiss.dbeaver.model.lsm.sql.dialect.LSMDialectRegistry;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.analyzer.TableReferencesAnalyzer;
import org.jkiss.dbeaver.model.sql.analyzer.TableReferencesRules;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.stm.STMErrorListener;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMSkippingErrorListener;
import org.jkiss.dbeaver.model.stm.STMSource;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMTreeRuleNode;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.utils.CommonUtils;

public class TableReferencesAnalyzerImpl
implements TableReferencesAnalyzer {
    private Map<String, String> tableReferences;
    private SQLCompletionRequest request;
    private Log log = Log.getLog(TableReferencesAnalyzerImpl.class);

    public TableReferencesAnalyzerImpl(SQLCompletionRequest request) {
        this.request = request;
    }

    private void prepareTableReferences(String query) {
        try {
            STMSource querySource = STMSource.fromReader((Reader)new StringReader(query));
            LSMAnalyzer analyzer = LSMDialectRegistry.getInstance().getAnalyzerForDialect(this.request.getContext().getDataSource().getSQLDialect());
            STMTreeRuleNode tree = analyzer.parseSqlQueryTree(querySource, (STMErrorListener)new STMSkippingErrorListener());
            this.tableReferences = this.getTableAndAliasFromSources(tree);
        }
        catch (Exception e) {
            this.log.debug((Object)"Failed to extract table names from query", (Throwable)e);
            this.tableReferences = Collections.emptyMap();
        }
    }

    @Override
    @NotNull
    public Map<String, String> getFilteredTableReferences(@NotNull String tableAlias, boolean allowPartialMatch) {
        if (this.tableReferences == null || this.tableReferences.isEmpty()) {
            SQLScriptElement activeQuery = this.request.getActiveQuery();
            if (activeQuery == null) {
                return Collections.emptyMap();
            }
            this.prepareTableReferences(activeQuery.getText());
        }
        Map<String, String> result = CommonUtils.isNotEmpty((String)tableAlias) && this.tableReferences != null && this.tableReferences.size() > 0 ? this.tableReferences.entrySet().stream().filter(r -> allowPartialMatch ? r.getValue() != null && CommonUtils.startsWithIgnoreCase((String)((String)r.getValue()), (String)tableAlias) : r.getValue() != null && ((String)r.getValue()).equalsIgnoreCase(tableAlias)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : this.tableReferences;
        return result;
    }

    @Override
    public Map<String, String> getTableAlicesFromQuery(String query) {
        try {
            this.prepareTableReferences(query);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.tableReferences;
    }

    @Nullable
    public Map<String, String> getTableAndAliasFromSources(STMTreeRuleNode query) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        List tableExpandedReferences = STMUtils.expandSubtree((STMTreeNode)query, TableReferencesRules.expandRulesToTableRef, TableReferencesRules.extractRulesToTableRef);
        for (STMTreeNode tableRef : tableExpandedReferences) {
            List names = STMUtils.expandSubtree((STMTreeNode)tableRef, TableReferencesRules.expandRulesToTableName, TableReferencesRules.extractRulesToTableName);
            String alias = null;
            String tableName = null;
            for (STMTreeNode part : names) {
                String nodeName = part.getNodeName();
                if (nodeName.equals(STMKnownRuleNames.tableName)) {
                    tableName = part.getText();
                    continue;
                }
                if (!nodeName.equals(STMKnownRuleNames.correlationName)) continue;
                alias = part.getText();
            }
            result.put(tableName, alias);
        }
        return result;
    }
}

