/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.utils.CommonUtils;

public class PostgreBackupRestoreSettings
extends AbstractImportExportSettings<DBSObject> {
    private ExportFormat format = ExportFormat.CUSTOM;

    public ExportFormat getFormat() {
        return this.format;
    }

    public void setFormat(ExportFormat format) {
        this.format = format;
    }

    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) throws DBException {
        this.format = (ExportFormat)CommonUtils.valueOf(ExportFormat.class, (String)store.getString("pg.format"), (Enum)ExportFormat.CUSTOM);
        super.loadSettings(runnableContext, store);
    }

    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) {
        super.saveSettings(runnableContext, store);
        store.setValue("pg.format", this.format == null ? null : this.format.name());
    }

    public static enum ExportFormat {
        PLAIN("p", "Plain", "sql"),
        CUSTOM("c", "Custom", ""),
        DIRECTORY("d", "Directory", ""),
        TAR("t", "Tar", "tar");

        private final String id;
        private String title;
        @NotNull
        private final String ext;

        private ExportFormat(@NotNull String id, String title, String ext) {
            this.id = id;
            this.title = title;
            this.ext = ext;
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        @NotNull
        public String getExt() {
            return this.ext;
        }
    }
}

