/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreConstraintManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTable;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;

public class PostgreForeignKeyManager
extends SQLForeignKeyManager<PostgreTableForeignKey, PostgreTableBase>
implements DBEObjectRenamer<PostgreTableForeignKey> {
    public boolean canRenameObject(PostgreTableForeignKey object) {
        return object.getDataSource().getServerType().supportsKeyAndIndexRename();
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreTableForeignKey> getObjectsCache(PostgreTableForeignKey object) {
        PostgreTableBase parent = (PostgreTableBase)object.getParentObject();
        if (parent instanceof PostgreTable) {
            return ((PostgreTable)parent).getForeignKeyCache();
        }
        return null;
    }

    protected PostgreTableForeignKey createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object from, Map<String, Object> options) {
        PostgreTableBase table = (PostgreTableBase)container;
        PostgreTableForeignKey foreignKey = new PostgreTableForeignKey(table, null, DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.NO_ACTION);
        foreignKey.setName(this.getNewConstraintName(monitor, (AbstractTableConstraint)foreignKey));
        return foreignKey;
    }

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, PostgreTableBase owner, DBECommandAbstract<PostgreTableForeignKey> command, Map<String, Object> options) {
        PostgreTableForeignKey fk = (PostgreTableForeignKey)command.getObject();
        StringBuilder sql = super.getNestedDeclaration(monitor, (AbstractTable)owner, command, options);
        if (fk.isDeferrable()) {
            sql.append(" DEFERRABLE");
        }
        if (fk.isDeferred()) {
            sql.append(" INITIALLY DEFERRED");
        }
        return sql;
    }

    protected void appendUpdateDeleteRule(PostgreTableForeignKey foreignKey, StringBuilder decl) {
        if (foreignKey.getMatchType().equals((Object)PostgreTableForeignKey.MatchType.f)) {
            decl.append(" MATCH FULL");
        }
        super.appendUpdateDeleteRule((AbstractTableConstraint)foreignKey, decl);
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        this.addObjectDeleteActions(monitor, executionContext, actionList, new SQLObjectEditor.ObjectDeleteCommand((SQLObjectEditor)this, (DBSObject)((PostgreTableForeignKey)command.getObject()), command.getTitle()), options);
        this.addObjectCreateActions(monitor, executionContext, actionList, this.makeCreateCommand((PostgreTableForeignKey)command.getObject(), options), options);
    }

    protected String getDropForeignKeyPattern(PostgreTableForeignKey foreignKey) {
        return "ALTER TABLE %TABLE% DROP CONSTRAINT %CONSTRAINT%";
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreTableForeignKey object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        PostgreTableForeignKey foreignKey = (PostgreTableForeignKey)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename constraint", "ALTER TABLE " + ((PostgreTableBase)foreignKey.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " RENAME CONSTRAINT " + DBUtils.getQuotedIdentifier((DBSObject)foreignKey) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)foreignKey.getDataSource(), (String)command.getNewName())));
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<PostgreTableForeignKey, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) throws DBException {
        if (command.getProperty((Object)"description") != null) {
            PostgreConstraintManager.addConstraintCommentAction(actions, (PostgreTableConstraintBase)command.getObject());
        }
    }
}

