/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardRenderer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardDataType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewType;
import org.jkiss.utils.CommonUtils;

public class DashboardViewTypeDescriptor
extends AbstractContextDescriptor
implements DashboardViewType {
    private String id;
    private String label;
    private String description;
    private DBPImage icon;
    private AbstractDescriptor.ObjectType implType;
    private DashboardDataType[] supportedDataTypes;

    DashboardViewTypeDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        String[] dataTypeNames = CommonUtils.notEmpty((String)config.getAttribute("dataTypes")).split(",");
        this.supportedDataTypes = new DashboardDataType[dataTypeNames.length];
        int i = 0;
        while (i < dataTypeNames.length) {
            this.supportedDataTypes[i] = (DashboardDataType)CommonUtils.valueOf(DashboardDataType.class, (String)dataTypeNames[i], (Enum)DashboardDataType.timeseries);
            ++i;
        }
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("renderer"));
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public DBPImage getIcon() {
        return this.icon;
    }

    @Override
    public DashboardDataType[] getSupportedTypes() {
        return this.supportedDataTypes;
    }

    @Override
    public DashboardRenderer createRenderer() throws DBException {
        return (DashboardRenderer)this.implType.createInstance(DashboardRenderer.class);
    }

    public String toString() {
        return this.id;
    }
}

