/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.views.session;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;

class SessionTable<SESSION_TYPE extends DBAServerSession>
extends DatabaseObjectListControl<SESSION_TYPE> {
    private static final Log log = Log.getLog(SessionTable.class);
    private DBAServerSessionManager<SESSION_TYPE> sessionManager;
    private static IStructuredContentProvider CONTENT_PROVIDER = new ITreeContentProvider(){

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };

    SessionTable(Composite parent, int style, IWorkbenchSite site, DBAServerSessionManager<SESSION_TYPE> sessionManager) {
        super(parent, style, site, (IContentProvider)CONTENT_PROVIDER);
        this.sessionManager = sessionManager;
    }

    public DBAServerSessionManager<SESSION_TYPE> getSessionManager() {
        return this.sessionManager;
    }

    @NotNull
    protected String getListConfigId(List<Class<?>> classList) {
        return "Sessions/" + this.sessionManager.getDataSource().getContainer().getDriver().getId();
    }

    protected LoadingJob<Collection<SESSION_TYPE>> createLoadService(boolean forUpdate) {
        return LoadingJob.createService((ILoadService)new LoadSessionsService(), (ILoadVisualizer)new ObjectListControl.ObjectsLoadVisualizer((ObjectListControl)this));
    }

    LoadingJob<Void> createAlterService(List<SESSION_TYPE> sessions, Map<String, Object> options) {
        return LoadingJob.createService((ILoadService)new KillSessionsService(sessions, options), (ILoadVisualizer)new ObjectListControl.ObjectActionVisualizer((ObjectListControl)this));
    }

    public void init(DBAServerSessionManager<SESSION_TYPE> sessionManager) {
        this.sessionManager = sessionManager;
    }

    protected Map<String, Object> getSessionOptions() {
        return null;
    }

    private class KillSessionsService
    extends DatabaseLoadService<Void> {
        private final List<SESSION_TYPE> sessions;
        private final Map<String, Object> options;

        KillSessionsService(List<SESSION_TYPE> sessions, Map<String, Object> options) {
            super("Kill session", SessionTable.this.sessionManager.getDataSource());
            this.sessions = sessions;
            this.options = options;
        }

        public Void evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                if (SessionTable.this.sessionManager.getDataSource().getContainer().isForceUseSingleConnection()) {
                    DBCExecutionContext context = DBUtils.getDefaultContext((DBSObject)SessionTable.this.sessionManager.getDataSource(), (boolean)false);
                    return this.killSession(monitor, context);
                }
                Throwable context = null;
                Object var3_6 = null;
                try (DBCExecutionContext isolatedContext = SessionTable.this.sessionManager.getDataSource().getDefaultInstance().openIsolatedContext(monitor, "View sessions", null);){
                    return this.killSession(monitor, isolatedContext);
                }
                catch (Throwable throwable) {
                    if (context == null) {
                        context = throwable;
                    } else if (context != throwable) {
                        context.addSuppressed(throwable);
                    }
                    throw context;
                }
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }

        private Void killSession(DBRProgressMonitor monitor, DBCExecutionContext context) throws InvocationTargetException {
            block13: {
                Throwable throwable = null;
                Object var4_5 = null;
                DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Kill server session");
                try {
                    Exception lastError = null;
                    for (DBAServerSession dbaSession : this.sessions) {
                        try {
                            SessionTable.this.sessionManager.alterSession(session, dbaSession, this.options);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error killing session " + session), (Throwable)e);
                            lastError = e;
                        }
                    }
                    if (lastError != null) {
                        throw new InvocationTargetException(lastError);
                    }
                    if (session == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                session.close();
            }
            return null;
        }
    }

    class LoadSessionsService
    extends DatabaseLoadService<Collection<SESSION_TYPE>> {
        LoadSessionsService() {
            super("Load sessions", SessionTable.this.sessionManager.getDataSource());
        }

        public Collection<SESSION_TYPE> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                if (SessionTable.this.sessionManager.getDataSource().getContainer().isForceUseSingleConnection()) {
                    DBCExecutionContext context = DBUtils.getDefaultContext((DBSObject)SessionTable.this.sessionManager.getDataSource(), (boolean)false);
                    return this.getSessions(monitor, context);
                }
                Throwable context = null;
                Object var3_6 = null;
                try (DBCExecutionContext isolatedContext = SessionTable.this.sessionManager.getDataSource().getDefaultInstance().openIsolatedContext(monitor, "View sessions", null);){
                    return this.getSessions(monitor, isolatedContext);
                }
                catch (Throwable throwable) {
                    if (context == null) {
                        context = throwable;
                    } else if (context != throwable) {
                        context.addSuppressed(throwable);
                    }
                    throw context;
                }
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }

        private Collection<SESSION_TYPE> getSessions(DBRProgressMonitor monitor, DBCExecutionContext context) throws DBException {
            Throwable throwable = null;
            Object var4_5 = null;
            try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Retrieve server sessions");){
                return SessionTable.this.sessionManager.getSessions(session, SessionTable.this.getSessionOptions());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

