/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.erd.model.ERDAttributeVisibility;
import org.jkiss.dbeaver.erd.ui.editor.ERDViewStyle;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIActivator;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIMessages;
import org.jkiss.dbeaver.erd.ui.notations.ERDNotationDescriptor;
import org.jkiss.dbeaver.erd.ui.notations.ERDNotationRegistry;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ERDPreferencePage
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.erd.general";
    private IAdaptable element;
    private Button contentsShowViews;
    private Button contentsShowPartitions;
    private Button changeBorderColors;
    private Button changeHeaderColors;
    private Combo modeCombo;
    private Spinner spinnerMarginTop;
    private Spinner spinnerMarginBottom;
    private Spinner spinnerMarginLeft;
    private Spinner spinnerMarginRight;
    private Button gridCheck;
    private Button snapCheck;
    private Combo routingType;
    private Combo notationType;
    private Spinner spinnerGridWidth;
    private Spinner spinnerGridHeight;
    private List<Button> visibilityButtons = new ArrayList<Button>();
    private List<Button> styleButtons = new ArrayList<Button>();

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        DBPPreferenceStore store = ERDUIActivator.getDefault().getPreferences();
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        this.createContentsGroup(store, composite);
        this.createColorPrefGroup(store, composite);
        this.createVisibilityGroup(store, composite);
        this.createStyleGroup(store, composite);
        this.createGridGroup(store, composite);
        this.createPrintGroup(store, composite);
        this.createAdvancedGroup(store, composite);
        return composite;
    }

    private void createAdvancedGroup(DBPPreferenceStore store, Composite composite) {
        ERDNotationDescriptor notation2;
        Group contentsGroup = UIUtils.createControlGroup((Composite)composite, (String)ERDUIMessages.erd_preference_page_title_advanced, (int)2, (int)0, (int)0);
        contentsGroup.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.routingType = UIUtils.createLabelCombo((Composite)contentsGroup, (String)ERDUIMessages.erd_preference_page_title_routing_combo, (int)12);
        this.routingType.add("Ortho Shortest Path");
        this.routingType.add("Mikami-Tabuchi (Experimental)");
        if (!CommonUtils.isEmpty((String)store.getString("erd.routing.type"))) {
            this.routingType.setText(store.getString("erd.routing.type"));
        } else {
            this.routingType.setText("Ortho Shortest Path");
        }
        this.notationType = UIUtils.createLabelCombo((Composite)contentsGroup, (String)ERDUIMessages.erd_preference_page_title_notation_combo, (int)12);
        List<ERDNotationDescriptor> erdNotations = ERDNotationRegistry.getInstance().getERDNotations();
        for (ERDNotationDescriptor notation2 : erdNotations) {
            this.notationType.add(notation2.getName());
        }
        notation2 = ERDNotationRegistry.getInstance().getNotation(store.getString("erd.notation.type"));
        if (notation2 != null) {
            this.notationType.select(erdNotations.indexOf((Object)notation2));
        } else {
            this.notationType.select(erdNotations.indexOf((Object)ERDNotationRegistry.getInstance().getDefaultNotation()));
        }
    }

    private void createContentsGroup(DBPPreferenceStore store, Composite composite) {
        Group contentsGroup = UIUtils.createControlGroup((Composite)composite, (String)ERDUIMessages.erd_preference_page_title_diagram_contents, (int)1, (int)0, (int)0);
        contentsGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.contentsShowViews = UIUtils.createCheckbox((Composite)contentsGroup, (String)ERDUIMessages.erd_preference_page_title_shows_views, (boolean)store.getBoolean("erd.diagram.show.views"));
        this.contentsShowPartitions = UIUtils.createCheckbox((Composite)contentsGroup, (String)ERDUIMessages.erd_preference_page_title_shows_partitions, (boolean)store.getBoolean("erd.diagram.show.partitions"));
    }

    private void createColorPrefGroup(DBPPreferenceStore store, Composite composite) {
        Group contentsGroup = UIUtils.createControlGroup((Composite)composite, (String)ERDUIMessages.erd_preference_page_title_color_pref, (int)1, (int)0, (int)0);
        contentsGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.changeBorderColors = UIUtils.createCheckbox((Composite)contentsGroup, (String)ERDUIMessages.erd_preference_page_title_change_border_colors, (boolean)store.getBoolean("erd.diagram.change.borders.colors"));
        this.changeHeaderColors = UIUtils.createCheckbox((Composite)contentsGroup, (String)ERDUIMessages.erd_preference_page_title_change_header_colors, (boolean)store.getBoolean("erd.diagram.change.header.colors"));
    }

    private void createVisibilityGroup(DBPPreferenceStore store, Composite composite) {
        ERDAttributeVisibility defaultVisibility = ERDAttributeVisibility.getDefaultVisibility((DBPPreferenceStore)store);
        Group elemsGroup = UIUtils.createControlGroup((Composite)composite, (String)ERDUIMessages.erd_preference_page_title_attributes_visibility, (int)1, (int)0, (int)0);
        elemsGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        ERDAttributeVisibility[] eRDAttributeVisibilityArray = ERDAttributeVisibility.values();
        int n = eRDAttributeVisibilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ERDAttributeVisibility visibility = eRDAttributeVisibilityArray[n2];
            Button radio = new Button((Composite)elemsGroup, 16);
            radio.setData((Object)visibility);
            radio.setText(visibility.getTitle());
            if (visibility == defaultVisibility) {
                radio.setSelection(true);
            }
            this.visibilityButtons.add(radio);
            ++n2;
        }
    }

    private void createStyleGroup(DBPPreferenceStore store, Composite composite) {
        ERDViewStyle[] enabledStyles = ERDViewStyle.getDefaultStyles(store);
        Group elemsGroup = UIUtils.createControlGroup((Composite)composite, (String)ERDUIMessages.erd_preference_page_title_attribute_style, (int)1, (int)0, (int)0);
        elemsGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        ERDViewStyle[] eRDViewStyleArray = ERDViewStyle.values();
        int n = eRDViewStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ERDViewStyle style = eRDViewStyleArray[n2];
            Button check = new Button((Composite)elemsGroup, 32);
            check.setData((Object)style);
            check.setText(style.getTitle());
            if (ArrayUtils.contains((Object[])enabledStyles, (Object)((Object)style))) {
                check.setSelection(true);
            }
            this.styleButtons.add(check);
            ++n2;
        }
    }

    private void createGridGroup(DBPPreferenceStore store, Composite composite) {
        Group gridGroup = UIUtils.createControlGroup((Composite)composite, (String)ERDUIMessages.pref_page_erd_group_grid, (int)2, (int)0, (int)0);
        gridGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.gridCheck = UIUtils.createCheckbox((Composite)gridGroup, (String)ERDUIMessages.pref_page_erd_checkbox_grid_enabled, null, (boolean)store.getBoolean("erd.grid.enabled"), (int)2);
        this.snapCheck = UIUtils.createCheckbox((Composite)gridGroup, (String)ERDUIMessages.pref_page_erd_checkbox_snap_to_grid, null, (boolean)store.getBoolean("erd.grid.snap"), (int)2);
        this.spinnerGridWidth = UIUtils.createLabelSpinner((Composite)gridGroup, (String)ERDUIMessages.pref_page_erd_spinner_grid_width, (int)store.getInt("erd.grid.width"), (int)5, (int)Short.MAX_VALUE);
        this.spinnerGridHeight = UIUtils.createLabelSpinner((Composite)gridGroup, (String)ERDUIMessages.pref_page_erd_spinner_grid_height, (int)store.getInt("erd.grid.height"), (int)5, (int)Short.MAX_VALUE);
    }

    private void createPrintGroup(DBPPreferenceStore store, Composite composite) {
        Group printGroup = UIUtils.createControlGroup((Composite)composite, (String)ERDUIMessages.pref_page_erd_group_print, (int)2, (int)0, (int)0);
        this.modeCombo = UIUtils.createLabelCombo((Composite)printGroup, (String)ERDUIMessages.pref_page_erd_combo_page_mode, (int)12);
        this.modeCombo.add(ERDUIMessages.pref_page_erd_item_tile);
        this.modeCombo.add(ERDUIMessages.pref_page_erd_item_fit_page);
        this.modeCombo.add(ERDUIMessages.pref_page_erd_item_fit_width);
        this.modeCombo.add(ERDUIMessages.pref_page_erd_item_fit_height);
        int modeIndex = 0;
        switch (store.getInt("erd.print.page-mode")) {
            case 2: {
                modeIndex = 1;
                break;
            }
            case 3: {
                modeIndex = 2;
                break;
            }
            case 4: {
                modeIndex = 3;
            }
        }
        this.modeCombo.select(modeIndex);
        this.spinnerMarginTop = UIUtils.createLabelSpinner((Composite)printGroup, (String)ERDUIMessages.pref_page_erd_spinner_margin_top, (int)store.getInt("erd.print.margin-top"), (int)0, (int)Short.MAX_VALUE);
        this.spinnerMarginBottom = UIUtils.createLabelSpinner((Composite)printGroup, (String)ERDUIMessages.pref_page_erd_spinner_margin_bottom, (int)store.getInt("erd.print.margin-bottom"), (int)0, (int)Short.MAX_VALUE);
        this.spinnerMarginLeft = UIUtils.createLabelSpinner((Composite)printGroup, (String)ERDUIMessages.pref_page_erd_spinner_margin_left, (int)store.getInt("erd.print.margin-left"), (int)0, (int)Short.MAX_VALUE);
        this.spinnerMarginRight = UIUtils.createLabelSpinner((Composite)printGroup, (String)ERDUIMessages.pref_page_erd_spinner_margin_right, (int)store.getInt("erd.print.margin-right"), (int)0, (int)Short.MAX_VALUE);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.contentsShowViews.setSelection(store.getDefaultBoolean("erd.diagram.show.views"));
        this.contentsShowPartitions.setSelection(store.getDefaultBoolean("erd.diagram.show.partitions"));
        this.routingType.setText(store.getDefaultString("erd.routing.type"));
        ERDNotationRegistry registry = ERDNotationRegistry.getInstance();
        this.notationType.select(registry.getERDNotations().indexOf((Object)registry.getDefaultNotation()));
        this.changeBorderColors.setSelection(store.getDefaultBoolean("erd.diagram.change.borders.colors"));
        this.changeHeaderColors.setSelection(store.getDefaultBoolean("erd.diagram.change.header.colors"));
        this.gridCheck.setSelection(store.getDefaultBoolean("erd.grid.enabled"));
        this.snapCheck.setSelection(store.getDefaultBoolean("erd.grid.snap"));
        this.spinnerGridWidth.setSelection(store.getDefaultInt("erd.grid.width"));
        this.spinnerGridHeight.setSelection(store.getDefaultInt("erd.grid.height"));
        this.modeCombo.select(1);
        this.spinnerMarginTop.setSelection(0);
        this.spinnerMarginBottom.setSelection(0);
        this.spinnerMarginLeft.setSelection(0);
        this.spinnerMarginRight.setSelection(0);
        if (this.visibilityButtons.size() > 0) {
            this.visibilityButtons.get(0).setSelection(true);
        }
        if (this.styleButtons.size() > 0) {
            for (Button styleButton : this.styleButtons) {
                styleButton.setSelection(false);
            }
            this.styleButtons.get(0).setSelection(true);
        }
        super.performDefaults();
    }

    public boolean performOk() {
        DBPPreferenceStore store = ERDUIActivator.getDefault().getPreferences();
        store.setValue("erd.diagram.show.views", this.contentsShowViews.getSelection());
        store.setValue("erd.diagram.show.partitions", this.contentsShowPartitions.getSelection());
        store.setValue("erd.routing.type", this.routingType.getText());
        ERDNotationDescriptor erdNotation = ERDNotationRegistry.getInstance().getERDNotationByName(this.notationType.getText());
        if (erdNotation != null) {
            store.setValue("erd.notation.type", erdNotation.getId());
        }
        store.setValue("erd.diagram.change.borders.colors", this.changeBorderColors.getSelection());
        store.setValue("erd.diagram.change.header.colors", this.changeHeaderColors.getSelection());
        store.setValue("erd.grid.enabled", this.gridCheck.getSelection());
        store.setValue("erd.grid.snap", this.snapCheck.getSelection());
        store.setValue("erd.grid.width", this.spinnerGridWidth.getSelection());
        store.setValue("erd.grid.height", this.spinnerGridHeight.getSelection());
        store.setValue("erd.print.page-mode", switch (this.modeCombo.getSelectionIndex()) {
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> 4;
            default -> 1;
        });
        store.setValue("erd.print.margin-top", this.spinnerMarginTop.getSelection());
        store.setValue("erd.print.margin-bottom", this.spinnerMarginBottom.getSelection());
        store.setValue("erd.print.margin-left", this.spinnerMarginLeft.getSelection());
        store.setValue("erd.print.margin-right", this.spinnerMarginRight.getSelection());
        for (Button radio : this.visibilityButtons) {
            if (!radio.getSelection()) continue;
            ERDAttributeVisibility.setDefaultVisibility((DBPPreferenceStore)store, (ERDAttributeVisibility)((ERDAttributeVisibility)radio.getData()));
            break;
        }
        ArrayList<ERDViewStyle> enabledStyles = new ArrayList<ERDViewStyle>();
        for (Button check : this.styleButtons) {
            if (!check.getSelection()) continue;
            enabledStyles.add((ERDViewStyle)((Object)check.getData()));
        }
        ERDViewStyle.setDefaultStyles(store, enabledStyles.toArray(new ERDViewStyle[enabledStyles.size()]));
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return true;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }
}

