/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oceanbase.model.plan;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.oceanbase.model.plan.OceanbasePlanJSON;
import org.jkiss.dbeaver.ext.oceanbase.model.plan.OceanbasePlanNodeJSON;
import org.jkiss.dbeaver.ext.oceanbase.mysql.model.OceanbaseMySQLDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerSerialInfo;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanSerializer;
import org.jkiss.dbeaver.model.impl.plan.ExecutionPlanDeserializer;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;

public class OceanbasePlanAnalyzer
extends AbstractExecutionPlanSerializer
implements DBCQueryPlanner {
    private final OceanbaseMySQLDataSource dataSource;

    public OceanbasePlanAnalyzer(OceanbaseMySQLDataSource dataSource) {
        this.dataSource = dataSource;
    }

    private static OceanbasePlanJSON explain(JDBCSession session, String query) throws DBCException {
        String plainQuery;
        SQLDialect dialect = SQLUtils.getDialectFromObject((DBPObject)session.getDataSource());
        String firstKeyword = SQLUtils.getFirstKeyword((SQLDialect)dialect, (String)(plainQuery = SQLUtils.stripComments((SQLDialect)dialect, (String)query).toUpperCase()));
        if (!"SELECT".equalsIgnoreCase(firstKeyword) && !"WITH".equalsIgnoreCase(firstKeyword)) {
            throw new DBCException("Only SELECT statements could produce execution plan");
        }
        return new OceanbasePlanJSON(session, query);
    }

    public void serialize(@NotNull Writer planData, @NotNull DBCPlan plan) throws IOException {
        this.serializeJson(planData, plan, this.dataSource.getInfo().getDriverName(), new DBCQueryPlannerSerialInfo(){

            public String version() {
                return "json";
            }

            public void addNodeProperties(DBCPlanNode node, JsonObject nodeJson) {
                JsonObject attributes = new JsonObject();
                OceanbasePlanNodeJSON jsNode = (OceanbasePlanNodeJSON)node;
                for (Map.Entry<String, String> e : jsNode.getNodeProps().entrySet()) {
                    attributes.add(e.getKey(), (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)e.getValue())));
                }
                nodeJson.add("attributes", (JsonElement)attributes);
            }
        });
    }

    public DBCPlan deserialize(@NotNull Reader planData) throws InvocationTargetException {
        JsonObject jo = new JsonParser().parse(planData).getAsJsonObject();
        String query = this.getQuery(jo);
        ExecutionPlanDeserializer loader = new ExecutionPlanDeserializer();
        List rootNodes = loader.loadRoot((DBPDataSource)this.dataSource, jo, (datasource, node, parent) -> new OceanbasePlanNodeJSON((OceanbasePlanNodeJSON)parent, OceanbasePlanAnalyzer.getNodeAttributes(node)));
        return new OceanbasePlanJSON(this.dataSource, query, rootNodes);
    }

    private static Map<String, String> getNodeAttributes(JsonObject nodeObject) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        JsonObject attrs = nodeObject.getAsJsonObject("attributes");
        for (Map.Entry attr : attrs.entrySet()) {
            attributes.put((String)attr.getKey(), ((JsonElement)attr.getValue()).getAsString());
        }
        return attributes;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBCException {
        return OceanbasePlanAnalyzer.explain((JDBCSession)session, query);
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }
}

