/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common.grammar;

import java.util.regex.Pattern;
import org.jkiss.dbeaver.parser.common.grammar.ExpressionVisitor;
import org.jkiss.dbeaver.parser.common.grammar.TerminalExpression;

public class RegexExpression
extends TerminalExpression {
    private static final Pattern _regexEscapeCharsPattern = Pattern.compile("([\\\\\\.\\?\\!\\[\\]\\{\\}\\(\\)\\<\\>\\*\\+\\-\\=\\^\\$\\|])");

    public RegexExpression(String pattern) {
        super(pattern);
    }

    public RegexExpression(String tag, String pattern) {
        super(tag, pattern);
    }

    @Override
    protected <T, R> R applyImpl(ExpressionVisitor<T, R> visitor, T arg) {
        return visitor.visitRegex(this, arg);
    }

    public static String escapeSpecialChars(String str) {
        return str == null || str.length() == 0 ? "" : _regexEscapeCharsPattern.matcher(str).replaceAll("\\\\$0");
    }
}

