/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIFonts;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.controls.StyledTextUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;

public class SQLEditorOutputConsoleViewer
extends TextConsoleViewer {
    private MessageConsole console;
    private boolean hasNewOutput;
    private PrintWriter writer;

    public SQLEditorOutputConsoleViewer(IWorkbenchPartSite site, Composite parent, int styles) {
        this(site, parent, new MessageConsole("sql-output", null));
    }

    protected SQLEditorOutputConsoleViewer(IWorkbenchPartSite site, Composite parent, MessageConsole console) {
        super(parent, (TextConsole)console);
        this.console = console;
        this.getText().setMargins(5, 5, 5, 5);
        this.console.setWaterMarks(0xA00000, 0x1400000);
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)site, (Control)this.getText());
        this.setEditable(false);
        this.createContextMenu();
        this.refreshStyles();
        IOConsoleOutputStream consoleOutputStream = console.newOutputStream();
        OutputStream out = new OutputStream((OutputStream)consoleOutputStream){
            private final /* synthetic */ OutputStream val$consoleOutputStream;
            {
                this.val$consoleOutputStream = outputStream;
            }

            @Override
            public void write(byte[] buf, int off, int len) throws IOException {
                this.val$consoleOutputStream.write(buf, off, len);
                SQLEditorOutputConsoleViewer.this.hasNewOutput = true;
            }

            @Override
            public void flush() throws IOException {
                this.val$consoleOutputStream.flush();
            }

            @Override
            public void close() throws IOException {
                this.val$consoleOutputStream.flush();
            }

            @Override
            public void write(int b) throws IOException {
                this.val$consoleOutputStream.write(b);
            }
        };
        this.writer = new PrintWriter(out, true);
    }

    public void dispose() {
        this.getControl().dispose();
    }

    public boolean isDisposed() {
        return this.getControl().isDisposed();
    }

    public PrintWriter getOutputWriter() {
        return this.writer;
    }

    @NotNull
    public MessageConsole getConsole() {
        return this.console;
    }

    public void scrollToEnd() {
        this.revealEndOfDocument();
    }

    public boolean isVisible() {
        return this.getControl().getVisible();
    }

    public void resetNewOutput() {
        this.hasNewOutput = false;
    }

    public void clearOutput() {
        this.console.clearConsole();
    }

    public void refreshStyles() {
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        Font outputFont = currentTheme.getFontRegistry().get(UIFonts.DBEAVER_FONTS_MONOSPACE);
        if (outputFont != null) {
            this.getTextWidget().setFont(outputFont);
        }
        this.getTextWidget().setForeground(UIStyles.getDefaultTextForeground());
        this.getTextWidget().setBackground(UIStyles.getDefaultTextBackground());
    }

    public StyledText getText() {
        return this.getTextWidget();
    }

    public boolean isHasNewOutput() {
        return this.hasNewOutput;
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> {
            StyledTextUtils.fillDefaultStyledTextContextMenu((IContributionManager)manager, (StyledText)this.getTextWidget());
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action(SQLEditorMessages.sql_editor_action_clear){

                public void run() {
                    SQLEditorOutputConsoleViewer.this.clearOutput();
                }
            });
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.getTextWidget().setMenu(menuMgr.createContextMenu((Control)this.getTextWidget()));
        this.getTextWidget().addDisposeListener(e -> menuMgr.dispose());
    }
}

