/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.data.gis.handlers.WKGUtils;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.gis.GisAttribute;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

public class PostgreGeometryValueHandler
extends JDBCAbstractValueHandler {
    public static final PostgreGeometryValueHandler INSTANCE = new PostgreGeometryValueHandler();
    private static final Log log = Log.getLog(PostgreGeometryValueHandler.class);

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        try {
            Object object = resultSet.getObject(index);
            return this.getValueFromObject(session, type, object, false, false);
        }
        catch (SQLException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                String wkbValue = resultSet.getString(index);
                return WKGUtils.parseWKB((String)wkbValue);
            }
            throw e;
        }
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        int valueSRID = 0;
        if (paramType instanceof DBDAttributeBinding) {
            paramType = ((DBDAttributeBinding)paramType).getAttribute();
        }
        if (value instanceof DBGeometry) {
            valueSRID = ((DBGeometry)value).getSRID();
            value = ((DBGeometry)value).getRawValue();
        }
        if (valueSRID == 0 && paramType instanceof GisAttribute) {
            valueSRID = ((GisAttribute)paramType).getAttributeGeometrySRID(session.getProgressMonitor());
        }
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else if (value instanceof Geometry) {
            if (((Geometry)value).getSRID() == 0) {
                ((Geometry)value).setSRID(valueSRID);
            }
            statement.setObject(paramIndex, (Object)this.getStringFromGeometry(session, (Geometry)value), 1111);
        } else if (value.getClass().getName().equals("org.postgis.PGgeometry")) {
            statement.setObject(paramIndex, value, 1111);
        } else {
            String strValue = value.toString();
            if (valueSRID != 0 && !strValue.startsWith("SRID=")) {
                strValue = "SRID=" + valueSRID + ";" + strValue;
            }
            statement.setObject(paramIndex, (Object)strValue, 1111);
        }
    }

    @NotNull
    public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBGeometry.class;
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return new DBGeometry();
        }
        if (object instanceof DBGeometry) {
            if (copy) {
                return ((DBGeometry)object).copy();
            }
            return object;
        }
        if (object instanceof Geometry) {
            return new DBGeometry((Geometry)object);
        }
        if (object instanceof String) {
            return this.makeGeometryFromWKT(session, (String)object);
        }
        if (object.getClass().getName().equals("org.postgis.PGgeometry")) {
            return this.makeGeometryFromPGGeometry(session, object);
        }
        if (PostgreUtils.isPGObject(object)) {
            return this.makeGeometryFromWKB(CommonUtils.toString((Object)PostgreUtils.extractPGObjectValue(object)));
        }
        return this.makeGeometryFromWKT(session, object.toString());
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof DBGeometry && format == DBDDisplayFormat.NATIVE) {
            int valueSRID = ((DBGeometry)value).getSRID();
            String strValue = value.toString();
            if (valueSRID != 0 && !strValue.startsWith("SRID=")) {
                strValue = "SRID=" + valueSRID + ";" + strValue;
            }
            return strValue;
        }
        return super.getValueDisplayString(column, value, format);
    }

    protected DBGeometry makeGeometryFromWKB(String hexString) throws DBCException {
        return this.makeGeometryFromWKB(WKBReader.hexToBytes((String)hexString));
    }

    protected DBGeometry makeGeometryFromWKB(byte[] binary) throws DBCException {
        try {
            return new DBGeometry(new WKBReader().read(binary));
        }
        catch (ParseException e) {
            throw new DBCException("Error parsing WKB value", (Throwable)e);
        }
    }

    private DBGeometry makeGeometryFromPGGeometry(DBCSession session, Object value) throws DBCException {
        try {
            Object geometry = BeanUtils.invokeObjectMethod((Object)value, (String)"getGeometry");
            try {
                String type = (String)BeanUtils.invokeObjectMethod((Object)geometry, (String)"getTypeString");
                boolean is3D = (Integer)BeanUtils.invokeObjectMethod((Object)geometry, (String)"getDimension") > 2;
                boolean isMeasured = (Boolean)BeanUtils.invokeObjectMethod((Object)geometry, (String)"isMeasured");
                int srid = (Integer)BeanUtils.invokeObjectMethod((Object)geometry, (String)"getSrid");
                StringBuffer sb = new StringBuffer(type);
                if (is3D) {
                    sb.append('Z');
                }
                if (isMeasured) {
                    sb.append('M');
                }
                BeanUtils.invokeObjectDeclaredMethod((Object)geometry, (String)"mediumWKT", (Class[])new Class[]{StringBuffer.class}, (Object[])new Object[]{sb});
                Geometry result = new WKTReader().read(sb.toString());
                result.setSRID(srid);
                return new DBGeometry(result);
            }
            catch (Throwable e) {
                log.error((Object)"Error reading geometry from PGGeometry", e);
                return this.makeGeometryFromWKT(session, geometry.toString());
            }
        }
        catch (Throwable e) {
            throw new DBCException(e, session.getExecutionContext());
        }
    }

    protected DBGeometry makeGeometryFromWKT(DBCSession session, String pgString) throws DBCException {
        int srid;
        String geometry;
        if (CommonUtils.isEmpty((String)pgString)) {
            return new DBGeometry();
        }
        if (pgString.startsWith("SRID=") && pgString.indexOf(59) > 5) {
            int index = pgString.indexOf(59);
            geometry = pgString.substring(index + 1);
            srid = CommonUtils.toInt((Object)pgString.substring(5, index));
        } else {
            geometry = pgString;
            srid = 0;
        }
        try {
            Geometry result = new WKTReader().read(geometry);
            result.setSRID(srid);
            return new DBGeometry(result);
        }
        catch (Throwable throwable) {
            return this.makeGeometryFromWKB(geometry);
        }
    }

    private String getStringFromGeometry(JDBCSession session, Geometry geometry) throws DBCException {
        String strGeom = new WKTWriter(4).write(geometry);
        if (geometry.getSRID() > 0) {
            return "SRID=" + geometry.getSRID() + ";" + strGeom;
        }
        return strGeom;
    }
}

