/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreDataSourceProvider;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCharset;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCopyLoader;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSourceInfo;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDialect;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreExecutionContext;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerOutputReader;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSetting;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreStructureAssistant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.ext.postgresql.model.PostgresUserPasswordManager;
import org.jkiss.dbeaver.ext.postgresql.model.QueryTransformerFetchAll;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerPostgreSQL;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerType;
import org.jkiss.dbeaver.ext.postgresql.model.jdbc.PostgreJdbcFactory;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgreQueryPlaner;
import org.jkiss.dbeaver.ext.postgresql.model.session.PostgreSessionManager;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCFactory;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.output.DBCServerOutputReader;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.app.DefaultCertificateStorage;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCURL;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.struct.DBSDataBulkLoader;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSInstanceContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.SimpleObjectCache;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.net.DefaultCallbackHandler;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreDataSource
extends JDBCDataSource
implements DBSInstanceContainer,
IAdaptable,
DBPObjectStatisticsCollector {
    private static final Log log = Log.getLog(PostgreDataSource.class);
    private static final PostgrePrivilegeType[] SUPPORTED_PRIVILEGE_TYPES = new PostgrePrivilegeType[]{PostgrePrivilegeType.SELECT, PostgrePrivilegeType.INSERT, PostgrePrivilegeType.UPDATE, PostgrePrivilegeType.DELETE, PostgrePrivilegeType.TRUNCATE, PostgrePrivilegeType.REFERENCES, PostgrePrivilegeType.TRIGGER, PostgrePrivilegeType.CREATE, PostgrePrivilegeType.CONNECT, PostgrePrivilegeType.TEMPORARY, PostgrePrivilegeType.EXECUTE, PostgrePrivilegeType.USAGE};
    private DatabaseCache databaseCache;
    private SettingCache settingCache;
    private String activeDatabaseName;
    private PostgreServerExtension serverExtension;
    private String serverVersion;
    private volatile boolean hasStatistics;
    private final Pattern ERROR_POSITION_PATTERN = Pattern.compile("\\n\\s*\\p{L}+\\s*: ([0-9]+)");

    public PostgreDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new PostgreDialect());
        this.hasStatistics = !CommonUtils.getBoolean((String)container.getConnectionConfiguration().getProviderProperty("show-database-statistics"));
    }

    public PostgreDataSource(DBPDataSourceContainer container, String serverVersion, String activeDatabaseName) {
        super(container, (SQLDialect)new PostgreDialect());
        this.serverVersion = serverVersion;
        this.activeDatabaseName = activeDatabaseName;
        this.hasStatistics = false;
        this.databaseCache = new DatabaseCache();
        PostgreDatabase defDatabase = new PostgreDatabase(this, activeDatabaseName);
        this.databaseCache.setCache(Collections.singletonList(defDatabase));
        this.settingCache = new SettingCache();
    }

    public Object getDataSourceFeature(String featureId) {
        switch (featureId) {
            case "datasource.max-string-type-length": {
                return 0xA00000;
            }
            case "datasource.lob-require-transactions": {
                return true;
            }
        }
        return super.getDataSourceFeature(featureId);
    }

    protected void initializeRemoteInstance(@NotNull DBRProgressMonitor monitor) throws DBException {
        DBPConnectionConfiguration configuration = this.getContainer().getActualConnectionConfiguration();
        if (configuration.getConfigurationType() == DBPDriverConfigurationType.MANUAL) {
            this.activeDatabaseName = configuration.getBootstrap().getDefaultCatalogName();
            if (CommonUtils.isEmpty((String)this.activeDatabaseName)) {
                this.activeDatabaseName = configuration.getDatabaseName();
            }
        } else {
            String url = configuration.getUrl();
            int divPos = url.lastIndexOf(47);
            if (divPos > 0) {
                int lastPos = -1;
                int i = divPos + 1;
                while (i < url.length()) {
                    char c = url.charAt(i);
                    if (!Character.isLetterOrDigit(c) && c != '_' && c != '$' && c != '.') {
                        lastPos = i;
                    }
                    ++i;
                }
                if (lastPos < 0) {
                    lastPos = url.length();
                }
                this.activeDatabaseName = url.substring(divPos + 1, lastPos);
            }
        }
        if (CommonUtils.isEmpty((String)this.activeDatabaseName)) {
            this.activeDatabaseName = "postgres";
        }
        this.databaseCache = new DatabaseCache();
        this.settingCache = new SettingCache();
        boolean showNDD = this.isReadDatabaseList(configuration);
        ArrayList<PostgreDatabase> dbList = new ArrayList<PostgreDatabase>();
        if (!showNDD) {
            PostgreDatabase defDatabase = this.createDatabaseImpl(monitor, this.activeDatabaseName);
            dbList.add(defDatabase);
        } else {
            this.loadAvailableDatabases(monitor, configuration, dbList);
        }
        this.databaseCache.setCache(dbList);
        this.getDefaultInstance().checkInstanceConnection(monitor, false);
        try {
            this.settingCache.getAllObjects(monitor, (DBSObject)this);
        }
        catch (DBException dBException) {}
    }

    private void loadAvailableDatabases(@NotNull DBRProgressMonitor monitor, DBPConnectionConfiguration configuration, List<PostgreDatabase> dbList) throws DBException {
        block53: {
            DBExecUtils.startContextInitiation((DBPDataSourceContainer)this.getContainer());
            try {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (Connection bootstrapConnection = this.openConnection(monitor, null, "Read PostgreSQL database list");){
                        Object var11_20;
                        Throwable throwable2;
                        this.readDatabaseServerVersion(bootstrapConnection.getMetaData());
                        Throwable throwable3 = null;
                        Object var8_13 = null;
                        try (PreparedStatement dbStat = this.prepareReadDatabaseListStatement(monitor, bootstrapConnection, configuration);){
                            throwable2 = null;
                            var11_20 = null;
                            try (ResultSet dbResult = dbStat.executeQuery();){
                                while (dbResult.next()) {
                                    PostgreDatabase database = this.createDatabaseImpl(monitor, dbResult);
                                    dbList.add(database);
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                            } else if (throwable3 != throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            throw throwable3;
                        }
                        if (this.activeDatabaseName != null) break block53;
                        throwable3 = null;
                        var8_13 = null;
                        try (PreparedStatement stat = bootstrapConnection.prepareStatement("SELECT current_database()");){
                            throwable2 = null;
                            var11_20 = null;
                            try (ResultSet rs = stat.executeQuery();){
                                if (rs.next()) {
                                    this.activeDatabaseName = JDBCUtils.safeGetString((ResultSet)rs, (int)1);
                                }
                            }
                            catch (Throwable throwable6) {
                                if (throwable2 == null) {
                                    throwable2 = throwable6;
                                } else if (throwable2 != throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable7) {
                            if (throwable3 == null) {
                                throwable3 = throwable7;
                            } else if (throwable3 != throwable7) {
                                throwable3.addSuppressed(throwable7);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable8) {
                        if (throwable == null) {
                            throwable = throwable8;
                        } else if (throwable != throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBException("Can't connect ot remote PostgreSQL server", (Throwable)e);
                }
            }
            finally {
                DBExecUtils.finishContextInitiation((DBPDataSourceContainer)this.getContainer());
            }
        }
    }

    protected boolean isReadDatabaseList(DBPConnectionConfiguration configuration) {
        return configuration.getConfigurationType() != DBPDriverConfigurationType.URL && CommonUtils.getBoolean((String)configuration.getProviderProperty("@dbeaver-show-non-default-db@"), (boolean)false);
    }

    protected PreparedStatement prepareReadDatabaseListStatement(@NotNull DBRProgressMonitor monitor, @NotNull Connection bootstrapConnection, @NotNull DBPConnectionConfiguration configuration) throws SQLException {
        DBSObjectFilter catalogFilters = this.getContainer().getObjectFilter(PostgreDatabase.class, null, false);
        StringBuilder catalogQuery = new StringBuilder("SELECT db.oid,db.* FROM pg_catalog.pg_database db WHERE 1 = 1");
        boolean addExclusionName = false;
        String connectionDBName = this.getContainer().getConnectionConfiguration().getDatabaseName();
        boolean showTemplates = CommonUtils.toBoolean((Object)configuration.getProviderProperty("@dbeaver-show-template-db@"));
        boolean showUnavailable = CommonUtils.toBoolean((Object)configuration.getProviderProperty("@dbeaver-show-unavailable-db@"));
        if (!showUnavailable) {
            catalogQuery.append(" AND datallowconn");
        }
        if (!showTemplates) {
            catalogQuery.append(" AND NOT datistemplate ");
            if (!CommonUtils.isEmpty((String)connectionDBName)) {
                catalogQuery.append("OR db.datname =?");
                addExclusionName = true;
            }
        }
        if (catalogFilters != null) {
            JDBCUtils.appendFilterClause((StringBuilder)catalogQuery, (DBSObjectFilter)catalogFilters, (String)"datname", (boolean)false, (DBPDataSource)this);
        }
        catalogQuery.append("\nORDER BY db.datname");
        PreparedStatement dbStat = bootstrapConnection.prepareStatement(catalogQuery.toString());
        if (addExclusionName) {
            dbStat.setString(1, connectionDBName);
        }
        if (catalogFilters != null) {
            JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)(addExclusionName ? 2 : 1), (DBSObjectFilter)catalogFilters);
        }
        return dbStat;
    }

    @NotNull
    public PostgreDatabase createDatabaseImpl(@NotNull DBRProgressMonitor monitor, ResultSet dbResult) throws DBException {
        return new PostgreDatabase(monitor, this, dbResult);
    }

    @NotNull
    public PostgreDatabase createDatabaseImpl(@NotNull DBRProgressMonitor monitor, String name) throws DBException {
        return new PostgreDatabase(monitor, this, name);
    }

    @NotNull
    public PostgreDatabase createDatabaseImpl(DBRProgressMonitor monitor, String name, PostgreRole owner, String templateName, PostgreTablespace tablespace, PostgreCharset encoding) throws DBException {
        return new PostgreDatabase(monitor, this, name, owner, templateName, tablespace, encoding);
    }

    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(PostgreDataSourceProvider.getConnectionsProps());
        DBWHandlerConfiguration sslConfig = this.getContainer().getActualConnectionConfiguration().getHandler("postgre_ssl");
        if (sslConfig != null && sslConfig.isEnabled()) {
            try {
                boolean useProxy = sslConfig.getBooleanProperty("sslProxyServer");
                if (useProxy) {
                    this.initProxySSL(props, sslConfig);
                }
                this.initServerSSL(props, sslConfig);
            }
            catch (Exception e) {
                throw new DBCException("Error configuring SSL certificates", (Throwable)e);
            }
        } else {
            this.getServerType().initDefaultSSLConfig(connectionInfo, props);
        }
        PostgreServerType serverType = PostgreUtils.getServerType(this.getContainer().getDriver());
        if (serverType.turnOffPreparedStatements() && !CommonUtils.toBoolean((Object)this.getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-use-prepared-statements-db@"))) {
            props.put("prepareThreshold", "0");
        }
        if (this.getContainer().isConnectionReadOnly()) {
            props.put("readOnly", "true");
            props.put("readOnlyMode", "always");
        }
        return props;
    }

    private void initServerSSL(Map<String, String> props, DBWHandlerConfiguration sslConfig) throws DBException {
        String factoryProp;
        String modeProp;
        String clientCertProp;
        String rootCertProp;
        props.put("ssl", "true");
        if (!DBWorkbench.isDistributed()) {
            String keyCertProp;
            if (CommonUtils.isEmpty((String)sslConfig.getStringProperty("ssl.method"))) {
                rootCertProp = sslConfig.getStringProperty("rootCert");
                clientCertProp = sslConfig.getStringProperty("clientCert");
                keyCertProp = sslConfig.getStringProperty("clientKey");
            } else {
                rootCertProp = sslConfig.getStringProperty("ssl.ca.cert");
                clientCertProp = sslConfig.getStringProperty("ssl.client.cert");
                keyCertProp = sslConfig.getStringProperty("ssl.client.key");
            }
            if (!CommonUtils.isEmpty((String)rootCertProp)) {
                props.put("sslrootcert", rootCertProp);
            }
            if (!CommonUtils.isEmpty((String)clientCertProp)) {
                props.put("sslcert", clientCertProp);
            }
            if (!CommonUtils.isEmpty((String)keyCertProp)) {
                props.put("sslkey", keyCertProp);
            }
        } else {
            try {
                String keyCertProp;
                rootCertProp = sslConfig.getSecureProperty("ssl.ca.cert.value");
                if (!CommonUtils.isEmpty((String)rootCertProp)) {
                    props.put("sslrootcert", this.saveCertificateToFile(rootCertProp));
                }
                if (!CommonUtils.isEmpty((String)(clientCertProp = sslConfig.getSecureProperty("ssl.client.cert.value")))) {
                    props.put("sslcert", this.saveCertificateToFile(clientCertProp));
                }
                if (!CommonUtils.isEmpty((String)(keyCertProp = sslConfig.getSecureProperty("ssl.client.key.value")))) {
                    props.put("sslkey", this.saveCertificateToFile(keyCertProp));
                }
            }
            catch (IOException e) {
                throw new DBException("Can not configure SSL", (Throwable)e);
            }
        }
        if (!CommonUtils.isEmpty((String)(modeProp = sslConfig.getStringProperty("sslMode")))) {
            props.put("sslmode", modeProp);
        }
        if (!CommonUtils.isEmpty((String)(factoryProp = sslConfig.getStringProperty("sslFactory")))) {
            props.put("sslfactory", factoryProp);
        }
        props.put("sslpasswordcallback", DefaultCallbackHandler.class.getName());
    }

    private void initProxySSL(Map<String, String> props, DBWHandlerConfiguration sslConfig) {
    }

    protected PostgreExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) {
        return new PostgreExecutionContext((PostgreDatabase)instance, type);
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, @Nullable JDBCExecutionContext initFrom) throws DBException {
        PostgreExecutionContext postgreContext = (PostgreExecutionContext)context;
        PostgreSchema activeSchema = null;
        if (initFrom != null) {
            activeSchema = ((PostgreExecutionContext)initFrom).getDefaultSchema();
        }
        postgreContext.refreshDefaults(monitor, true);
        if (activeSchema != null) {
            postgreContext.setDefaultCatalog(monitor, activeSchema.getDatabase(), activeSchema, true);
        }
    }

    public DatabaseCache getDatabaseCache() {
        return this.databaseCache;
    }

    public List<PostgreDatabase> getDatabases() {
        return this.databaseCache.getCachedObjects();
    }

    public PostgreDatabase getDatabase(String name) {
        return (PostgreDatabase)this.databaseCache.getCachedObject(name);
    }

    public SettingCache getSettingCache() {
        return this.settingCache;
    }

    public Collection<PostgreSetting> getSettings() {
        return this.settingCache.getCachedObjects();
    }

    public PostgreSetting getSetting(String name) {
        return (PostgreSetting)this.settingCache.getCachedObject(name);
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Read server version");){
                this.serverVersion = JDBCUtils.queryString((Connection)session, (String)"SELECT version()", (Object[])new Object[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.debug((Object)("Error reading PostgreSQL version: " + e.getMessage()));
            this.serverVersion = "";
        }
        this.getDefaultInstance().cacheDataTypes(monitor, true);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.shutdown(monitor);
        this.databaseCache.clearCache();
        this.activeDatabaseName = null;
        this.initializeRemoteInstance(monitor);
        this.initialize(monitor);
        return this;
    }

    public List<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) {
        return this.getDatabases();
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) {
        return this.getDatabase(childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) {
        return PostgreDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.databaseCache.getAllObjects(monitor, (DBSObject)this);
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @Nullable JDBCExecutionContext context, @NotNull String purpose) throws DBCException {
        Connection pgConnection;
        block26: {
            JDBCRemoteInstance instance;
            DBPConnectionConfiguration conConfig = this.getContainer().getActualConnectionConfiguration();
            JDBCRemoteInstance jDBCRemoteInstance = instance = context == null ? null : context.getOwnerInstance();
            if (instance != null) {
                log.debug((Object)("Initiate connection to " + this.getServerType().getServerTypeName() + " database [" + instance.getName() + "@" + conConfig.getHostName() + "] for " + purpose));
            }
            try {
                if (conConfig.getConfigurationType() != DBPDriverConfigurationType.URL && instance instanceof PostgreDatabase && !CommonUtils.equalObjects((Object)instance.getName(), (Object)conConfig.getDatabaseName())) {
                    DBPConnectionConfiguration originalConfig = new DBPConnectionConfiguration(conConfig);
                    try {
                        if (CommonUtils.isEmpty((String)conConfig.getUrl()) || !CommonUtils.isEmpty((String)conConfig.getHostName())) {
                            conConfig.setDatabaseName(instance.getName());
                            DBPDriver driver = this.getContainer().getDriver();
                            String newURL = JDBCURL.generateUrlByTemplate((DBPDriver)driver, (DBPConnectionConfiguration)conConfig);
                            if (CommonUtils.isEmpty((String)newURL)) {
                                newURL = driver.getDataSourceProvider().getConnectionURL(driver, conConfig);
                            }
                            conConfig.setUrl(newURL);
                        }
                        pgConnection = super.openConnection(monitor, context, purpose);
                        break block26;
                    }
                    finally {
                        conConfig.setDatabaseName(originalConfig.getDatabaseName());
                        conConfig.setUrl(originalConfig.getUrl());
                    }
                }
                pgConnection = super.openConnection(monitor, context, purpose);
            }
            catch (DBCException e) {
                Throwable cause = GeneralUtils.getRootCause((Throwable)e);
                StackTraceElement element = cause.getStackTrace()[0];
                if ("sun.security.util.DerValue".equals(element.getClassName())) {
                    Path dst;
                    DBWHandlerConfiguration handler = Objects.requireNonNull(conConfig.getHandler("postgre_ssl"));
                    String key = handler.getStringProperty("ssl.client.key");
                    try {
                        dst = DBWorkbench.getPlatform().getTempFolder(monitor, "ssl").resolve(String.valueOf(this.container.getId()) + ".pk8");
                    }
                    catch (IOException ex) {
                        log.error((Object)"Error creating temporary SSL key", (Throwable)ex);
                        throw e;
                    }
                    try {
                        Throwable ex = null;
                        Object var14_22 = null;
                        try (BufferedReader reader = Files.newBufferedReader(Path.of(key, new String[0]));){
                            Files.write(dst, DefaultCertificateStorage.loadDerFromPem((Reader)reader), new OpenOption[0]);
                            handler.setProperty("ssl.client.key", (Object)dst.toAbsolutePath().toString());
                        }
                        catch (Throwable throwable) {
                            if (ex == null) {
                                ex = throwable;
                            } else if (ex != throwable) {
                                ex.addSuppressed(throwable);
                            }
                            throw ex;
                        }
                    }
                    catch (IOException ex) {
                        log.error((Object)"Error converting SSL key", (Throwable)ex);
                        throw e;
                    }
                    return this.openConnection(monitor, context, purpose);
                }
                throw e;
            }
        }
        if (this.getServerType().supportsClientInfo() && !this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            try {
                pgConnection.setClientInfo("ApplicationName", DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (DBCExecutionContext)context, (String)purpose));
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
        return pgConnection;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new PostgreStructureAssistant(this));
        }
        if (adapter == DBCServerOutputReader.class) {
            return adapter.cast((Object)new PostgreServerOutputReader());
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new PostgreSessionManager(this));
        }
        if (adapter == DBCQueryPlanner.class) {
            return adapter.cast((Object)new PostgreQueryPlaner(this));
        }
        if (adapter == DBSDataBulkLoader.class) {
            if (this.getServerType().supportsCopyFromStdIn()) {
                return adapter.cast(new PostgreCopyLoader(this));
            }
        } else if (adapter == DBAUserPasswordManager.class && this.getServerType().supportsAlterUserChangePassword()) {
            return adapter.cast(new PostgresUserPasswordManager(this));
        }
        return (T)super.getAdapter(adapter);
    }

    @Nullable
    public DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        DBSDataType dataType = super.resolveDataType(monitor, typeFullName);
        if (dataType != null) {
            return dataType;
        }
        return PostgreUtils.resolveTypeFullName(monitor, this, typeFullName);
    }

    public Collection<PostgreDataType> getLocalDataTypes() {
        return this.getDefaultInstance().getLocalDataTypes();
    }

    public PostgreDataType getLocalDataType(String typeName) {
        return this.getDefaultInstance().getLocalDataType(typeName);
    }

    public DBSDataType getLocalDataType(int typeID) {
        return this.getDefaultInstance().getLocalDataType(typeID);
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return this.getDefaultInstance().getDefaultDataTypeName(dataKind);
    }

    @NotNull
    public PostgreDatabase getDefaultInstance() {
        PostgreDatabase defDatabase = (PostgreDatabase)this.databaseCache.getCachedObject(this.activeDatabaseName);
        if (defDatabase == null) {
            defDatabase = (PostgreDatabase)this.databaseCache.getCachedObject("postgres");
        }
        if (defDatabase == null) {
            List allDatabases = this.databaseCache.getCachedObjects();
            if (allDatabases.isEmpty()) {
                throw new IllegalStateException("No databases found on the server");
            }
            defDatabase = (PostgreDatabase)allDatabases.get(0);
        }
        return defDatabase;
    }

    @NotNull
    public List<PostgreDatabase> getAvailableInstances() {
        return this.databaseCache.getCachedObjects();
    }

    void setActiveDatabase(PostgreDatabase newDatabase) {
        PostgreDatabase oldDatabase = this.getDefaultInstance();
        if (oldDatabase == newDatabase) {
            return;
        }
        this.activeDatabaseName = newDatabase.getName();
        DBUtils.fireObjectSelect((DBSObject)oldDatabase, (boolean)false);
        DBUtils.fireObjectSelect((DBSObject)newDatabase, (boolean)true);
    }

    @Deprecated
    public void setDefaultInstance(@NotNull DBRProgressMonitor monitor, @NotNull PostgreDatabase newDatabase, PostgreSchema schema) throws DBException {
        PostgreDatabase oldDatabase = this.getDefaultInstance();
        if (oldDatabase != newDatabase) {
            newDatabase.initializeMetaContext(monitor);
            newDatabase.cacheDataTypes(monitor, false);
        }
        PostgreSchema oldDefaultSchema = null;
        if (schema != null) {
            oldDefaultSchema = newDatabase.getMetaContext().getDefaultSchema();
            newDatabase.getMetaContext().changeDefaultSchema(monitor, schema, false, false);
        }
        this.activeDatabaseName = newDatabase.getName();
        DBUtils.fireObjectSelect((DBSObject)oldDatabase, (boolean)false);
        DBUtils.fireObjectSelect((DBSObject)newDatabase, (boolean)true);
        if (schema != null && schema != oldDefaultSchema) {
            if (oldDefaultSchema != null) {
                DBUtils.fireObjectSelect((DBSObject)oldDefaultSchema, (boolean)false);
            }
            DBUtils.fireObjectSelect((DBSObject)schema, (boolean)true);
        }
        oldDatabase.shutdown(monitor, true);
    }

    /*
     * Exception decompiling
     */
    public List<String> getTemplateDatabases(DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PostgreServerExtension getServerType() {
        if (this.serverExtension == null) {
            PostgreServerType serverType = PostgreUtils.getServerType(this.getContainer().getDriver());
            try {
                this.serverExtension = serverType.createServerExtension(this);
            }
            catch (Throwable e) {
                log.error((Object)"Can't determine server type", e);
                this.serverExtension = new PostgreServerPostgreSQL(this);
            }
        }
        return this.serverExtension;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public boolean supportsRoles() {
        return this.getServerType().supportsRoles() && !this.getContainer().getNavigatorSettings().isShowOnlyEntities() && !this.getContainer().getNavigatorSettings().isHideFolders();
    }

    @NotNull
    public PostgrePrivilegeType[] getSupportedPrivilegeTypes() {
        return SUPPORTED_PRIVILEGE_TYPES;
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        this.hasStatistics = true;
        if (!this.getServerType().supportsDatabaseSize()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load table status");){
                List<PostgreDatabase> databases = this.getDatabases();
                try {
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT db.datname,pg_database_size(db.oid) FROM pg_catalog.pg_database db " + (databases.size() == 1 ? "WHERE db.oid=?" : ""));){
                        if (databases.size() == 1) {
                            dbStat.setLong(1, ((PostgreDatabase)databases.iterator().next()).getObjectId());
                        }
                        Throwable throwable3 = null;
                        Object var12_18 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            while (dbResult.next()) {
                                String dbName = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                                long dbSize = dbResult.getLong(2);
                                PostgreDatabase database = this.getDatabase(dbName);
                                if (database == null) continue;
                                database.setDbTotalSize(dbSize);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        Matcher matcher;
        String message;
        Throwable rootCause = GeneralUtils.getRootCause((Throwable)error);
        if ("org.postgresql.util.PSQLException".equals(rootCause.getClass().getName())) {
            try {
                Object position;
                Object serverErrorMessage = BeanUtils.readObjectProperty((Object)rootCause, (String)"serverErrorMessage");
                if (serverErrorMessage != null && (position = BeanUtils.readObjectProperty((Object)serverErrorMessage, (String)"position")) instanceof Number) {
                    DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
                    pos.position = ((Number)position).intValue() - 1;
                    return new DBPErrorAssistant.ErrorPosition[]{pos};
                }
            }
            catch (Throwable throwable) {}
        }
        if (!CommonUtils.isEmpty((String)(message = error.getMessage())) && (matcher = this.ERROR_POSITION_PATTERN.matcher(message)).find()) {
            DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
            pos.position = Integer.parseInt(matcher.group(1)) - 1;
            return new DBPErrorAssistant.ErrorPosition[]{pos};
        }
        return null;
    }

    @NotNull
    protected JDBCFactory createJdbcFactory() {
        return new PostgreJdbcFactory();
    }

    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        DBPErrorAssistant.ErrorType errorType;
        String sqlState = SQLState.getStateFromException((Throwable)error);
        if (sqlState != null) {
            if ("57P01".equals(sqlState)) {
                return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
            }
            if ("25P02".equals(sqlState)) {
                return DBPErrorAssistant.ErrorType.TRANSACTION_ABORTED;
            }
        }
        if (this.getServerType() instanceof DBPErrorAssistant && (errorType = ((DBPErrorAssistant)this.getServerType()).discoverErrorType(error)) != null) {
            return errorType;
        }
        return super.discoverErrorType(error);
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        return new PostgreDataSourceInfo(this, metaData);
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false, true);
        }
        if (type == DBCQueryTransformType.FETCH_ALL_TABLE) {
            return new QueryTransformerFetchAll();
        }
        return null;
    }

    public boolean supportReadingAllDataTypes() {
        return CommonUtils.toBoolean((Object)this.getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-read-all-data-types-db@"));
    }

    public boolean supportsReadingKeysWithColumns() {
        return CommonUtils.toBoolean((Object)this.getContainer().getActualConnectionConfiguration().getProviderProperty("read-keys-with-columns"));
    }

    private static class DatabaseCache
    extends SimpleObjectCache<PostgreDataSource, PostgreDatabase> {
        private DatabaseCache() {
        }
    }

    static class SettingCache
    extends JDBCObjectLookupCache<PostgreDataSource, PostgreSetting> {
        SettingCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreDataSource owner, @Nullable PostgreSetting object, @Nullable String objectName) throws SQLException {
            if (object != null || objectName != null) {
                JDBCPreparedStatement dbStat = session.prepareStatement("select * from pg_catalog.pg_settings where name=?");
                dbStat.setString(1, object != null ? object.getName() : objectName);
                return dbStat;
            }
            return session.prepareStatement("select * from pg_catalog.pg_settings");
        }

        @Nullable
        protected PostgreSetting fetchObject(@NotNull JDBCSession session, @NotNull PostgreDataSource owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreSetting(owner, (ResultSet)dbResult);
        }
    }
}

