/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMetaObjectType;

public class QMMStatementInfo
extends QMMObject {
    private final QMMConnectionInfo connection;
    private final DBCExecutionPurpose purpose;
    private final transient QMMStatementInfo previous;
    private transient DBCStatement reference;

    public QMMStatementInfo(QMMConnectionInfo connection, DBCStatement reference, QMMStatementInfo previous) {
        super(QMMetaObjectType.STATEMENT_INFO);
        this.connection = connection;
        this.reference = reference;
        this.purpose = reference.getSession().getPurpose();
        this.previous = previous;
    }

    public QMMStatementInfo(long openTime, long closeTime, QMMConnectionInfo session, DBCExecutionPurpose purpose) {
        super(QMMetaObjectType.STATEMENT_INFO, openTime, closeTime);
        this.connection = session;
        this.purpose = purpose;
        this.previous = null;
    }

    private QMMStatementInfo(Builder builder) {
        super(QMMetaObjectType.STATEMENT_INFO, builder.openTime, builder.closeTime);
        this.connection = builder.connection;
        this.purpose = builder.purpose;
        this.previous = builder.previous;
        this.reference = builder.reference;
    }

    @Override
    public void close() {
        super.close();
        this.reference = null;
    }

    @Override
    public String getText() {
        return this.connection.getText();
    }

    @Override
    public QMMetaObjectType getObjectType() {
        return QMMetaObjectType.STATEMENT_INFO;
    }

    DBCStatement getReference() {
        return this.reference;
    }

    @Override
    public QMMConnectionInfo getConnection() {
        return this.connection;
    }

    public DBCExecutionPurpose getPurpose() {
        return this.purpose;
    }

    public QMMStatementInfo getPrevious() {
        return this.previous;
    }

    public String toString() {
        return "STATEMENT";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class Builder {
        private QMMConnectionInfo connection;
        private DBCExecutionPurpose purpose;
        private QMMStatementInfo previous;
        private DBCStatement reference;
        private long openTime;
        private long closeTime;

        public Builder() {
        }

        public Builder(QMMStatementInfo copy) {
            this.connection = copy.getConnection();
            this.purpose = copy.getPurpose();
            this.previous = copy.getPrevious();
            this.reference = copy.getReference();
        }

        public Builder setConnection(QMMConnectionInfo connection) {
            this.connection = connection;
            return this;
        }

        public Builder setPurpose(DBCExecutionPurpose purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder setPrevious(QMMStatementInfo previous) {
            this.previous = previous;
            return this;
        }

        public Builder setReference(DBCStatement reference) {
            this.reference = reference;
            return this;
        }

        public Builder setOpenTime(long openTime) {
            this.openTime = openTime;
            return this;
        }

        public Builder setCloseTime(long closeTime) {
            this.closeTime = closeTime;
            return this;
        }

        public QMMStatementInfo build() {
            return new QMMStatementInfo(this);
        }
    }
}

