/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMetaObjectType;

public abstract class QMMObject {
    static final Log log = Log.getLog(QMMObject.class);
    private static int globalObjectId = 0;
    private final int id;
    private final long objectId;
    private final long openTime;
    private long closeTime;
    private boolean synced;
    private boolean updated;

    public QMMObject(QMMetaObjectType type) {
        this.id = type.getId();
        this.objectId = QMMObject.generateObjectId();
        this.openTime = QMMObject.getTimeStamp();
    }

    protected QMMObject(QMMetaObjectType type, long openTime, long closeTime) {
        this.id = type.getId();
        this.objectId = QMMObject.generateObjectId();
        this.openTime = openTime;
        this.closeTime = closeTime;
    }

    protected void close() {
        this.closeTime = QMMObject.getTimeStamp();
        this.update();
    }

    protected void reopen() {
        this.closeTime = 0L;
        this.update();
    }

    public long getObjectId() {
        return this.objectId;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public long getCloseTime() {
        return this.closeTime;
    }

    public boolean isClosed() {
        return this.closeTime > 0L;
    }

    public abstract String getText();

    public abstract QMMetaObjectType getObjectType();

    protected synchronized void update() {
        this.updated = true;
    }

    protected synchronized void sync() {
        this.synced = true;
        this.updated = false;
    }

    private static synchronized long generateObjectId() {
        return ++globalObjectId;
    }

    protected static long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public long getDuration() {
        if (!this.isClosed()) {
            return -1L;
        }
        return this.getCloseTime() - this.getOpenTime();
    }

    public int getId() {
        return this.id;
    }

    public abstract QMMConnectionInfo getConnection();
}

