/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCComposite;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class JDBCCompositeDynamic
extends JDBCComposite {
    private static final Log log = Log.getLog(JDBCCompositeDynamic.class);

    public JDBCCompositeDynamic(@NotNull JDBCComposite struct, @NotNull DBRProgressMonitor monitor) throws DBCException {
        super(monitor, struct);
    }

    public JDBCCompositeDynamic(@NotNull DBCSession session, @Nullable Struct contents, @Nullable ResultSetMetaData metaData) throws DBCException {
        super(contents);
        this.type = new JDBCComposite.StructType(this, session.getDataSource());
        try {
            Object[] attrValues;
            Object[] objectArray = attrValues = contents == null ? null : contents.getAttributes();
            if (attrValues != null) {
                this.attributes = new DBSEntityAttribute[attrValues.length];
                this.values = new Object[attrValues.length];
                if (metaData != null) {
                    int attrCount = metaData.getColumnCount();
                    if (attrCount != attrValues.length) {
                        log.warn("Meta column count (" + attrCount + ") differs from value count (" + attrValues.length + ")");
                        attrCount = Math.min(attrCount, attrValues.length);
                    }
                    int i = 0;
                    while (i < attrCount) {
                        Object value = attrValues[i];
                        JDBCComposite.StructAttribute attr = new JDBCComposite.StructAttribute(this.type, metaData, i);
                        value = DBUtils.findValueHandler(session, (DBSTypedObject)attr).getValueFromObject(session, attr, value, false, this.modified);
                        this.attributes[i] = attr;
                        this.values[i] = value;
                        ++i;
                    }
                } else {
                    log.warn("Data type '" + contents.getSQLTypeName() + "' isn't resolved as structured type. Use synthetic attributes.");
                    int i = 0;
                    int attrValuesLength = attrValues.length;
                    while (i < attrValuesLength) {
                        Object value = attrValues[i];
                        JDBCComposite.StructAttribute attr = new JDBCComposite.StructAttribute(this.type, i, value);
                        value = DBUtils.findValueHandler(session, (DBSTypedObject)attr).getValueFromObject(session, attr, value, false, this.modified);
                        this.attributes[i] = attr;
                        this.values[i] = value;
                        ++i;
                    }
                }
            } else {
                this.attributes = EMPTY_ATTRIBUTE;
                this.values = EMPTY_VALUES;
            }
        }
        catch (DBException e) {
            throw new DBCException("Can't obtain attributes meta information", e);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    @Override
    public DBSDataType getDataType() {
        return this.type;
    }

    @Override
    public JDBCCompositeDynamic cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return new JDBCCompositeDynamic(this, monitor);
    }
}

