/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.formatters;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.time.ExtendedDateFormat;

public class DateTimeDataFormatter
implements DBDDataFormatter {
    public static final String PROP_PATTERN = "pattern";
    public static final String PROP_TIMEZONE = "timezone";
    private String pattern;
    private ZoneId zone;
    private DateFormat dateFormat;
    private StringBuffer buffer;
    private FieldPosition position;
    private DateTimeFormatter dateTimeFormatter;

    @Override
    public void init(DBSTypedObject type, Locale locale, Map<String, Object> properties) {
        this.pattern = CommonUtils.toString((Object)properties.get(PROP_PATTERN));
        String timezone = CommonUtils.toString((Object)properties.get(PROP_TIMEZONE));
        this.zone = CommonUtils.isEmptyTrimmed((String)timezone) ? null : ZoneId.of(timezone);
        String sdfPattern = this.pattern.replace("n", "f");
        this.dateFormat = new ExtendedDateFormat(sdfPattern, locale);
        this.dateFormat.setLenient(false);
        this.buffer = new StringBuffer();
        this.position = new FieldPosition(0);
        String java8DatePattern = this.pattern.replaceAll("f+", "n");
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(java8DatePattern);
    }

    @Nullable
    public ZoneId getZone() {
        return this.zone;
    }

    @NotNull
    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String formatValue(Object value) {
        if (value instanceof Date && this.zone != null) {
            return this.dateTimeFormatter.format(ZonedDateTime.ofInstant(((Date)value).toInstant(), this.zone));
        }
        if (value instanceof TemporalAccessor) {
            if (this.zone != null) {
                if (value instanceof LocalDateTime) {
                    return this.dateTimeFormatter.format(((LocalDateTime)value).atZone(this.zone));
                }
                if (value instanceof ZonedDateTime) {
                    return this.dateTimeFormatter.format(((ZonedDateTime)value).withZoneSameInstant(this.zone));
                }
                if (value instanceof OffsetDateTime) {
                    return this.dateTimeFormatter.format(((OffsetDateTime)value).atZoneSameInstant(this.zone));
                }
            }
            return this.dateTimeFormatter.format((TemporalAccessor)value);
        }
        DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            this.buffer.setLength(0);
            return value == null ? null : this.dateFormat.format(value, this.buffer, this.position).toString();
        }
    }

    @Override
    public Object parseValue(String value, Class<?> typeHint) throws ParseException {
        if (typeHint != null && TemporalAccessor.class.isAssignableFrom(typeHint)) {
            try {
                return LocalDateTime.parse(value, this.dateTimeFormatter);
            }
            catch (DateTimeParseException e) {
                throw new ParseException(e.getParsedString(), e.getErrorIndex());
            }
        }
        return this.dateFormat.parse(value);
    }
}

