/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLGrant;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPrivilege;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomCheckboxCellEditor;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PrivilegeTableControl
extends Composite {
    private boolean isStatic;
    private TableViewer tableViewer;
    private ViewerColumnController<Object, Object> columnsController;
    private Table privTable;
    private List<MySQLPrivilege> privileges;
    private List<MySQLObjectPrivilege> currentPrivileges = new ArrayList<MySQLObjectPrivilege>();

    public PrivilegeTableControl(Composite parent, String title, boolean isStatic) {
        super(parent, 0);
        this.isStatic = isStatic;
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this.setLayout((Layout)gl);
        Group privsGroup = UIUtils.createControlGroup((Composite)this, (String)title, (int)1, (int)1808, (int)0);
        GridData gd = (GridData)privsGroup.getLayoutData();
        gd.horizontalSpan = 2;
        this.tableViewer = new TableViewer((Composite)privsGroup, 68352);
        this.privTable = this.tableViewer.getTable();
        this.privTable.setHeaderVisible(true);
        this.privTable.setLinesVisible(true);
        gd = new GridData(1808);
        gd.minimumWidth = 300;
        this.privTable.setLayoutData((Object)gd);
        this.columnsController = new ViewerColumnController("MySQLPrivilegesEditor", (ColumnViewer)this.tableViewer);
        this.columnsController.addColumn(MySQLUIMessages.controls_privilege_table_column_privilege_name, MySQLUIMessages.controls_privilege_table_column_privilege_name_tip, 16384, true, true, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof MySQLObjectPrivilege) {
                    cell.setText(((MySQLObjectPrivilege)element).privilege.getName());
                }
            }
        });
        this.columnsController.addBooleanColumn(MySQLUIMessages.controls_privilege_table_column_privilege_status, MySQLUIMessages.controls_privilege_table_column_privilege_status_tip, 0x1000000, true, true, item -> {
            if (item instanceof MySQLObjectPrivilege) {
                return ((MySQLObjectPrivilege)item).enabled;
            }
            return false;
        }, new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                return new CustomCheckboxCellEditor((Composite)PrivilegeTableControl.this.tableViewer.getTable(), true);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                if (element instanceof MySQLObjectPrivilege) {
                    return ((MySQLObjectPrivilege)element).enabled;
                }
                return false;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof MySQLObjectPrivilege) {
                    MySQLObjectPrivilege elementPriv = (MySQLObjectPrivilege)element;
                    if (elementPriv.enabled != Boolean.TRUE.equals(value)) {
                        elementPriv.enabled = Boolean.TRUE.equals(value);
                        boolean withGrantOption = false;
                        if (elementPriv.enabled && elementPriv.privilege.getName().equals("Grant option")) {
                            withGrantOption = true;
                        }
                        PrivilegeTableControl.this.notifyPrivilegeCheck(elementPriv.privilege, elementPriv.enabled, withGrantOption);
                    }
                }
            }
        });
        this.columnsController.addColumn(MySQLUIMessages.controls_privilege_table_column_privilege_description, MySQLUIMessages.controls_privilege_table_column_privilege_description_tip, 16384, true, true, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof MySQLObjectPrivilege) {
                    cell.setText(((MySQLObjectPrivilege)element).privilege.getDescription());
                }
            }
        });
        this.columnsController.createColumns(false);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        Composite buttonsPanel = UIUtils.createComposite((Composite)privsGroup, (int)3);
        buttonsPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createPushButton((Composite)buttonsPanel, (String)MySQLUIMessages.controls_privilege_table_push_button_check_all, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (MySQLObjectPrivilege userPrivilege : CommonUtils.safeCollection(PrivilegeTableControl.this.currentPrivileges)) {
                    if (userPrivilege.enabled) continue;
                    userPrivilege.enabled = true;
                    PrivilegeTableControl.this.notifyPrivilegeCheck(userPrivilege.privilege, true, false);
                }
                PrivilegeTableControl.this.drawColumns(PrivilegeTableControl.this.currentPrivileges);
            }
        });
        UIUtils.createPushButton((Composite)buttonsPanel, (String)MySQLUIMessages.controls_privilege_table_push_button_clear_all, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (MySQLObjectPrivilege userPrivilege : CommonUtils.safeCollection(PrivilegeTableControl.this.currentPrivileges)) {
                    if (!userPrivilege.enabled) continue;
                    userPrivilege.enabled = false;
                    PrivilegeTableControl.this.notifyPrivilegeCheck(userPrivilege.privilege, false, false);
                }
                PrivilegeTableControl.this.drawColumns(PrivilegeTableControl.this.currentPrivileges);
            }
        });
    }

    private void notifyPrivilegeCheck(MySQLPrivilege privilege, boolean checked, boolean withGrantOption) {
        Event event = new Event();
        event.detail = withGrantOption ? 2 : (checked ? 1 : 0);
        event.widget = this;
        event.data = privilege;
        super.notifyListeners(24, event);
    }

    public void fillPrivileges(List<MySQLPrivilege> privs) {
        this.privileges = privs;
        boolean hasGrantOption = false;
        for (MySQLPrivilege privilege : this.privileges) {
            if (!privilege.getName().equalsIgnoreCase("Grant option")) continue;
            hasGrantOption = true;
            break;
        }
        if (!hasGrantOption) {
            MySQLDataSource dataSource = null;
            if (!CommonUtils.isEmpty(this.privileges)) {
                dataSource = (MySQLDataSource)this.privileges.get(0).getDataSource();
            }
            this.privileges.add(new MySQLPrivilege(dataSource, "Grant option", "Databases,Tables,Functions,Procedures", "To give to other users those privileges you possess", MySQLPrivilege.Kind.DDL));
        }
    }

    public void fillGrants(List<MySQLGrant> grants, boolean editable) {
        this.privTable.setEnabled(editable);
        this.fillGrants(grants);
    }

    public void fillGrants(List<MySQLGrant> grants) {
        if (CommonUtils.isEmpty(this.privileges)) {
            return;
        }
        this.currentPrivileges = new ArrayList<MySQLObjectPrivilege>();
        if (CommonUtils.isEmpty(grants)) {
            for (MySQLPrivilege privilege : this.privileges) {
                this.currentPrivileges.add(new MySQLObjectPrivilege(privilege, false));
            }
            this.drawColumns(this.currentPrivileges);
            return;
        }
        for (MySQLPrivilege privilege : this.privileges) {
            boolean privilegeEnabled = false;
            for (MySQLGrant grant : grants) {
                if (this.isStatic && !grant.isStatic()) continue;
                if (privilege.getName().equalsIgnoreCase("Grant option") && grant.isGrantOption()) {
                    privilegeEnabled = true;
                    break;
                }
                if (!grant.isAllPrivileges() && !ArrayUtils.contains((Object[])grant.getPrivileges(), (Object)privilege)) continue;
                privilegeEnabled = true;
                break;
            }
            if (privilegeEnabled) {
                this.currentPrivileges.add(new MySQLObjectPrivilege(privilege, true));
                continue;
            }
            this.currentPrivileges.add(new MySQLObjectPrivilege(privilege, false));
        }
        this.drawColumns(this.currentPrivileges);
    }

    private void drawColumns(List<?> objects) {
        this.tableViewer.setInput(objects);
        this.tableViewer.refresh();
        this.columnsController.repackColumns();
    }

    public void checkPrivilege(MySQLPrivilege privilege, boolean grant) {
        for (MySQLObjectPrivilege basePrivilege : this.currentPrivileges) {
            if (basePrivilege.privilege != privilege) continue;
            basePrivilege.enabled = grant;
        }
        this.drawColumns(this.currentPrivileges);
    }

    private class MySQLObjectPrivilege {
        private MySQLPrivilege privilege;
        private boolean enabled;

        MySQLObjectPrivilege(MySQLPrivilege privilege, boolean enabled) {
            this.privilege = privilege;
            this.enabled = enabled;
        }
    }
}

