/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.sql.registry.SQLGeneratorConfigurationRegistry;
import org.jkiss.dbeaver.model.sql.registry.SQLGeneratorDescriptor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class SQLGenerator<OBJECT>
extends DBRRunnableWithResult<String> {
    protected List<OBJECT> objects;
    private boolean fullyQualifiedNames = true;
    private boolean compactSQL = false;
    private boolean showComments = true;
    private boolean showPermissions = false;
    private boolean showFullDdl = false;
    private boolean excludeAutoGeneratedColumn = false;
    private boolean useCustomDataFormat = false;
    private boolean useSeparateForeignKeys = true;
    private boolean showPartitionsDDL = false;
    private boolean showCastParams = false;
    private final Map<String, Object> generatorOptions = new LinkedHashMap<String, Object>();

    public void initGenerator(List<OBJECT> objects) {
        this.objects = objects;
    }

    public List<OBJECT> getObjects() {
        return this.objects;
    }

    public boolean isFullyQualifiedNames() {
        return this.fullyQualifiedNames;
    }

    public void setFullyQualifiedNames(boolean fullyQualifiedNames) {
        this.fullyQualifiedNames = fullyQualifiedNames;
    }

    public boolean isCompactSQL() {
        return this.compactSQL;
    }

    public void setCompactSQL(boolean compactSQL) {
        this.compactSQL = compactSQL;
    }

    public boolean isShowComments() {
        return this.showComments;
    }

    public void setShowComments(boolean showComments) {
        this.showComments = showComments;
    }

    public boolean isIncludePermissions() {
        return this.showPermissions;
    }

    public void setShowPermissions(boolean showPermissions) {
        this.showPermissions = showPermissions;
    }

    public boolean isShowFullDdl() {
        return this.showFullDdl;
    }

    public void setShowFullDdl(boolean showFullDdl) {
        this.showFullDdl = showFullDdl;
    }

    public boolean isExcludeAutoGeneratedColumn() {
        return this.excludeAutoGeneratedColumn;
    }

    public void setExcludeAutoGeneratedColumn(boolean excludeAutoGeneratedColumn) {
        this.excludeAutoGeneratedColumn = excludeAutoGeneratedColumn;
    }

    public boolean isUseCustomDataFormat() {
        return this.useCustomDataFormat;
    }

    public void setUseCustomDataFormat(boolean useCustomDataFormat) {
        this.useCustomDataFormat = useCustomDataFormat;
    }

    public boolean isUseSeparateForeignKeys() {
        return this.useSeparateForeignKeys;
    }

    public void setUseSeparateForeignKeys(boolean useSeparateForeignKeys) {
        this.useSeparateForeignKeys = useSeparateForeignKeys;
    }

    public boolean isShowPartitionsDDL() {
        return this.showPartitionsDDL;
    }

    public void setShowPartitionsDDL(boolean showPartitionsDDL) {
        this.showPartitionsDDL = showPartitionsDDL;
    }

    public boolean isShowCastParams() {
        return this.showCastParams;
    }

    public void setShowCastParams(boolean showCastParams) {
        this.showCastParams = showCastParams;
    }

    public boolean isDDLOption() {
        return false;
    }

    public boolean isDMLOption() {
        return false;
    }

    public boolean isInsertOption() {
        return false;
    }

    public boolean supportCastParams() {
        return false;
    }

    public Object getGeneratorOption(String name) {
        return this.generatorOptions.get(name);
    }

    public void setGeneratorOption(String name, Object value) {
        if (value == null) {
            this.generatorOptions.remove(name);
        } else {
            this.generatorOptions.put(name, value);
        }
    }

    public boolean hasOptions() {
        return true;
    }

    protected String getLineSeparator() {
        return this.compactSQL ? " " : "\n";
    }

    protected String getEntityName(DBSEntity entity) {
        if (this.fullyQualifiedNames) {
            return DBUtils.getObjectFullName((DBPNamedObject)entity, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        return DBUtils.getQuotedIdentifier((DBSObject)entity);
    }

    protected void addOptions(Map<String, Object> options) {
        options.put("ddl.source", true);
        options.put("useFQN", this.isFullyQualifiedNames());
        options.put("script.format.compact", this.isCompactSQL());
        options.put("ddl.includePermissions", this.isIncludePermissions());
        options.put("ddl.includeComments", this.isShowComments());
        options.put("ddl.includeNestedObjects", this.isShowFullDdl());
        options.put("script.exclude.autogenerated.column", this.isExcludeAutoGeneratedColumn());
        options.put("script.use.custom.data.format", this.isUseCustomDataFormat());
        options.put("ddl.separateForeignKeys", this.isUseSeparateForeignKeys());
        options.put("ddl.includePartitions", this.isShowPartitionsDDL());
        options.put("sql.castParameter", this.isShowCastParams());
        options.putAll(this.generatorOptions);
    }

    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SQLGeneratorDescriptor descriptor = SQLGeneratorConfigurationRegistry.getInstance().getGeneratorDescriptor(this);
        StringBuilder sql = new StringBuilder(100);
        try {
            for (OBJECT object : this.objects) {
                if (object instanceof DBPObject && !descriptor.appliesTo((DBPObject)object)) continue;
                this.generateSQL(monitor, sql, object);
            }
        }
        catch (DBException e) {
            throw new InvocationTargetException(e);
        }
        this.result = sql.toString();
    }

    protected abstract void generateSQL(DBRProgressMonitor var1, StringBuilder var2, OBJECT var3) throws DBException;
}

