/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources.bookmarks;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;
import org.jkiss.dbeaver.ui.resources.bookmarks.BookmarkStorage;
import org.jkiss.dbeaver.ui.resources.bookmarks.DBNBookmark;
import org.jkiss.dbeaver.ui.resources.bookmarks.DBNBookmarkFolder;
import org.jkiss.dbeaver.utils.ResourceUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class BookmarksHandlerImpl
extends AbstractResourceHandler {
    private static final String BOOKMARK_EXT = "bm";

    public static IFolder getBookmarksFolder(DBPProject project, boolean forceCreate) {
        return DBPPlatformDesktop.getInstance().getWorkspace().getResourceDefaultRoot(project, BookmarksHandlerImpl.class, forceCreate);
    }

    public int getFeatures(IResource resource) {
        if (resource instanceof IFile) {
            return 11;
        }
        return super.getFeatures(resource);
    }

    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        if (resource instanceof IFolder) {
            return "bookmark folder";
        }
        return "bookmark";
    }

    @NotNull
    public DBNResource makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) throws CoreException, DBException {
        if (resource instanceof IFile) {
            return new DBNBookmark(parentNode, resource, (DBPResourceHandler)this);
        }
        return new DBNBookmarkFolder(parentNode, resource, (DBPResourceHandler)this);
    }

    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        if (!(resource instanceof IFile)) {
            super.openResource(resource);
            return;
        }
        DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(resource.getProject());
        if (projectNode == null) {
            throw new DBException("Can't find project node for '" + resource.getProject().getName() + "'");
        }
        BookmarkStorage storage = new BookmarkStorage((IFile)resource, false);
        try {
            DBPDataSourceContainer dataSourceContainer = projectNode.getDatabases().getDataSourceRegistry().getDataSource(storage.getDataSourceId());
            if (dataSourceContainer == null) {
                throw new DBException("Can't find datasource '" + storage.getDataSourceId() + "'");
            }
            DBNDataSource dsNode = (DBNDataSource)DBNUtils.getNodeByObject((DBSObject)dataSourceContainer);
            if (dsNode == null) {
                throw new DBException("Can't find datasource node for '" + dataSourceContainer.getName() + "'");
            }
            dsNode.initializeNode(null, status -> {
                if (status.isOK()) {
                    UIUtils.syncExec(() -> BookmarksHandlerImpl.openNodeByPath(dsNode, (IFile)resource, storage));
                } else {
                    DBWorkbench.getPlatformUI().showError("Open bookmark", "Can't open bookmark", status);
                }
            });
        }
        finally {
            storage.dispose();
        }
    }

    public List<DBPDataSourceContainer> getAssociatedDataSources(DBNResource resource) {
        DBPDataSourceContainer dataSource;
        DBPDataSourceRegistry dataSourceRegistry;
        if (resource instanceof DBNBookmark && (dataSourceRegistry = resource.getOwnerProject().getDataSourceRegistry()) != null && (dataSource = dataSourceRegistry.getDataSource(((DBNBookmark)resource).getStorage().getDataSourceId())) != null) {
            return Collections.singletonList(dataSource);
        }
        return super.getAssociatedDataSources(resource);
    }

    private static void openNodeByPath(DBNDataSource dsNode, IFile file, BookmarkStorage storage) {
        try {
            BookmarkNodeLoader nodeLoader = new BookmarkNodeLoader(dsNode, storage, file);
            UIUtils.runInProgressService((DBRRunnableWithProgress)nodeLoader);
            if (nodeLoader.databaseNode != null) {
                UIUtils.syncExec(() -> {
                    IEditorPart iEditorPart = NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)bookmarkNodeLoader.databaseNode, null, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow());
                });
            }
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(CoreMessages.model_project_open_bookmark, CoreMessages.model_project_cant_open_bookmark, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void navigateNodeByPath(NavigatorViewBase view, DBNDataSource dsNode, BookmarkStorage storage) {
        try {
            BookmarkNodeLoader nodeLoader = new BookmarkNodeLoader(dsNode, storage, null);
            UIUtils.runInProgressService((DBRRunnableWithProgress)nodeLoader);
            if (nodeLoader.databaseNode != null) {
                UIUtils.syncExec(() -> view.showNode((DBNNode)bookmarkNodeLoader.databaseNode));
            }
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(CoreMessages.model_project_open_bookmark, CoreMessages.model_project_cant_open_bookmark, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void createBookmark(DBNDatabaseNode node, String title, IFolder folder) throws DBException {
        DBPProject project;
        if (folder == null && (project = node.getOwnerProject()) != null) {
            folder = BookmarksHandlerImpl.getBookmarksFolder(project, true);
        }
        if (folder == null) {
            throw new DBException("Can't detect folder for bookmark");
        }
        ResourceUtils.checkFolderExists((IFolder)folder);
        IFile file = ResourceUtils.getUniqueFile((IFolder)folder, (String)CommonUtils.escapeFileName((String)title), (String)BOOKMARK_EXT);
        BookmarksHandlerImpl.updateBookmark(node, title, file);
    }

    private static void updateBookmark(DBNDatabaseNode node, String title, IFile file) throws DBException {
        if (CommonUtils.isEmpty((String)title)) {
            title = node.getNodeName();
        }
        ArrayList<String> nodePath = new ArrayList<String>();
        DBNDatabaseNode parent = node;
        while (!(parent instanceof DBNDataSource)) {
            nodePath.add(0, parent.getNodeName());
            parent = parent.getParentNode();
        }
        String dsId = null;
        if (node.getObject() != null && node.getObject().getDataSource() != null) {
            dsId = node.getObject().getDataSource().getContainer().getId();
        }
        BookmarkStorage storage = new BookmarkStorage(title, String.valueOf(node.getNodeType()) + " " + node.getNodeName(), node.getNodeIconDefault(), dsId, nodePath);
        try {
            ByteArrayInputStream data = storage.serialize();
            file.create((InputStream)data, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            throw new DBException("Error saving bookmark", (Throwable)e);
        }
    }

    private static class BookmarkNodeLoader
    implements DBRRunnableWithProgress {
        private final DBNDataSource dsNode;
        private final BookmarkStorage storage;
        private final IFile file;
        private DBNDatabaseNode databaseNode;

        BookmarkNodeLoader(DBNDataSource dsNode, BookmarkStorage storage, IFile file) {
            this.dsNode = dsNode;
            this.storage = storage;
            this.file = file;
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
            block10: {
                try {
                    DBNDataSource currentNode = this.dsNode;
                    List<String> dataSourcePath = this.storage.getDataSourcePath();
                    for (String path : dataSourcePath) {
                        Object nextChild = null;
                        Object[] children = currentNode.getChildren(monitor);
                        if (!ArrayUtils.isEmpty((Object[])children)) {
                            Object[] objectArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object node = objectArray[n2];
                                if (path.equals(node.getNodeName())) {
                                    nextChild = node;
                                    break;
                                }
                                ++n2;
                            }
                        }
                        if (nextChild == null) {
                            throw new DBException("Can't find node '" + path + "' in '" + currentNode.getNodeFullName() + "'");
                        }
                        currentNode = nextChild;
                    }
                    if (currentNode instanceof DBNDatabaseNode) {
                        if (this.file != null) {
                            this.storage.setImage(currentNode.getNodeIconDefault());
                            this.file.setContents((InputStream)this.storage.serialize(), true, false, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
                        }
                        this.databaseNode = (DBNDatabaseNode)currentNode;
                        break block10;
                    }
                    if (currentNode != null) {
                        throw new DBException("Node '" + currentNode.getNodeFullName() + "' is not a database object");
                    }
                    throw new DBException("Can't find database node by path");
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
    }
}

